/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.thread.ThreadPool;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CachedSampleModel
extends AbstractSampleModel {
    private static final Logger logger = Logger.getLogger(CachedSampleModel.class.getName());
    private static final int MIN_PART_ARRAY_LEN = 16;
    protected final LockFactory lockFactory;
    protected final boolean fair;
    protected final int partSize;
    protected final int maxLoadedParts;
    private volatile long samples;
    private volatile int partCount;
    private volatile Part[] parts;
    private int loadCount;
    private Part firstLoad;
    private Part lastLoad;
    private Part firstMod;
    private Part lastMod;
    private final SampleBuffer emptyBuf;

    public CachedSampleModel(int channels, float frameRate, long samples, int partSize, int maxLoadedParts, LockFactory lockFactory, boolean fair, boolean flushAsync, ThreadPool writerThreadPool, SampleBuffer emptyBuf) throws InterruptedException {
        super(channels, frameRate);
        Part[] partArray;
        int numParts;
        if (samples < 0L) {
            throw new IllegalArgumentException("Invalid number of samples: " + samples);
        }
        if (partSize < 1) {
            throw new IllegalArgumentException("Invalid part size: " + partSize);
        }
        this.partSize = partSize;
        this.maxLoadedParts = maxLoadedParts;
        this.lockFactory = lockFactory;
        this.fair = fair;
        this.emptyBuf = emptyBuf;
        this.loadCount = 0;
        this.firstLoad = null;
        this.lastLoad = null;
        this.firstMod = null;
        this.lastMod = null;
        if (samples > 0L) {
            numParts = 1 + (int)((samples - 1L) / (long)partSize);
            partArray = new Part[Math.max(16, numParts * 2)];
            long start = 0L;
            for (int i = 0; i < numParts; ++i) {
                Part part;
                long end = start + (long)partSize;
                partArray[i] = part = this.createPart(start, end);
                start = end;
            }
        } else {
            numParts = 0;
            partArray = new Part[16];
        }
        this.parts = partArray;
        this.partCount = numParts;
        this.samples = samples;
        if (flushAsync) {
            writerThreadPool.start((Runnable)new Writer());
        }
    }

    protected Part createPart(long start, long end) {
        ReadWriteLock lock = this.lockFactory.createReadWriteLock(this.fair);
        return new Part(start, end, lock);
    }

    protected Part readLock(int p) throws IOException {
        Part part = this.parts[p];
        part.lock.lockRead();
        if (!part.loaded) {
            this.load(part);
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Part writeLock(int p) throws IOException {
        Part part = this.parts[p];
        part.lock.lockWrite();
        if (!part.loaded) {
            this.load(part);
        }
        if (!part.dirty) {
            part.dirty = true;
            CachedSampleModel cachedSampleModel = this;
            synchronized (cachedSampleModel) {
                part.prevMod = this.lastMod;
                if (this.lastMod == null) {
                    this.firstMod = part;
                } else {
                    this.lastMod.nextMod = part;
                }
                this.lastMod = part;
            }
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Part writeLockReplace(int p) throws IOException {
        Part part = this.parts[p];
        part.lock.lockWrite();
        if (!part.loaded) {
            this.alloc(part);
            part.loaded = true;
        }
        if (!part.dirty) {
            part.dirty = true;
            CachedSampleModel cachedSampleModel = this;
            synchronized (cachedSampleModel) {
                part.prevMod = this.lastMod;
                if (this.lastMod == null) {
                    this.firstMod = part;
                } else {
                    this.lastMod.nextMod = part;
                }
                this.lastMod = part;
            }
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void alloc(Part p) throws IOException {
        if (this.loadCount < this.maxLoadedParts) {
            p.buf = this.alloc(this.partSize);
            if (this.lastLoad == null) {
                this.firstLoad = p;
            } else {
                this.lastLoad.nextLoad = p;
            }
            p.prevLoad = this.lastLoad;
            this.lastLoad = p;
            ++this.loadCount;
            return;
        }
        Part o = this.firstLoad;
        while (true) {
            if (o.lock.tryLockWrite()) {
                try {
                    if (o.dirty) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Flushing part: model=" + (Object)((Object)this) + ", part=" + o);
                        }
                        this.save(o);
                        if (o == this.firstMod) {
                            this.firstMod = o.nextMod;
                            if (this.firstMod == null) {
                                this.lastMod = null;
                            } else {
                                this.firstMod.prevMod = null;
                            }
                            o.nextMod = null;
                        } else if (o.prevMod != null) {
                            o.prevMod.nextMod = o.nextMod;
                            if (o.nextMod == null) {
                                this.lastMod = o.prevMod;
                            } else {
                                o.nextMod.prevMod = o.prevMod;
                                o.nextMod = null;
                            }
                            o.prevMod = null;
                        }
                    }
                    o.loaded = false;
                    if (o.prevLoad == null) {
                        this.firstLoad = o.nextLoad;
                    } else {
                        o.prevLoad.nextLoad = o.nextLoad;
                    }
                    if (o.nextLoad == null) {
                        this.lastLoad = o.prevLoad;
                    } else {
                        o.nextLoad.prevLoad = o.prevLoad;
                    }
                    o.prevLoad = null;
                    o.nextLoad = null;
                    p.buf = o.buf;
                    o.buf = null;
                    if (this.lastLoad == null) {
                        this.firstLoad = p;
                    } else {
                        this.lastLoad.nextLoad = p;
                    }
                    p.prevLoad = this.lastLoad;
                    this.lastLoad = p;
                    return;
                }
                finally {
                    o.lock.unlockWrite();
                }
            }
            o = o.nextLoad;
            if (o != null) continue;
            o = this.firstLoad;
        }
    }

    protected abstract SampleBuffer alloc(int var1);

    private synchronized void load(Part p) throws IOException {
        if (p.loaded) {
            return;
        }
        this.alloc(p);
        if (!p.dirty) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Loading part: model=" + (Object)((Object)this) + ", part=" + p);
            }
            if (p.end <= this.samples) {
                this.load(p.ofs, p.buf, 0, this.partSize);
            } else {
                long n = this.samples - p.ofs;
                if (n > 0L) {
                    this.load(p.ofs, p.buf, 0, (int)n);
                }
            }
        }
        p.loaded = true;
    }

    protected abstract void load(long var1, SampleBuffer var3, int var4, int var5) throws IOException;

    private synchronized void save(Part p) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Saving part: model=" + (Object)((Object)this) + ", part=" + p);
        }
        if (p.loaded) {
            if (p.end <= this.samples) {
                this.save(p.ofs, p.buf, 0, this.partSize);
            } else {
                long n = this.samples - p.ofs;
                if (n > 0L) {
                    this.save(p.ofs, p.buf, 0, (int)n);
                }
            }
        } else if (p.end <= this.samples) {
            this.save(p.ofs, this.emptyBuf, 0, this.partSize);
        } else {
            long n = this.samples - p.ofs;
            if (n > 0L) {
                this.save(p.ofs, this.emptyBuf, 0, (int)n);
            }
        }
        p.dirty = false;
    }

    protected abstract void save(long var1, SampleBuffer var3, int var4, int var5) throws IOException;

    public boolean isReadOnly() {
        return false;
    }

    public boolean isEmpty() {
        return this.samples < 1L;
    }

    public boolean isModelEmpty() {
        return this.samples < 1L;
    }

    public long getSamples() {
        return this.samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(long i) throws IOException {
        long num = this.samples;
        if (i < 0L || i >= num) {
            throw new IOException("Invalid sample index: i=" + i + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        Part a = this.readLock(p);
        try {
            float f = a.buf.getFloat(x);
            return f;
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(long i) throws IOException {
        long num = this.samples;
        if (i < 0L || i >= num) {
            throw new IOException("Invalid sample index: i=" + i + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        Part a = this.readLock(p);
        try {
            double d = a.buf.getDouble(x);
            return d;
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, double[] dst, int off, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.readLock(p);
            try {
                a.buf.get(x, dst, off, len);
            }
            finally {
                a.lock.unlockRead();
            }
        }
        int n = this.partSize - x;
        Part a = this.readLock(p);
        try {
            a.buf.get(x, dst, off, n);
        }
        finally {
            a.lock.unlockRead();
        }
        off += n;
        len -= n;
        while (len > this.partSize) {
            a = this.readLock(++p);
            try {
                a.buf.get(0, dst, off, this.partSize);
            }
            finally {
                a.lock.unlockRead();
            }
            off += this.partSize;
            len -= this.partSize;
        }
        a = this.readLock(++p);
        try {
            a.buf.get(0, dst, off, len);
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, float[] dst, int off, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.readLock(p);
            try {
                a.buf.get(x, dst, off, len);
            }
            finally {
                a.lock.unlockRead();
            }
        }
        int n = this.partSize - x;
        Part a = this.readLock(p);
        try {
            a.buf.get(x, dst, off, n);
        }
        finally {
            a.lock.unlockRead();
        }
        off += n;
        len -= n;
        while (len > this.partSize) {
            a = this.readLock(++p);
            try {
                a.buf.get(0, dst, off, this.partSize);
            }
            finally {
                a.lock.unlockRead();
            }
            off += this.partSize;
            len -= this.partSize;
        }
        a = this.readLock(++p);
        try {
            a.buf.get(0, dst, off, len);
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.readLock(p);
            try {
                a.buf.get(x, dst, len);
            }
            finally {
                a.lock.unlockRead();
            }
        }
        int n = this.partSize - x;
        Part a = this.readLock(p);
        try {
            a.buf.get(x, dst, n);
        }
        finally {
            a.lock.unlockRead();
        }
        len -= n;
        while (len > this.partSize) {
            a = this.readLock(++p);
            try {
                a.buf.get(0, dst, this.partSize);
            }
            finally {
                a.lock.unlockRead();
            }
            len -= this.partSize;
        }
        a = this.readLock(++p);
        try {
            a.buf.get(0, dst, len);
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.readLock(p);
            try {
                a.buf.get(x, dst, len);
            }
            finally {
                a.lock.unlockRead();
            }
        }
        int n = this.partSize - x;
        Part a = this.readLock(p);
        try {
            a.buf.get(x, dst, n);
        }
        finally {
            a.lock.unlockRead();
        }
        len -= n;
        while (len > this.partSize) {
            a = this.readLock(++p);
            try {
                a.buf.get(0, dst, this.partSize);
            }
            finally {
                a.lock.unlockRead();
            }
            len -= this.partSize;
        }
        a = this.readLock(++p);
        try {
            a.buf.get(0, dst, len);
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.readLock(p);
            try {
                dst.set(off, a.buf, x, len);
            }
            finally {
                a.lock.unlockRead();
            }
        }
        int n = this.partSize - x;
        Part a = this.readLock(p);
        try {
            dst.set(off, a.buf, x, n);
        }
        finally {
            a.lock.unlockRead();
        }
        off += n;
        len -= n;
        while (len > this.partSize) {
            a = this.readLock(++p);
            try {
                dst.set(off, a.buf, 0, this.partSize);
            }
            finally {
                a.lock.unlockRead();
            }
            off += this.partSize;
            len -= this.partSize;
        }
        a = this.readLock(++p);
        try {
            dst.set(off, a.buf, 0, len);
        }
        finally {
            a.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, float v) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample index: i=" + i);
        }
        long num = this.samples;
        if (i >= num) {
            this.append((int)(i + 1L - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, v);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, double v) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample index: i=" + i);
        }
        long num = this.samples;
        if (i >= num) {
            this.append((int)(i + 1L - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, v);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, float[] src, int off, int len) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len);
        }
        long num = this.samples;
        if (i + (long)len > num) {
            this.append((int)(i + (long)len - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.writeLock(p);
            try {
                a.buf.set(x, src, off, len);
            }
            finally {
                a.lock.unlockWrite();
            }
        }
        int n = this.partSize - x;
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, src, off, n);
        }
        finally {
            a.lock.unlockWrite();
        }
        off += n;
        len -= n;
        while (len > this.partSize) {
            a = this.writeLockReplace(++p);
            try {
                a.buf.set(0, src, off, this.partSize);
            }
            finally {
                a.lock.unlockWrite();
            }
            off += this.partSize;
            len -= this.partSize;
        }
        a = this.writeLock(++p);
        try {
            a.buf.set(0, src, off, len);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, double[] src, int off, int len) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len);
        }
        long num = this.samples;
        if (i + (long)len > num) {
            this.append((int)(i + (long)len - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.writeLock(p);
            try {
                a.buf.set(x, src, off, len);
            }
            finally {
                a.lock.unlockWrite();
            }
        }
        int n = this.partSize - x;
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, src, off, n);
        }
        finally {
            a.lock.unlockWrite();
        }
        off += n;
        len -= n;
        while (len > this.partSize) {
            a = this.writeLockReplace(++p);
            try {
                a.buf.set(0, src, off, this.partSize);
            }
            finally {
                a.lock.unlockWrite();
            }
            off += this.partSize;
            len -= this.partSize;
        }
        a = this.writeLock(++p);
        try {
            a.buf.set(0, src, off, len);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, FloatBuffer src, int len) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len);
        }
        long num = this.samples;
        if (i + (long)len > num) {
            this.append((int)(i + (long)len - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.writeLock(p);
            try {
                a.buf.set(x, src, len);
            }
            finally {
                a.lock.unlockWrite();
            }
        }
        int n = this.partSize - x;
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, src, n);
        }
        finally {
            a.lock.unlockWrite();
        }
        len -= n;
        while (len > this.partSize) {
            a = this.writeLockReplace(++p);
            try {
                a.buf.set(0, src, this.partSize);
            }
            finally {
                a.lock.unlockWrite();
            }
            len -= this.partSize;
        }
        a = this.writeLock(++p);
        try {
            a.buf.set(0, src, len);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len);
        }
        long num = this.samples;
        if (i + (long)len > num) {
            this.append((int)(i + (long)len - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.writeLock(p);
            try {
                a.buf.set(x, src, len);
            }
            finally {
                a.lock.unlockWrite();
            }
        }
        int n = this.partSize - x;
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, src, n);
        }
        finally {
            a.lock.unlockWrite();
        }
        len -= n;
        while (len > this.partSize) {
            a = this.writeLockReplace(++p);
            try {
                a.buf.set(0, src, this.partSize);
            }
            finally {
                a.lock.unlockWrite();
            }
            len -= this.partSize;
        }
        a = this.writeLock(++p);
        try {
            a.buf.set(0, src, len);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        if (i < 0L) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len);
        }
        long num = this.samples;
        if (i + (long)len > num) {
            this.append((int)(i + (long)len - num), true);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.writeLock(p);
            try {
                a.buf.set(x, src, off, len);
            }
            finally {
                a.lock.unlockWrite();
            }
        }
        int n = this.partSize - x;
        Part a = this.writeLock(p);
        try {
            a.buf.set(x, src, off, n);
        }
        finally {
            a.lock.unlockWrite();
        }
        off += n;
        len -= n;
        while (len > this.partSize) {
            a = this.writeLockReplace(++p);
            try {
                a.buf.set(0, src, off, this.partSize);
            }
            finally {
                a.lock.unlockWrite();
            }
            off += this.partSize;
            len -= this.partSize;
        }
        a = this.writeLock(++p);
        try {
            a.buf.set(0, src, off, len);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(long i, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (x + len <= this.partSize) {
            Part a = this.writeLock(p);
            try {
                a.buf.clear(x, len);
            }
            finally {
                a.lock.unlockWrite();
            }
        }
        int n = this.partSize - x;
        Part a = this.writeLock(p);
        try {
            a.buf.clear(x, n);
        }
        finally {
            a.lock.unlockWrite();
        }
        len -= n;
        while (len > this.partSize) {
            a = this.writeLockReplace(++p);
            try {
                a.buf.clear(0, this.partSize);
            }
            finally {
                a.lock.unlockWrite();
            }
            len -= this.partSize;
        }
        a = this.writeLock(++p);
        try {
            a.buf.clear(0, len);
        }
        finally {
            a.lock.unlockWrite();
        }
    }

    public synchronized long append(double[] src, int off, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, off, len);
        return i;
    }

    public synchronized long append(DoubleBuffer src, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, len);
        return i;
    }

    public synchronized long append(float[] src, int off, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, off, len);
        return i;
    }

    public synchronized long append(FloatBuffer src, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, len);
        return i;
    }

    public synchronized long append(SampleBuffer src, int off, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, off, len);
        return i;
    }

    public long append(int len) throws IOException {
        return this.append(len, false);
    }

    private synchronized long append(int len, boolean notify) throws IOException {
        int newPartCount;
        int n;
        Part part;
        if (len < 1) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        long i = this.samples;
        int p = (int)(i / (long)this.partSize);
        int x = (int)(i % (long)this.partSize);
        if (p < this.partCount) {
            part = this.writeLock(p);
            part.lock.unlockWrite();
            n = this.partSize - x;
            if (len <= n) {
                this.samples += (long)len;
                return i;
            }
            this.samples += (long)n;
            len -= n;
        }
        if (notify && this.partCount > 0) {
            part = this.parts[this.partCount - 1];
            if (part != null && part.dirty && part != this.firstMod && part.prevMod == null) {
                if (this.lastMod == null) {
                    this.firstMod = part;
                } else {
                    this.lastMod.nextMod = part;
                }
                part.prevMod = this.lastMod;
                this.lastMod = part;
            }
            ((Object)((Object)this)).notify();
        }
        if (this.parts.length < (newPartCount = this.partCount + 1 + (len - 1) / this.partSize)) {
            Part[] newParts = new Part[Math.max(newPartCount, this.partCount * 2)];
            System.arraycopy(this.parts, 0, newParts, 0, this.partCount);
            this.parts = newParts;
        }
        long start = this.partCount * this.partSize;
        for (n = this.partCount; n < newPartCount; ++n) {
            long end = start + (long)this.partSize;
            part = this.createPart(start, end);
            part.dirty = true;
            this.parts[n] = part;
            if (notify && n < newPartCount - 1) {
                if (this.lastMod == null) {
                    this.firstMod = part;
                } else {
                    this.lastMod.nextMod = part;
                }
                part.prevMod = this.lastMod;
                this.lastMod = part;
            }
            start = end;
        }
        this.partCount = newPartCount;
        this.samples += (long)len;
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushAsync() throws IOException {
        while (true) {
            Part p;
            CachedSampleModel cachedSampleModel = this;
            synchronized (cachedSampleModel) {
                p = this.firstMod;
                if (p == null) {
                    if (this.partCount < 0) {
                        return;
                    }
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (p.nextMod == null) {
                    this.lastMod = null;
                } else {
                    p.nextMod.prevMod = null;
                }
                this.firstMod = p.nextMod;
                p.nextMod = null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Flushing part (async): model=" + (Object)((Object)this) + ", part=" + p);
            }
            p.lock.lockRead();
            try {
                if (!p.dirty) continue;
                this.save(p);
                continue;
            }
            finally {
                p.lock.unlockRead();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Flushing model: " + (Object)((Object)this));
        }
        Part p = this.firstMod;
        while (p != null) {
            p.lock.lockRead();
            try {
                if (p.dirty) {
                    this.save(p);
                }
            }
            finally {
                p.lock.unlockRead();
            }
            Part np = p.nextMod;
            p.prevMod = null;
            p.nextMod = null;
            p = np;
        }
        this.firstMod = null;
        this.lastMod = null;
        for (int i = 0; i < this.partCount; ++i) {
            p = this.parts[i];
            p.lock.lockRead();
            try {
                if (!p.dirty) continue;
                this.save(p);
                continue;
            }
            finally {
                p.lock.unlockRead();
            }
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing model: " + (Object)((Object)this));
        }
        this.samples = -1L;
        this.partCount = -1;
        this.parts = null;
        this.loadCount = 0;
        this.firstLoad = null;
        this.lastLoad = null;
        this.firstMod = null;
        this.lastMod = null;
        ((Object)((Object)this)).notifyAll();
    }

    protected synchronized void keep(Part p) {
        if (p == this.lastLoad) {
            return;
        }
        p.nextLoad.prevLoad = p.prevLoad;
        if (p.prevLoad == null) {
            this.firstLoad = p.nextLoad;
        } else {
            p.prevLoad.nextLoad = p.nextLoad;
        }
        p.prevLoad = this.lastLoad;
        p.nextLoad = null;
        this.lastLoad.nextLoad = p;
        this.lastLoad = p;
    }

    public synchronized void insert(long i, int len) throws IOException {
        if (len < 1) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        long num = this.samples;
        if (i < 0L || i > num) {
            throw new IOException("Invalid sample insert index: i=" + i + ", samples=" + num);
        }
        throw new UnsupportedOperationException();
    }

    public synchronized void remove(long i, int len) throws IOException {
        if (len < 1) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        throw new UnsupportedOperationException();
    }

    public synchronized void checkConsistency() {
        Part p;
        if (this.samples < 0L) {
            throw new RuntimeException("Invalid number of samples: " + this.samples);
        }
        if (this.samples > (long)(this.partCount * this.partSize)) {
            throw new RuntimeException("Invalid number of samples: " + this.samples + " > " + this.partCount * this.partSize);
        }
        long pos = 0L;
        for (int i = 0; i < this.partCount; ++i) {
            p = this.parts[i];
            if (p.ofs != pos) {
                throw new RuntimeException("Invalid part ofs: " + p.ofs + " != " + pos);
            }
            if (p.end != (pos += (long)this.partSize)) {
                throw new RuntimeException("Invalid part end: " + p.end + " != " + pos);
            }
            if (p.loaded) {
                if (p.buf != null) continue;
                throw new RuntimeException("Invalid loaded part #" + i + ", buf=" + p.buf);
            }
            if (p.buf == null) continue;
            throw new RuntimeException("Invalid unloaded part #" + i + ", buf=" + p.buf);
        }
        HashSet<Part> loadSet = new HashSet<Part>();
        p = this.firstLoad;
        int loadedParts = 0;
        while (p != null) {
            if (!p.loaded) {
                throw new RuntimeException("Invalid loaded part: " + p + ", loaded=" + p.loaded);
            }
            if (p.buf == null) {
                throw new RuntimeException("Invalid loaded part: " + p + ", buf=" + p.buf);
            }
            if (!loadSet.add(p)) {
                throw new RuntimeException("Duplicate loaded part: " + p);
            }
            ++loadedParts;
            p = p.nextLoad;
        }
        if (this.loadCount != loadedParts) {
            throw new RuntimeException("Invalid number of loaded parts: " + this.loadCount + " != " + loadedParts);
        }
        if (this.loadCount > this.maxLoadedParts) {
            throw new RuntimeException("Invalid number of loaded parts: " + this.loadCount + " > " + this.maxLoadedParts);
        }
        HashSet<Part> modSet = new HashSet<Part>();
        p = this.firstMod;
        Part prevMod = null;
        int modifiedParts = 0;
        while (p != null) {
            if (!p.dirty) {
                throw new RuntimeException("Invalid modified part: " + p + ", dirty=" + p.dirty);
            }
            if (!modSet.add(p)) {
                throw new RuntimeException("Duplicate modified part: " + p);
            }
            if (p.prevMod != prevMod) {
                throw new RuntimeException("Invalid modified part: " + p + ", prev=" + p.prevMod + " != " + prevMod);
            }
            ++modifiedParts;
            prevMod = p;
            p = p.nextMod;
        }
        if (modifiedParts > this.loadCount) {
            throw new RuntimeException("Invalid number of modified parts: " + modifiedParts + " > " + this.loadCount);
        }
    }

    protected class Writer
    implements Runnable {
        protected Writer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Async writer started: " + (Object)((Object)CachedSampleModel.this));
                }
                CachedSampleModel.this.flushAsync();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Async writer stopped: " + (Object)((Object)CachedSampleModel.this));
                }
            }
        }
    }

    protected class Part {
        protected final long ofs;
        protected final long end;
        protected final ReadWriteLock lock;
        protected SampleBuffer buf;
        boolean dirty;
        boolean loaded;
        Part prevLoad;
        Part nextLoad;
        Part prevMod;
        Part nextMod;

        public Part(long ofs, long end, ReadWriteLock lock) {
            this.ofs = ofs;
            this.end = end;
            this.lock = lock;
        }

        public String toString() {
            return "Part[ofs=" + this.ofs + ", end=" + this.end + "]";
        }
    }
}

