/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Data;
import com.spacekiller.util.Resource;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.AbstractLineChunk;
import com.waxmonster.model.impl.CachedSampleModel;
import com.waxmonster.model.impl.CachedTimecodeChunk;
import com.waxmonster.model.impl.TimecodeFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedTimecodeModel
extends CachedSampleModel
implements TimecodeModel {
    private static final Logger logger = Logger.getLogger(CachedTimecodeModel.class.getName());
    private final TimecodeFile timecodeFile;
    private boolean deleteOnClose;
    private String name;
    private Resource resource;
    private String[] trackIds;
    protected List chunks;
    private byte[] io;

    public CachedTimecodeModel(float frameRate, long samples, int partSize, int maxLoadedParts, LockFactory lockFactory, boolean fair, boolean flushAsync, ThreadPool writerThreadPool, TimecodeFile timecodeFile, boolean deleteOnClose) throws InterruptedException {
        super(1, frameRate, samples, partSize, maxLoadedParts, lockFactory, fair, flushAsync, writerThreadPool, CachedTimecodeModel.createEmptyBuf(partSize, frameRate));
        this.deleteOnClose = deleteOnClose;
        this.timecodeFile = timecodeFile;
        this.io = new byte[partSize * 8];
    }

    public String toString() {
        return super.toString() + "[timecodeFile=" + this.timecodeFile + "]";
    }

    public TimecodeFile getTimecodeFile() {
        return this.timecodeFile;
    }

    public boolean isDeleteOnClose() {
        return this.deleteOnClose;
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose = deleteOnClose;
    }

    private static SampleBuffer createEmptyBuf(int partSize, float frameRate) {
        return new DoubleArraySampleBuffer(1, partSize, frameRate, new double[partSize]);
    }

    @Override
    protected SampleBuffer alloc(int samples) {
        return new DoubleArraySampleBuffer(1, samples, this.frameRate, new double[samples]);
    }

    @Override
    protected synchronized void load(long pos, SampleBuffer dst, int off, int len) throws IOException {
        double[] arr = ((DoubleArraySampleBuffer)dst).array();
        int byteLen = len * 8;
        this.timecodeFile.read(pos, this.io, 0, byteLen);
        for (int o = 0; o < byteLen; o += 8) {
            arr[off++] = Data.getDouble((byte[])this.io, (int)o);
        }
    }

    @Override
    protected synchronized void save(long pos, SampleBuffer src, int off, int len) throws IOException {
        double[] arr = ((DoubleArraySampleBuffer)src).array();
        int byteLen = len * 8;
        for (int o = 0; o < byteLen; o += 8) {
            Data.setDouble((byte[])this.io, (int)o, (double)arr[off++]);
        }
        this.timecodeFile.write(pos, this.io, 0, byteLen);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        this.timecodeFile.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        File file;
        super.close();
        this.timecodeFile.close();
        if (this.deleteOnClose && (file = this.timecodeFile.getFile()) != null && file.exists()) {
            if (file.delete()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Timecode file deleted: " + file);
                }
            } else {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Deleting timecode file on exit: " + file);
                }
                file.deleteOnExit();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    public long getFrameLength() {
        return this.getSamples();
    }

    public long getUnitLength() {
        return this.getSamples();
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    public long getNanoLength() {
        return (long)Math.ceil(LineUtil.getNanoPos((long)this.getSamples(), (double)this.frameRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(double framePos, double fpu, double[] dst, int off, int len) throws IOException {
        if (framePos < 0.0) {
            throw new IOException("Invalid frame position: " + framePos);
        }
        if (fpu <= 0.0) {
            throw new IOException("Invalid frames per unit: " + fpu);
        }
        long samples = this.getSamples();
        if ((long)(framePos + (double)(len - 1) * fpu) >= samples) {
            throw new IOException("Invalid sample range: framePos=" + framePos + ", fpu=" + fpu + ", len=" + len + ", samples=" + samples);
        }
        long i = (long)framePos;
        int p = (int)(i / (long)this.partSize);
        double d = framePos - (double)(p * this.partSize);
        int end = off + len;
        while (off < end) {
            if (d < (double)this.partSize) {
                CachedSampleModel.Part a = this.readLock(p);
                try {
                    SampleBuffer sb = a.buf;
                    while (d < (double)this.partSize && off < end) {
                        dst[off++] = sb.getDouble((int)d);
                        d += fpu;
                    }
                }
                finally {
                    a.lock.unlockRead();
                }
            }
            ++p;
            d -= (double)this.partSize;
        }
    }

    protected final synchronized void chunkCreated(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(chunk);
    }

    protected final synchronized void chunkClosed(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            return;
        }
        this.chunks.remove(chunk);
    }

    public final synchronized int getChunkCount() {
        return this.chunks == null ? 0 : this.chunks.size();
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        CachedTimecodeChunk chunk = new CachedTimecodeChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, this);
        this.chunkCreated(chunk);
        return chunk;
    }
}

