/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.impl.ChunkAudioModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class ChunkFadeAudioModel
extends ChunkAudioModel
implements AudioModel {
    public static final double NORMAL = 1.0;
    protected double volume = 1.0;
    protected long fadeIn = this.intro;
    protected double deltaIn;
    protected long fadeOut = this.outro;
    protected double deltaOut;

    public ChunkFadeAudioModel(LineChunk chunk, long unitLen, SampleModel model, long modelOfs, long modelEnd) {
        super(chunk, unitLen, model, modelOfs, modelEnd);
    }

    @Override
    public String toString() {
        return super.toString() + "[volume=" + this.volume + ", fadeIn=" + this.fadeIn + ", fadeOut=" + this.fadeOut + "]";
    }

    @Override
    public long getSamples() {
        return this.unitLen * (long)this.channels;
    }

    @Override
    public long getFrameLength() {
        return this.unitLen;
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void get(long i, double[] dst, int off, int len) throws IOException {
        int z;
        int n;
        if (len < 1) {
            return;
        }
        if (i < this.intro) {
            n = (int)Math.min((long)len, this.intro - i);
            z = off + n;
            while (off < z) {
                dst[off++] = 0.0;
            }
            if ((len -= n) < 1) {
                return;
            }
            i = this.intro;
        }
        if (i < this.outro) {
            int z2;
            int o;
            n = (int)Math.min((long)len, this.outro - i);
            this.model.get(this.modelOfs + i, dst, off, n);
            if (this.volume != 1.0) {
                double v = this.volume;
                int o2 = off;
                int z3 = off + n;
                while (o2 < z3) {
                    int n2 = o2++;
                    dst[n2] = dst[n2] * v;
                }
            }
            if (i < this.fadeIn) {
                o = off;
                z2 = off + (int)Math.min((long)n, this.fadeIn - i);
                double v = (double)(i - this.intro + 1L) * this.deltaIn;
                while (o < z2) {
                    int n3 = o++;
                    dst[n3] = dst[n3] * v;
                    v += this.deltaIn;
                }
            }
            if (i + (long)n > this.fadeOut) {
                o = off + (int)Math.max(0L, this.fadeOut - i);
                z2 = off + n;
                double v = 1.0 - (double)(this.outro - i - (long)n + 1L) * this.deltaOut;
                while (o < z2) {
                    int n4 = o++;
                    dst[n4] = dst[n4] * v;
                    v -= this.deltaOut;
                }
            }
            if ((len -= n) < 1) {
                return;
            }
            off += n;
        }
        z = off + len;
        while (off < z) {
            dst[off++] = 0.0;
        }
    }

    @Override
    public void get(long i, float[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public long getFadeIn() {
        return this.fadeIn;
    }

    public void setFadeIn(long fadeIn) {
        if (fadeIn < this.intro) {
            fadeIn = this.intro;
        }
        if (this.fadeIn == fadeIn) {
            return;
        }
        this.fadeIn = fadeIn;
        this.computeDeltaIn();
    }

    protected void computeDeltaIn() {
        long n = this.fadeIn - this.intro;
        this.deltaIn = n < 1L ? 0.0 : 1.0 / (double)(n + 1L);
    }

    public long getFadeOut() {
        return this.fadeOut;
    }

    public void setFadeOut(long fadeOut) {
        if (fadeOut > this.outro) {
            fadeOut = this.outro;
        }
        if (this.fadeOut == fadeOut) {
            return;
        }
        this.fadeOut = fadeOut;
        this.computeDeltaOut();
    }

    protected void computeDeltaOut() {
        long n = this.outro - this.fadeOut;
        this.deltaOut = n < 1L ? 0.0 : 1.0 / (double)(n + 1L);
    }
}

