/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.impl.ChunkLineModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public abstract class ChunkSampleModel
extends ChunkLineModel
implements SampleModel {
    protected int channels;
    protected float unitRate;
    protected long unitLen;
    protected SampleModel model;
    protected long modelOfs;
    protected long modelEnd;
    protected long intro;
    protected long outro;
    protected double none;

    public ChunkSampleModel(LineChunk chunk, long unitLen, SampleModel model, long modelOfs, long modelEnd) {
        super(chunk);
        this.channels = model.getChannels();
        this.unitRate = model.getFrameRate();
        this.unitLen = unitLen;
        this.model = model;
        this.modelOfs = modelOfs;
        this.modelEnd = modelEnd;
        this.intro = modelOfs < 0L ? -modelOfs : 0L;
        this.outro = modelOfs < 0L ? this.intro + modelEnd : this.intro + modelEnd - modelOfs;
    }

    public String toString() {
        return super.toString() + "[modelOfs=" + this.modelOfs + ", modelEnd=" + this.modelEnd + ", model=" + this.model + "]";
    }

    public SampleModel getSampleModel() {
        return this.model;
    }

    public int getChannels() {
        return this.channels;
    }

    public float getUnitRate() {
        return this.unitRate;
    }

    public long getUnitLength() {
        return this.unitLen;
    }

    public long getSamples() {
        return this.unitLen * (long)this.channels;
    }

    public long getNanoLength() {
        return (long)Math.ceil(LineUtil.getNanoPos((long)this.unitLen, (double)this.unitRate));
    }

    public boolean isModelEmpty() {
        return this.unitLen < 1L;
    }

    public boolean isEmpty() {
        return this.unitLen < 1L;
    }

    public float getFrameRate() {
        return this.unitRate;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        int n;
        if (len < 1) {
            return;
        }
        if (i < this.intro) {
            n = (int)Math.min((long)len, this.intro - i);
            dst.fill(off, n, this.none);
            if ((len -= n) < 1) {
                return;
            }
            off += n;
            i = this.intro;
        }
        if (i < this.outro) {
            n = (int)Math.min((long)len, this.outro - i);
            this.model.get(this.modelOfs + i, dst, off, n);
            if ((len -= n) < 1) {
                return;
            }
            off += n;
        }
        dst.fill(off, len, this.none);
    }

    public void get(long i, double[] dst, int off, int len) throws IOException {
        int z;
        double v;
        int n;
        if (len < 1) {
            return;
        }
        if (i < this.intro) {
            n = (int)Math.min((long)len, this.intro - i);
            v = this.none;
            z = off + n;
            while (off < z) {
                dst[off++] = v;
            }
            if ((len -= n) < 1) {
                return;
            }
            i = this.intro;
        }
        if (i < this.outro) {
            n = (int)Math.min((long)len, this.outro - i);
            this.model.get(this.modelOfs + i, dst, off, n);
            if ((len -= n) < 1) {
                return;
            }
            off += n;
        }
        v = this.none;
        z = off + len;
        while (off < z) {
            dst[off++] = v;
        }
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        int z;
        float v;
        int n;
        if (len < 1) {
            return;
        }
        if (i < this.intro) {
            n = (int)Math.min((long)len, this.intro - i);
            v = (float)this.none;
            z = off + n;
            while (off < z) {
                dst[off++] = v;
            }
            if ((len -= n) < 1) {
                return;
            }
            i = this.intro;
        }
        if (i < this.outro) {
            n = (int)Math.min((long)len, this.outro - i);
            this.model.get(this.modelOfs + i, dst, off, n);
            if ((len -= n) < 1) {
                return;
            }
            off += n;
        }
        v = (float)this.none;
        z = off + len;
        while (off < z) {
            dst[off++] = v;
        }
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        double v;
        int n;
        if (len < 1) {
            return;
        }
        if (i < this.intro) {
            n = (int)Math.min((long)len, this.intro - i);
            v = this.none;
            len -= n;
            while (n-- > 0) {
                dst.put(v);
            }
            if (len < 1) {
                return;
            }
            i = this.intro;
        }
        if (i < this.outro) {
            n = (int)Math.min((long)len, this.outro - i);
            this.model.get(this.modelOfs + i, dst, n);
            if ((len -= n) < 1) {
                return;
            }
        }
        v = this.none;
        while (len-- > 0) {
            dst.put(v);
        }
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        float v;
        int n;
        if (len < 1) {
            return;
        }
        if (i < this.intro) {
            n = (int)Math.min((long)len, this.intro - i);
            v = (float)this.none;
            len -= n;
            while (n-- > 0) {
                dst.put(v);
            }
            if (len < 1) {
                return;
            }
            i = this.intro;
        }
        if (i < this.outro) {
            n = (int)Math.min((long)len, this.outro - i);
            this.model.get(this.modelOfs + i, dst, n);
            if ((len -= n) < 1) {
                return;
            }
        }
        v = (float)this.none;
        while (len-- > 0) {
            dst.put(v);
        }
    }

    public double getDouble(long i) throws IOException {
        if (i < this.intro) {
            return this.none;
        }
        if (i < this.outro) {
            return this.model.getDouble(this.modelOfs + i);
        }
        return this.none;
    }

    public float getFloat(long i) throws IOException {
        if (i < this.intro) {
            return (float)this.none;
        }
        if (i < this.outro) {
            return this.model.getFloat(this.modelOfs + i);
        }
        return (float)this.none;
    }

    public long getIntro() {
        return this.intro;
    }

    protected void setIntro(long intro) {
        this.intro = intro;
    }

    public long getOutro() {
        return this.outro;
    }

    protected void setOutro(long outro) {
        this.outro = outro;
    }
}

