/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.waxmonster.model.ChunkInterval;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.impl.AbstractLineChunk;

public class DefaultChunkInterval
implements ChunkInterval {
    protected long ofs;
    protected long end;
    protected AbstractLineChunk[] chunks;
    protected int count;
    protected int chunkHash;

    public DefaultChunkInterval(long ofs, long end, int initCapacity) {
        this.ofs = ofs;
        this.end = end;
        this.chunks = new AbstractLineChunk[initCapacity];
    }

    public String toString() {
        return super.toString() + "[ofs=" + LineUtil.humanNanos((long)this.ofs) + ", end=" + LineUtil.humanNanos((long)this.end) + ", chunks=" + this.count + "]";
    }

    public long getOfs() {
        return this.ofs;
    }

    protected void setOfs(long ofs) {
        this.ofs = ofs;
    }

    public long getEnd() {
        return this.end;
    }

    protected void setEnd(long end) {
        this.end = end;
    }

    public int getChunkCount() {
        return this.count;
    }

    public LineChunk getChunkAt(int index) {
        return this.chunks[index];
    }

    public LineChunk getLastChunk() {
        return this.chunks[this.count - 1];
    }

    public boolean containsChunk(LineChunk chunk) {
        AbstractLineChunk chnk = (AbstractLineChunk)chunk;
        int i = this.getChunkIndex(chnk.zOrder);
        return i < this.count && this.chunks[i] == chunk;
    }

    public int getChunkIndex(LineChunk chunk) {
        AbstractLineChunk chnk = (AbstractLineChunk)chunk;
        int i = this.getChunkIndex(chnk.zOrder);
        if (i < this.count && this.chunks[i] == chunk) {
            return i;
        }
        return -1;
    }

    public int getChunkIndex(int zOrder) {
        int lo = 0;
        int hi = this.count - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            int z = this.chunks[i].zOrder;
            if (z == zOrder) {
                lo = i;
                break;
            }
            if (z < zOrder) {
                lo = i + 1;
                continue;
            }
            hi = i - 1;
        }
        return lo;
    }

    protected boolean addChunk(AbstractLineChunk chunk) {
        int i = this.getChunkIndex(chunk.zOrder);
        if (i < this.count && this.chunks[i] == chunk) {
            return false;
        }
        this.addChunkAt(chunk, i);
        return true;
    }

    protected boolean removeChunk(AbstractLineChunk chunk) {
        int i = this.getChunkIndex(chunk.zOrder);
        if (i < this.count && this.chunks[i] == chunk) {
            this.removeChunkAt(i);
            return true;
        }
        return false;
    }

    protected void addChunkAt(AbstractLineChunk chunk, int index) {
        if (index < this.count) {
            if (this.count >= this.chunks.length) {
                AbstractLineChunk[] arr = new AbstractLineChunk[this.chunks.length * 2];
                if (index > 0) {
                    System.arraycopy(this.chunks, 0, arr, 0, index);
                }
                System.arraycopy(this.chunks, index, arr, index + 1, this.count - index);
                this.chunks = arr;
            } else {
                if (index > 0) {
                    System.arraycopy(this.chunks, 0, this.chunks, 0, index);
                }
                System.arraycopy(this.chunks, index, this.chunks, index + 1, this.count - index);
            }
        } else if (this.count >= this.chunks.length) {
            AbstractLineChunk[] arr = new AbstractLineChunk[this.chunks.length * 2];
            System.arraycopy(this.chunks, 0, arr, 0, this.count);
            this.chunks = arr;
        }
        this.chunks[index] = chunk;
        ++this.count;
        this.chunkHash ^= chunk.idHash;
    }

    protected void removeChunkAt(int index) {
        this.chunkHash ^= this.chunks[index].idHash;
        --this.count;
        if (index < this.count) {
            System.arraycopy(this.chunks, index + 1, this.chunks, index, this.count - index);
        }
        this.chunks[this.count] = null;
    }

    public int getChunkHash() {
        return this.chunkHash;
    }

    public boolean equalsChunks(ChunkInterval interval) {
        return this.equalsChunks((DefaultChunkInterval)interval);
    }

    public boolean equalsChunks(DefaultChunkInterval interval) {
        if (this.chunkHash == interval.chunkHash && this.count == interval.count) {
            AbstractLineChunk[] arr = interval.chunks;
            for (int i = 0; i < this.count; ++i) {
                if (this.chunks[i] == arr[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

