/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.waxmonster.model.ChunkConsumer;
import com.waxmonster.model.ChunkInterval;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.impl.AbstractLineChunk;
import com.waxmonster.model.impl.DefaultChunkInterval;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Logger;

public class DefaultChunkModel
implements MutableChunkModel {
    private static final Logger logger = Logger.getLogger(DefaultChunkModel.class.getName());
    private static final ChunkListener[] NO_LISTENERS = new ChunkListener[0];
    protected final ReadWriteLock lock;
    protected ChunkListener[] listeners;
    protected AbstractLineChunk[] chunks;
    protected int chunkCount;
    protected DefaultChunkInterval[] inters;
    protected int interCount;
    protected int initIntervalChunkCapacity = 2;
    protected boolean dirty;

    public DefaultChunkModel(ReadWriteLock lock, int initChunkCapacity, int initIntervalCapacity) {
        this.lock = lock;
        this.listeners = NO_LISTENERS;
        this.chunks = new AbstractLineChunk[initChunkCapacity];
        this.inters = new DefaultChunkInterval[initIntervalCapacity];
    }

    public String toString() {
        return super.toString() + "[chunks=" + this.chunkCount + ", intervals=" + this.interCount + "]";
    }

    public final ReadWriteLock getLock() {
        return this.lock;
    }

    public synchronized void registerChunkListener(ChunkListener listener) {
        if (listener == null) {
            return;
        }
        int n = this.listeners.length;
        ChunkListener[] a = new ChunkListener[n + 1];
        if (n > 0) {
            System.arraycopy(this.listeners, 0, a, 0, n);
        }
        a[n] = listener;
        this.listeners = a;
    }

    public synchronized void unregisterChunkListener(ChunkListener listener) {
        if (listener == null) {
            return;
        }
        int n = this.listeners.length;
        for (int i = 0; i < n; ++i) {
            if (this.listeners[i] != listener) continue;
            if (n > 1) {
                ChunkListener[] a = new ChunkListener[--n];
                if (i > 0) {
                    System.arraycopy(this.listeners, 0, a, 0, i);
                }
                if (i < n) {
                    System.arraycopy(this.listeners, i + 1, a, i, n - i);
                }
                this.listeners = a;
            } else {
                this.listeners = NO_LISTENERS;
            }
            return;
        }
    }

    protected void fireChunkAdded(LineChunk chunk, int index) {
        ChunkListener[] a = this.listeners;
        int n = a.length;
        int i = 0;
        while (i < n) {
            a[i++].chunkAdded(chunk, index);
        }
    }

    protected void fireChunkRemoved(LineChunk chunk, int index) {
        ChunkListener[] a = this.listeners;
        int n = a.length;
        int i = 0;
        while (i < n) {
            a[i++].chunkRemoved(chunk, index);
        }
    }

    protected void fireChunkMoved(LineChunk chunk, int index, int oldIndex, long oldOfs, long oldEnd) {
        ChunkListener[] a = this.listeners;
        int n = a.length;
        int i = 0;
        while (i < n) {
            a[i++].chunkMoved(chunk, index, oldIndex, oldOfs, oldEnd);
        }
    }

    protected void fireChunksChanged(long ofs, long end) {
        ChunkListener[] a = this.listeners;
        int n = a.length;
        int i = 0;
        while (i < n) {
            a[i++].chunksChanged(ofs, end);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChunkCount() {
        try {
            this.lock.lockRead();
            int n = this.chunkCount;
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineChunk getChunkAt(int index) {
        try {
            this.lock.lockRead();
            AbstractLineChunk abstractLineChunk = this.chunks[index];
            return abstractLineChunk;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineChunk[] getChunks(LineChunk[] arr) {
        try {
            this.lock.lockRead();
            int num = this.chunkCount;
            if (arr.length != num) {
                arr = (LineChunk[])Array.newInstance(arr.getClass().getComponentType(), num);
            }
            System.arraycopy(this.chunks, 0, arr, 0, num);
            LineChunk[] lineChunkArray = arr;
            return lineChunkArray;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChunk(LineChunk chunk) {
        try {
            this.lock.lockRead();
            boolean bl = this.hasChunk(chunk);
            return bl;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected boolean hasChunk(LineChunk chunk) {
        AbstractLineChunk chnk = (AbstractLineChunk)chunk;
        int zOrder = chnk.zOrder;
        return zOrder < this.chunkCount && zOrder >= 0 && this.chunks[zOrder] == chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChunkIndex(LineChunk chunk) {
        try {
            this.lock.lockRead();
            int n = this.chunkIndex(chunk);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected int chunkIndex(LineChunk chunk) {
        AbstractLineChunk chnk = (AbstractLineChunk)chunk;
        int zOrder = chnk.zOrder;
        return zOrder < this.chunkCount && zOrder >= 0 && this.chunks[zOrder] == chunk ? zOrder : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkInterval[] getIntervals(ChunkInterval[] arr) {
        try {
            this.lock.lockRead();
            int num = this.interCount;
            if (arr.length != num) {
                arr = (ChunkInterval[])Array.newInstance(arr.getClass().getComponentType(), num);
            }
            System.arraycopy(this.inters, 0, arr, 0, arr.length);
            ChunkInterval[] chunkIntervalArray = arr;
            return chunkIntervalArray;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntervals(long lineOfs, long lineEnd, ChunkInterval[] dst, int x, int z) {
        try {
            int e;
            this.lock.lockRead();
            int o = this.intervalIndex(lineOfs);
            if (o > 0 && lineOfs < this.inters[o - 1].end) {
                --o;
            }
            if (o < (e = this.intervalIndex(lineEnd))) {
                int n = this.getIntervals(o, e, dst, x, z);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected int getIntervals(int o, int e, ChunkInterval[] dst, int x, int z) {
        int v = z - x;
        int n = e - o;
        if (v > n) {
            v = n;
        }
        if (v > 0) {
            System.arraycopy(this.inters, o, dst, x, v);
        }
        if (v < n) {
            return -1;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntervals(ChunkConsumer dst) {
        try {
            this.lock.lockRead();
            int n = this.getIntervals(0, this.interCount, dst);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntervals(long lineOfs, long lineEnd, ChunkConsumer dst) {
        try {
            int z;
            this.lock.lockRead();
            int x = this.intervalIndex(lineOfs);
            if (x > 0 && lineOfs < this.inters[x - 1].end) {
                --x;
            }
            if (x < (z = this.intervalIndex(lineEnd))) {
                int n = this.getIntervals(x, z, dst);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected int getIntervals(int x, int z, ChunkConsumer dst) {
        int o = x;
        while (x < z && dst.consume((ChunkInterval)this.inters[x])) {
            ++x;
        }
        return x - o;
    }

    protected void zOrder(AbstractLineChunk[] arr, int off, int end) {
        while (off < end) {
            arr[off].zOrder = off;
            ++off;
        }
    }

    protected DefaultChunkInterval createChunkInterval(long ofs, long end) {
        return new DefaultChunkInterval(ofs, end, this.initIntervalChunkCapacity);
    }

    protected DefaultChunkInterval createChunkInterval(long ofs, long end, int minChunkCapacity) {
        return new DefaultChunkInterval(ofs, end, Math.max(minChunkCapacity, this.initIntervalChunkCapacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addChunk(LineChunk chunk) {
        int index;
        if (chunk == null) {
            return -1;
        }
        try {
            this.lock.lockWrite();
            if (this.hasChunk(chunk)) {
                int n = -1;
                return n;
            }
            index = this.chunkCount;
            this.insChunk(chunk, index);
            this.dirty = true;
            this.fireChunkAdded(chunk, index);
        }
        finally {
            this.lock.unlockWrite();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunkAt(LineChunk chunk, int index) {
        if (chunk == null) {
            return false;
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        try {
            this.lock.lockWrite();
            if (index > this.chunkCount) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            if (this.hasChunk(chunk)) {
                boolean bl = false;
                return bl;
            }
            this.insChunk(chunk, index);
            this.dirty = true;
            this.fireChunkAdded(chunk, index);
        }
        finally {
            this.lock.unlockWrite();
        }
        return true;
    }

    private void insChunk(LineChunk chunk, int index) {
        int z;
        DefaultChunkInterval inter;
        AbstractLineChunk chnk = (AbstractLineChunk)chunk;
        if (this.chunkCount < this.chunks.length) {
            if (index < this.chunkCount) {
                System.arraycopy(this.chunks, index, this.chunks, index + 1, this.chunkCount - index);
            }
            this.chunks[index] = chnk;
        } else {
            AbstractLineChunk[] arr = new AbstractLineChunk[Math.max(this.chunkCount * 2, 1)];
            if (index > 0) {
                System.arraycopy(this.chunks, 0, arr, 0, index);
            }
            System.arraycopy(this.chunks, index, arr, index + 1, this.chunkCount - index);
            arr[index] = chnk;
            this.chunks = arr;
        }
        ++this.chunkCount;
        this.zOrder(this.chunks, index, this.chunkCount);
        long ofs = chnk.chunkOfs;
        long end = chnk.chunkEnd;
        if (end <= ofs) {
            return;
        }
        DefaultChunkInterval newInter = null;
        int x = this.intervalIndex(ofs + 1L);
        if (x > 0) {
            inter = this.inters[x - 1];
            if (inter.ofs == ofs) {
                newInter = inter;
                --x;
            } else if (inter.end > ofs) {
                newInter = this.createChunkInterval(ofs, inter.end, inter.count + 1);
                System.arraycopy(inter.chunks, 0, newInter.chunks, 0, inter.count);
                newInter.count = inter.count;
                inter.end = ofs;
                this.addIntervalAt(newInter, x);
            }
        }
        if (newInter == null) {
            newInter = this.createChunkInterval(ofs, x < this.interCount && this.inters[x].ofs < end ? this.inters[x].ofs : end);
            this.addIntervalAt(newInter, x);
        }
        if (newInter.end == end) {
            z = x + 1;
        } else {
            z = this.intervalIndex(end);
            if (z > 0) {
                inter = this.inters[z - 1];
                if (inter.end > end) {
                    newInter = this.createChunkInterval(inter.ofs, end, inter.count + 1);
                    System.arraycopy(inter.chunks, 0, newInter.chunks, 0, inter.count);
                    newInter.count = inter.count;
                    inter.ofs = end;
                    this.addIntervalAt(newInter, z - 1);
                } else if (inter.end < end) {
                    newInter = this.createChunkInterval(inter.end, end);
                    this.addIntervalAt(newInter, z);
                    ++z;
                }
            }
        }
        int i = x;
        while (i < z) {
            this.inters[i++].addChunk(chnk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeChunk(LineChunk chunk) {
        int index;
        try {
            this.lock.lockWrite();
            index = this.chunkIndex(chunk);
            if (index < 0) {
                int n = -1;
                return n;
            }
            this.delChunk(index);
            this.dirty = true;
            this.fireChunkRemoved(chunk, index);
        }
        finally {
            this.lock.unlockWrite();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineChunk removeChunkAt(int index) {
        LineChunk chunk;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        try {
            this.lock.lockWrite();
            if (index >= this.chunkCount) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            chunk = this.delChunk(index);
            this.dirty = true;
            this.fireChunkRemoved(chunk, index);
        }
        finally {
            this.lock.unlockWrite();
        }
        return chunk;
    }

    private LineChunk delChunk(int index) {
        DefaultChunkInterval after;
        DefaultChunkInterval inter;
        int i;
        AbstractLineChunk chnk = this.chunks[index];
        --this.chunkCount;
        if (index < this.chunkCount) {
            System.arraycopy(this.chunks, index + 1, this.chunks, index, this.chunkCount - index);
        }
        this.chunks[this.chunkCount] = null;
        long end = chnk.chunkEnd;
        long ofs = chnk.chunkOfs;
        if (end <= ofs) {
            this.zOrder(this.chunks, index, this.chunkCount);
            return chnk;
        }
        int x = this.intervalIndex(ofs);
        if (x >= this.interCount || this.inters[x].ofs != ofs) {
            throw new IllegalStateException("Start-Interval not found for chunk: " + chnk + ", interval #" + x + " != " + ofs);
        }
        int z = this.intervalIndex(end);
        if (z < 1 || this.inters[z - 1].end != end) {
            throw new IllegalStateException("End-Interval not found for chunk: " + chnk + ", interval #" + (z - 1) + " != " + end);
        }
        for (i = z - 1; i >= x; --i) {
            inter = this.inters[i];
            inter.removeChunk(chnk);
            if (inter.count >= 1) continue;
            this.removeIntervalAt(i);
            --z;
        }
        DefaultChunkInterval defaultChunkInterval = after = z < this.interCount ? this.inters[z] : null;
        if (x > 0) {
            --x;
        }
        for (i = z - 1; i >= x; --i) {
            inter = this.inters[i];
            if (after != null && after.ofs == inter.end && after.equalsChunks(inter)) {
                inter.end = after.end;
                this.removeIntervalAt(i + 1);
            }
            after = inter;
        }
        this.zOrder(this.chunks, index, this.chunkCount);
        return chnk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChunks() {
        try {
            this.lock.lockWrite();
            if (this.interCount > 0) {
                Arrays.fill(this.inters, 0, this.interCount, null);
                this.interCount = 0;
            }
            if (this.chunkCount > 0) {
                Arrays.fill(this.chunks, 0, this.chunkCount, null);
                this.chunkCount = 0;
                this.dirty = true;
                this.fireChunksChanged(Long.MIN_VALUE, Long.MAX_VALUE);
            }
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveChunk(LineChunk chunk, long newChunkOfs, long newChunkEnd, int newIndex) {
        if (newIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        try {
            this.lock.lockWrite();
            if (newIndex >= this.chunkCount) {
                throw new ArrayIndexOutOfBoundsException(newIndex);
            }
            AbstractLineChunk chnk = (AbstractLineChunk)chunk;
            int index = this.chunkIndex((LineChunk)chnk);
            if (index < 0) {
                boolean bl = false;
                return bl;
            }
            long ofs = chnk.chunkOfs;
            long end = chnk.chunkEnd;
            if (newChunkOfs == ofs && newChunkEnd == end && newIndex == index) {
                boolean bl = true;
                return bl;
            }
            this.delChunk(index);
            chnk.chunkOfs = newChunkOfs;
            chnk.chunkEnd = newChunkEnd;
            this.insChunk((LineChunk)chnk, newIndex);
            this.dirty = true;
            this.fireChunkMoved((LineChunk)chnk, newIndex, index, ofs, end);
        }
        finally {
            this.lock.unlockWrite();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minCapacity) {
        try {
            this.lock.lockWrite();
            if (minCapacity > this.chunks.length) {
                AbstractLineChunk[] arr = new AbstractLineChunk[minCapacity];
                System.arraycopy(this.chunks, 0, arr, 0, this.chunkCount);
                this.chunks = arr;
            }
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntervalCount() {
        try {
            this.lock.lockRead();
            int n = this.interCount;
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkInterval getIntervalAt(int index) {
        try {
            this.lock.lockRead();
            DefaultChunkInterval defaultChunkInterval = this.inters[index];
            return defaultChunkInterval;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntervalIndex(ChunkInterval interval) {
        try {
            this.lock.lockRead();
            int index = this.intervalIndex(((DefaultChunkInterval)interval).ofs);
            int n = index < this.interCount ? (this.inters[index] == interval ? index : -1) : -1;
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntervalIndex(long ofs) {
        try {
            this.lock.lockRead();
            int n = this.intervalIndex(ofs);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkInterval getInterval(long ofs) {
        try {
            int i;
            this.lock.lockRead();
            int n = i = ofs == Long.MAX_VALUE ? this.interCount - 1 : this.intervalIndex(ofs + 1L) - 1;
            if (i < 0) {
                DefaultChunkInterval defaultChunkInterval = this.interCount > 0 ? this.inters[0] : null;
                return defaultChunkInterval;
            }
            DefaultChunkInterval inter = this.inters[i];
            if (inter.end > ofs) {
                DefaultChunkInterval defaultChunkInterval = inter;
                return defaultChunkInterval;
            }
            DefaultChunkInterval defaultChunkInterval = ++i < this.interCount ? this.inters[i] : null;
            return defaultChunkInterval;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getIntervalsAround(long ofs, ChunkInterval[] dst) {
        try {
            int i;
            this.lock.lockRead();
            int n = i = ofs == Long.MAX_VALUE ? this.interCount - 1 : this.intervalIndex(ofs + 1L) - 1;
            if (i < 0) {
                dst[0] = null;
                dst[1] = null;
                dst[2] = this.interCount > 0 ? this.inters[0] : null;
            } else {
                DefaultChunkInterval inter = this.inters[i];
                if (inter.getEnd() > ofs) {
                    dst[0] = i > 0 ? this.inters[i - 1] : null;
                    dst[1] = inter;
                    dst[2] = i + 1 < this.interCount ? this.inters[i + 1] : null;
                } else {
                    dst[0] = inter;
                    dst[1] = null;
                    dst[2] = i + 1 < this.interCount ? this.inters[i + 1] : null;
                }
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected int intervalIndex(long ofs) {
        int lo = 0;
        int hi = this.interCount - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            long v = this.inters[i].ofs;
            if (v == ofs) {
                lo = i;
                break;
            }
            if (v < ofs) {
                lo = i + 1;
                continue;
            }
            hi = i - 1;
        }
        return lo;
    }

    protected int addInterval(DefaultChunkInterval interval) {
        int index = this.intervalIndex(interval.ofs);
        this.addIntervalAt(interval, index);
        return index;
    }

    protected void addIntervalAt(DefaultChunkInterval interval, int index) {
        if (index < this.interCount) {
            if (this.interCount >= this.inters.length) {
                DefaultChunkInterval[] arr = new DefaultChunkInterval[this.inters.length * 2];
                if (index > 0) {
                    System.arraycopy(this.inters, 0, arr, 0, index);
                }
                System.arraycopy(this.inters, index, arr, index + 1, this.interCount - index);
                this.inters = arr;
            } else {
                if (index > 0) {
                    System.arraycopy(this.inters, 0, this.inters, 0, index);
                }
                System.arraycopy(this.inters, index, this.inters, index + 1, this.interCount - index);
            }
        } else if (this.interCount >= this.inters.length) {
            DefaultChunkInterval[] arr = new DefaultChunkInterval[this.inters.length * 2];
            System.arraycopy(this.inters, 0, arr, 0, this.interCount);
            this.inters = arr;
        }
        this.inters[index] = interval;
        ++this.interCount;
    }

    protected int removeInterval(DefaultChunkInterval interval) {
        int index = this.intervalIndex(interval.ofs);
        if (index < this.interCount && this.inters[index] == interval) {
            this.removeIntervalAt(index);
            return index;
        }
        return -1;
    }

    protected void removeIntervalAt(int index) {
        --this.interCount;
        if (index < this.interCount) {
            System.arraycopy(this.inters, index + 1, this.inters, index, this.interCount - index);
        }
        this.inters[this.interCount] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long computeTimeLength() {
        try {
            this.lock.lockRead();
            if (this.interCount < 1) {
                long l = 0L;
                return l;
            }
            DefaultChunkInterval inter = this.inters[this.interCount - 1];
            int chunkCount = inter.count;
            if (chunkCount < 1) {
                long l = 0L;
                return l;
            }
            long max = 0L;
            for (int i = 0; i < chunkCount; ++i) {
                AbstractLineChunk chunk = inter.chunks[i];
                long lineEnd = chunk.computeLineEnd();
                if (lineEnd <= max) continue;
                max = lineEnd;
            }
            long l = max;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIntervals(int x, int z) {
        try {
            this.lock.lockRead();
            logger.info("Dump Intervals: " + x + ".." + (z - 1) + " -> " + this);
            for (int i = x; i < z; ++i) {
                DefaultChunkInterval inter = this.inters[i];
                logger.info(" - #" + i + ": ofs=" + LineUtil.humanNanos((long)inter.ofs) + ", end=" + LineUtil.humanNanos((long)inter.end) + ", chunks=" + inter.count);
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIntegrity() throws IllegalStateException {
        try {
            AbstractLineChunk chunk;
            DefaultChunkInterval inter;
            this.lock.lockRead();
            long prevEnd = Long.MIN_VALUE;
            for (int i = 0; i < this.interCount; ++i) {
                inter = this.inters[i];
                if (inter.ofs < prevEnd) {
                    throw new IllegalStateException("Invalid interval #" + i + ": ofs=" + inter.ofs + " < " + prevEnd);
                }
                if (inter.end <= inter.ofs) {
                    throw new IllegalStateException("Invalid interval #" + i + ": end=" + inter.end + " <= " + inter.ofs);
                }
                int numChunks = inter.count;
                if (numChunks < 1) {
                    throw new IllegalStateException("Invalid interval #" + i + ": chunks=" + numChunks + " < 1");
                }
                for (int k = 0; k < numChunks; ++k) {
                    chunk = inter.chunks[k];
                    if (chunk.chunkOfs > inter.ofs) {
                        throw new IllegalStateException("Invalid interval #" + i + ": chunkOfs #" + k + "=" + chunk.chunkOfs + " > " + inter.ofs);
                    }
                    if (chunk.chunkEnd < inter.end) {
                        throw new IllegalStateException("Invalid interval #" + i + ": chunkEnd #" + k + "=" + chunk.chunkEnd + " < " + inter.end);
                    }
                    if (k <= 0 || chunk.zOrder > inter.chunks[k - 1].zOrder) continue;
                    throw new IllegalStateException("Invalid chunk z-order #" + i + ": " + chunk.zOrder + " <= " + inter.chunks[k - 1].zOrder);
                }
                prevEnd = inter.end;
            }
            DefaultChunkInterval prevInter = null;
            for (int i = 1; i < this.interCount; ++i) {
                inter = this.inters[i];
                prevInter = this.inters[i - 1];
                if (inter.ofs != prevInter.end || !inter.equalsChunks(prevInter)) continue;
                throw new IllegalStateException("Obsolete interval #" + i + ": equalsChunks of previous interval: hash=" + inter.chunkHash + " == " + prevInter.chunkHash);
            }
            for (int i = 0; i < this.chunkCount; ++i) {
                chunk = this.chunks[i];
                long ofs = chunk.getChunkOfs();
                long end = chunk.getChunkEnd();
                if (end <= ofs) continue;
                if (chunk.zOrder != i) {
                    throw new IllegalStateException("Invalid chunk z-order: #" + chunk.zOrder + " != " + i);
                }
                int x = this.intervalIndex(ofs);
                if (x >= this.interCount || this.inters[x].ofs != ofs) {
                    throw new IllegalStateException("Missing chunk-start interval: #" + x + " != " + ofs);
                }
                int z = this.intervalIndex(end);
                if (z < 1 || this.inters[z - 1].end != end) {
                    throw new IllegalStateException("Missing chunk-end interval: #" + (z - 1) + " != " + end);
                }
                for (int k = x; k < z; ++k) {
                    inter = this.inters[k];
                    if (inter.containsChunk((LineChunk)chunk)) continue;
                    throw new IllegalStateException("Missing chunk in interval: #" + k + " != " + chunk);
                }
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }
}

