/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.NodeListener;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.TrackModel;
import com.spacekiller.util.midi.model.TrackNode;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractMidiModel;
import com.waxmonster.model.impl.DefaultMidiChunk;
import java.io.IOException;
import java.util.Collection;

public class DefaultMidiModel
extends AbstractMidiModel {
    public DefaultMidiModel(TrackModel trackModel, StateModel stateModel, TimeUnit timeUnit, LockFactory lockFactory, boolean fair) {
        super(trackModel, stateModel, lockFactory, fair);
        long lastTick;
        this.setTimeUnitImpl(timeUnit);
        TrackNode lastNode = (TrackNode)trackModel.getLast();
        if (lastNode != null && (lastTick = lastNode.getTick()) >= this.tickLen) {
            this.tickLen = lastTick + 1L;
        }
    }

    public String toString() {
        return super.toString() + "[trackModel=" + this.trackModel + "]";
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeUnit(TimeUnit timeUnit) {
        try {
            this.lock.lockWrite();
            this.setTimeUnitImpl(timeUnit);
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirst() {
        try {
            this.lock.lockRead();
            Node node = this.trackModel.getFirst();
            return node;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getLast() {
        try {
            this.lock.lockRead();
            Node node = this.trackModel.getLast();
            return node;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getAfter(long tick) {
        try {
            this.lock.lockRead();
            Node node = this.trackModel.getAfter(tick);
            return node;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getBefore(long tick) {
        try {
            this.lock.lockRead();
            Node node = this.trackModel.getBefore(tick);
            return node;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModelEmpty() {
        try {
            this.lock.lockRead();
            boolean bl = this.trackModel.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this.lock.lockRead();
            boolean bl = this.trackModel.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount() {
        try {
            this.lock.lockRead();
            int n = this.trackModel.getNodeCount();
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount(long ofs, long end) {
        try {
            this.lock.lockRead();
            int n = this.trackModel.getNodeCount(ofs, end);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodes(long ofs, long end, NodeConsumer dst) {
        try {
            this.lock.lockRead();
            int n = this.trackModel.getNodes(ofs, end, dst);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodes(long ofs, long end, Node[] dst, int x, int z) {
        try {
            this.lock.lockRead();
            int n = this.trackModel.getNodes(ofs, end, dst, x, z);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(TrackNode node) {
        long tick = node.getTick();
        try {
            this.lock.lockWrite();
            if (tick >= this.tickLen) {
                this.tickLen = tick + 1L;
            }
            boolean bl = this.trackModel.addNode(node);
            return bl;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNodes(long ofs, long end, Collection nodes) {
        if (nodes.isEmpty()) {
            return 0;
        }
        try {
            long lastTick;
            Node lastNode;
            this.lock.lockWrite();
            int num = this.trackModel.addNodes(ofs, end, nodes);
            if (num > 0 && (lastNode = this.trackModel.getLast()) != null && (lastTick = lastNode.getTick()) >= this.tickLen) {
                this.tickLen = lastTick + 1L;
            }
            int n = num;
            return n;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(TrackNode node) throws IllegalArgumentException {
        try {
            this.lock.lockWrite();
            boolean bl = this.trackModel.removeNode(node);
            return bl;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeNodes(long ofs, long end) {
        try {
            this.lock.lockWrite();
            int n = this.trackModel.removeNodes(ofs, end);
            return n;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeNodes(long ofs, long end, NodeConsumer dst) {
        try {
            this.lock.lockWrite();
            int n = this.trackModel.removeNodes(ofs, end, dst);
            return n;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mergeMidiModel(long ofs, long end, TrackModel src, TimeUnit srcUnit, long srcOfs, long srcEnd) {
        try {
            this.lock.lockWrite();
            int n = this.mergeMidiModelImpl(ofs, end, src, srcUnit, srcOfs, srcEnd);
            return n;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void registerNodeListener(NodeListener listener) {
        this.trackModel.registerNodeListener(listener);
    }

    public void unregisterNodeListener(NodeListener listener) {
        this.trackModel.unregisterNodeListener(listener);
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        DefaultMidiChunk chunk = new DefaultMidiChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, this);
        this.chunkCreated(chunk);
        return chunk;
    }
}

