/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Resource;
import com.spacekiller.util.TimeUnit;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MidiTrack;
import com.waxmonster.model.impl.AbstractLineTrack;
import java.io.IOException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Track;

public class DefaultMidiTrack
extends AbstractLineTrack
implements MidiTrack {
    private String trackName;
    private TimeUnit timeUnit;
    private long tickLength;
    private long eventCount;
    private Track track;
    private MidiModel midiModel;

    public DefaultMidiTrack(Resource resource, String trackId, String trackName, TimeUnit timeUnit, MidiModel model) {
        super(resource, trackId);
        this.trackName = trackName;
        this.timeUnit = timeUnit;
        this.midiModel = model;
        this.eventCount = model.getNodeCount();
        this.tickLength = model.getTickLength();
    }

    public DefaultMidiTrack(Resource resource, String trackId, String trackName, TimeUnit timeUnit, Track track) {
        super(resource, trackId);
        MidiEvent lastEvent;
        this.trackName = trackName;
        this.timeUnit = timeUnit;
        this.track = track;
        int num = track.size();
        this.eventCount = num;
        long tickLen = 0L;
        if (num > 0 && (lastEvent = track.get(num - 1)) != null) {
            tickLen = lastEvent.getTick() + 1L;
        }
        this.tickLength = tickLen;
    }

    @Override
    public String toString() {
        return super.toString() + "[trackName=" + this.trackName + ", eventCount=" + this.eventCount + "]";
    }

    public String getTrackName() {
        return this.trackName;
    }

    protected void setTrackName(String trackName) {
        this.trackName = trackName;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    protected void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public long getTickLength() {
        return this.tickLength;
    }

    protected void setTickLength(long tickLength) {
        this.tickLength = tickLength;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    protected void setEventCount(long eventCount) {
        this.eventCount = eventCount;
    }

    protected Track getTrack() {
        return this.track;
    }

    protected void setTrack(Track track) {
        this.track = track;
    }

    protected MidiModel getMidiModel() {
        return this.midiModel;
    }

    protected void setMidiModel(MidiModel midiModel) {
        this.midiModel = midiModel;
    }

    public void dispose() throws IOException {
        this.track = null;
        MidiModel model = this.midiModel;
        if (model != null) {
            this.midiModel = null;
            model.close();
        }
    }
}

