/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.waxmonster.model.impl.TimecodeFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.Arrays;

public class DefaultTimecodeFile
implements TimecodeFile {
    public static final String TIMECODE_FILE_EXTENSION = ".wlt";
    private static final byte[] HEADER_MAGIC = "WlTc".getBytes();
    private static final byte[] HEADER_MAGIC_OLD = "TIMC".getBytes();
    private static final int VERSION = 1;
    private static final int HEADER_LENGTH = 20;
    private File file;
    private RandomAccessFile raf;
    private long dataOfs;
    private float frameRate;
    private long frameLength;

    public DefaultTimecodeFile(File file, float frameRate) throws IOException {
        this.file = file;
        this.frameRate = frameRate;
        this.frameLength = 0L;
        this.dataOfs = 20L;
        this.raf = new RandomAccessFile(file, "rw");
        this.raf.setLength(0L);
        this.writeHeader();
    }

    public DefaultTimecodeFile(File file, boolean readOnly) throws IOException {
        this.file = file;
        String mode = readOnly ? "r" : "rw";
        this.raf = new RandomAccessFile(file, mode);
        this.readHeader();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public synchronized void read(long framePosition, byte[] buf, int off, int len) throws IOException {
        if (framePosition < 0L) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        this.raf.seek(this.dataOfs + framePosition * 8L);
        this.raf.readFully(buf, off, len);
    }

    @Override
    public synchronized void write(long framePosition, byte[] buf, int off, int len) throws IOException {
        if (framePosition < 0L) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        this.raf.seek(this.dataOfs + framePosition * 8L);
        this.raf.write(buf, off, len);
        long z = framePosition + (long)(len / 8);
        if (z > this.frameLength) {
            this.frameLength = z;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    protected synchronized void writeHeader() throws IOException {
        this.raf.seek(0L);
        this.raf.write(HEADER_MAGIC);
        this.raf.writeInt(1);
        this.raf.writeFloat(this.frameRate);
        this.raf.writeLong(this.dataOfs);
    }

    protected synchronized void readHeader() throws IOException {
        this.raf.seek(0L);
        byte[] magic = new byte[HEADER_MAGIC.length];
        this.raf.readFully(magic);
        if (!Arrays.equals(magic, HEADER_MAGIC) && !Arrays.equals(magic, HEADER_MAGIC_OLD)) {
            throw new StreamCorruptedException("Invalid timecode file: " + this.file);
        }
        int ver = this.raf.readInt();
        if (ver != 1) {
            throw new StreamCorruptedException("Unsupported timecode file version: " + ver + " != " + 1);
        }
        this.frameRate = this.raf.readFloat();
        this.dataOfs = this.raf.readLong();
        if (this.dataOfs < 20L) {
            throw new StreamCorruptedException("Invalid timecode data offset: " + this.dataOfs);
        }
        this.frameLength = (this.raf.length() - this.dataOfs) / 8L;
    }

    @Override
    public float getFrameRate() {
        return this.frameRate;
    }

    @Override
    public long getFrameLength() {
        return this.frameLength;
    }

    public String toString() {
        return super.toString() + "[" + this.file + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTimecodeFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.seek(0L);
            if (raf.length() < (long)HEADER_MAGIC.length) {
                boolean bl = false;
                return bl;
            }
            byte[] magic = new byte[HEADER_MAGIC.length];
            raf.readFully(magic);
            boolean bl = Arrays.equals(magic, HEADER_MAGIC) || Arrays.equals(magic, HEADER_MAGIC_OLD);
            return bl;
        }
        finally {
            raf.close();
        }
    }
}

