/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.ChannelSampleModel;
import com.spacekiller.util.sound.CubicInterpolatedSampleModel;
import com.spacekiller.util.sound.MonoMixedSampleModel;
import com.spacekiller.util.sound.MultiChannelSampleModel;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.impl.ChunkAudioModel;
import com.waxmonster.model.impl.ChunkSampleModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.impl.MergedSampleModel;
import java.io.IOException;

public class MergedAudioModel
extends MergedSampleModel
implements AudioModel {
    public MergedAudioModel(DefaultChunkModel chunkModel, ReadWriteLock lock, float unitRate, int channels, int maxParts) {
        super(chunkModel, lock, unitRate, channels, maxParts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrameLength() {
        try {
            this.lock.lockRead();
            long l = this.unitLen;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSamples() {
        long unitLen;
        try {
            this.lock.lockRead();
            unitLen = this.unitLen;
        }
        finally {
            this.lock.unlockRead();
        }
        return unitLen * (long)this.channels;
    }

    public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SampleModel createConvertedModel(SampleModel src) {
        SampleModel[] models;
        int mc = src.getChannels();
        if (mc < 1) {
            return null;
        }
        if (mc != this.channels && this.channels == 1) {
            src = new MonoMixedSampleModel(src, false);
            mc = 1;
        }
        if (src.getFrameRate() != this.unitRate) {
            if (mc == 1) {
                src = new CubicInterpolatedSampleModel(this.unitRate, src, false);
            } else {
                models = new SampleModel[mc];
                for (int k = 0; k < mc; ++k) {
                    ChannelSampleModel channel = new ChannelSampleModel(src, k, false);
                    models[k] = new CubicInterpolatedSampleModel(this.unitRate, (SampleModel)channel, false);
                }
                src = new MultiChannelSampleModel(models, false);
            }
        }
        if (mc != this.channels) {
            models = new SampleModel[this.channels];
            if (mc > 1) {
                if (mc > this.channels) {
                    for (int k = 0; k < this.channels; ++k) {
                        models[k] = new ChannelSampleModel(src, k, false);
                    }
                } else {
                    int k;
                    for (k = 0; k < mc; ++k) {
                        models[k] = new ChannelSampleModel(src, k, false);
                    }
                    for (k = mc; k < this.channels; ++k) {
                        models[k] = models[k % mc];
                    }
                }
            } else {
                for (int k = 0; k < this.channels; ++k) {
                    models[k] = src;
                }
            }
            src = new MultiChannelSampleModel(models, false);
        }
        return src;
    }

    @Override
    protected ChunkSampleModel createChunkSampleModel(LineChunk chunk, SampleModel sm) {
        long samples = sm.getSamples();
        long unitLen = (long)Math.ceil(LineUtil.getUnitPos((long)(chunk.getChunkEnd() - chunk.getChunkOfs()), (double)this.unitRate));
        long modelOfs = LineUtil.getUnitOfs((long)chunk.getModelOfs(), (double)this.unitRate);
        long modelEnd = LineUtil.getUnitOfs((long)chunk.getModelEnd(), (double)this.unitRate);
        modelEnd = Math.min(modelEnd, modelOfs + unitLen);
        modelOfs *= (long)this.channels;
        if ((modelEnd *= (long)this.channels) > samples) {
            modelEnd = samples;
        }
        if (modelOfs >= modelEnd) {
            return null;
        }
        return new ChunkAudioModel(chunk, unitLen, sm, modelOfs, modelEnd);
    }
}

