/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractLineModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import java.io.IOException;

public abstract class MergedLineModel
extends AbstractLineModel
implements ChunkListener {
    protected final DefaultChunkModel chunkModel;
    protected final ReadWriteLock lock;
    protected final float unitRate;
    protected long unitLen;
    protected boolean started;

    public MergedLineModel(DefaultChunkModel chunkModel, ReadWriteLock lock, float unitRate) {
        this.chunkModel = chunkModel;
        this.lock = lock;
        this.unitRate = unitRate;
    }

    public String toString() {
        return super.toString() + "[chunkModel=" + this.chunkModel + ", unitRate=" + this.unitRate + ", started=" + this.started + "]";
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.lock.lockWrite();
            if (this.started) {
                return;
            }
            this.chunkModel.registerChunkListener(this);
            this.started = true;
            this.invalidate(Long.MIN_VALUE, Long.MAX_VALUE);
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.lock.lockWrite();
            if (!this.started) {
                return;
            }
            this.chunkModel.unregisterChunkListener(this);
            this.started = false;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
        super.close();
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException();
    }

    public final float getUnitRate() {
        return this.unitRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModelEmpty() {
        try {
            this.lock.lockRead();
            boolean bl = this.unitLen < 1L;
            return bl;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnitLength() {
        try {
            this.lock.lockRead();
            long l = this.unitLen;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNanoLength() {
        long unitLen;
        try {
            this.lock.lockRead();
            unitLen = this.unitLen;
        }
        finally {
            this.lock.unlockRead();
        }
        return (long)Math.ceil(LineUtil.getNanoPos((long)unitLen, (double)this.unitRate));
    }

    public abstract void invalidate(long var1, long var3);
}

