/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.model.MidiStateImpl;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.StateNode;
import com.spacekiller.util.midi.model.TrackNode;
import com.waxmonster.model.ChunkInterval;
import com.waxmonster.model.ChunkListener;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MidiChunk;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.impl.MidiTrackReader;

public class MergedMidiTrackReader
implements MidiTrackReader,
ChunkListener,
NodeConsumer {
    protected final DefaultChunkModel chunkModel;
    protected int maxSize;
    protected long ofs;
    protected long end;
    protected final boolean stopAtEnd;
    protected final float tickRate;
    protected boolean started;
    protected MergedNode first;
    protected MergedNode last;
    protected int size;
    protected long pos;
    protected long prevPos;
    protected LineChunk prevChunk;
    protected MidiStateImpl midiState;
    protected final EnqueueAllNotesOff enqueueAllNotesOff = new EnqueueAllNotesOff();
    protected long chunkOfs;
    protected long modelOfs;
    protected float modelRate;
    protected long lastPos;
    protected boolean loadMore;

    public MergedMidiTrackReader(DefaultChunkModel chunkModel, long ofs, long end, boolean stopAtEnd, float tickRate, int maxQueueSize) {
        this.chunkModel = chunkModel;
        this.ofs = ofs;
        this.end = end;
        this.stopAtEnd = stopAtEnd;
        this.tickRate = tickRate;
        this.maxSize = maxQueueSize;
        this.pos = ofs;
        this.prevPos = ofs - 1L;
        this.midiState = new MidiStateImpl(0L);
    }

    public String toString() {
        return super.toString() + "[chunkModel=" + this.chunkModel + ", tickRate=" + this.tickRate + ", started=" + this.started + "]";
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.chunkModel.registerChunkListener(this);
        this.started = true;
        this.invalidate(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.chunkModel.unregisterChunkListener(this);
        this.started = false;
    }

    @Override
    public void close() throws InterruptedException {
        this.stop();
    }

    public void chunkAdded(LineChunk chunk, int index) {
        this.invalidate(chunk.getChunkOfs(), chunk.getChunkEnd());
    }

    public void chunkRemoved(LineChunk chunk, int index) {
        this.invalidate(chunk.getChunkOfs(), chunk.getChunkEnd());
    }

    public void chunkMoved(LineChunk chunk, int index, int oldIndex, long oldOfs, long oldEnd) {
        this.invalidate(oldOfs, oldEnd);
        this.invalidate(chunk.getChunkOfs(), chunk.getChunkEnd());
    }

    public void chunksChanged(long ofs, long end) {
        this.invalidate(ofs, end);
    }

    public synchronized void invalidate(long x, long z) {
        if (z <= this.prevPos) {
            return;
        }
        if (x <= this.pos) {
            this.first = null;
            this.last = null;
            this.size = 0;
            this.pos = this.prevPos + 1L;
            this.prevChunk = null;
        }
        this.notifyAll();
    }

    @Override
    public synchronized long getPosition() {
        return this.pos;
    }

    @Override
    public synchronized void seek(long position) {
        this.first = null;
        this.last = null;
        this.size = 0;
        this.pos = position;
        this.prevPos = position - 1L;
        this.prevChunk = null;
        this.notifyAll();
    }

    @Override
    public synchronized void sleep(long ns) throws InterruptedException {
        if (ns < 1000000L) {
            if (ns > 0L) {
                this.wait(0L, (int)ns);
            }
        } else {
            this.wait(ns / 1000000L, (int)(ns % 1000000L));
        }
    }

    @Override
    public synchronized void wakeup() {
        this.notifyAll();
    }

    @Override
    public final float getTickRate() {
        return this.tickRate;
    }

    @Override
    public synchronized int read(NodeConsumer dst) {
        int n = 0;
        while (true) {
            MergedNode node;
            if ((node = this.first) == null) {
                this.load();
                node = this.first;
                if (node == null) break;
            }
            if (!dst.consume((Node)node)) break;
            this.midiState.update(node.node);
            this.first = node.next;
            if (this.first == null) {
                this.last = null;
            }
            node.next = null;
            --this.size;
            this.prevPos = LineUtil.getNanoOfs((long)node.tick, (double)this.tickRate);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized int getAllNotesOff(NodeConsumer dst) {
        int num = this.midiState.getNotes(dst);
        return num;
    }

    protected int enqueueAllNotesOff() {
        long tick;
        this.enqueueAllNotesOff.tick = tick = LineUtil.getUnitOfs((long)this.pos, (double)this.tickRate);
        int num = this.midiState.getNotes((NodeConsumer)this.enqueueAllNotesOff);
        if (num > 0) {
            throw new UnsupportedOperationException("TODO num=" + num);
        }
        return num;
    }

    protected void enqueueNoteOff(long tick, MidiNode node, int status) {
        int channel = status & 0xF;
        int noteIdx = node.getData1();
        NoteOff noteOff = new NoteOff();
        noteOff.status = 0x80 | channel;
        noteOff.data1 = noteIdx;
        MergedNode m = new MergedNode();
        m.tick = tick;
        m.node = noteOff;
        if (this.last == null) {
            this.last = m;
            this.first = m;
        } else {
            this.last.next = m;
            this.last = m;
        }
        ++this.size;
    }

    protected boolean load() {
        int count = 0;
        ChunkInterval inter;
        while ((inter = this.chunkModel.getInterval(this.pos)) != null) {
            long interOfs = inter.getOfs();
            if (interOfs >= this.end) {
                return count > 0;
            }
            LineChunk chunk = inter.getLastChunk();
            if (chunk != null && chunk instanceof MidiChunk) {
                MidiModel model;
                MidiChunk midiChunk = (MidiChunk)chunk;
                if (interOfs > this.pos) {
                    this.pos = interOfs;
                }
                if (chunk != this.prevChunk) {
                    System.out.println("load: chunk changed -> allNotesOff.");
                    this.enqueueAllNotesOff();
                }
                if ((model = midiChunk.getMidiModel()) != null) {
                    this.chunkOfs = midiChunk.getChunkOfs();
                    long interEnd = inter.getEnd();
                    if (this.end < interEnd) {
                        interEnd = this.end;
                    }
                    this.modelRate = model.getTickRate();
                    this.modelOfs = midiChunk.getModelOfs();
                    long modelPos = this.pos - this.chunkOfs + this.modelOfs;
                    long tickOfs = (long)Math.ceil(LineUtil.getUnitPos((long)modelPos, (double)this.modelRate));
                    long modelEnd = Math.min(midiChunk.getModelEnd(), interEnd - this.chunkOfs + this.modelOfs);
                    long tickEnd = (long)Math.ceil(LineUtil.getUnitPos((long)modelEnd, (double)this.modelRate));
                    System.out.println("load: pos=" + this.pos + ", inter=" + inter + ", chunk=" + chunk + ", model=" + model);
                    System.out.println("load: modelPos=" + LineUtil.humanNanos((long)modelPos) + ", modelEnd=" + LineUtil.humanNanos((long)modelEnd));
                    System.out.println("load: tickOfs=" + tickOfs + ", tickEnd=" + tickEnd + ", rate=" + this.modelRate);
                    if (chunk != this.prevChunk) {
                        StateModel stateModel = model.getStateModel();
                        StateNode stateNode = (StateNode)stateModel.getBefore(tickOfs + 1L);
                        MidiStateImpl prevState = stateNode == null ? null : (MidiStateImpl)stateNode.getState();
                        MidiStateImpl midiState = new MidiStateImpl(tickOfs);
                        if (prevState != null) {
                            midiState.reset(prevState);
                        }
                    }
                    this.loadMore = true;
                    count += model.getNodes(tickOfs, tickEnd, (NodeConsumer)this);
                    if (!this.loadMore) {
                        if (this.pos <= this.lastPos) {
                            this.pos = this.lastPos + 1L;
                        }
                        this.prevChunk = chunk;
                        System.out.println("loaded: count=" + count + ", size=" + this.size + ", lastPos=" + this.lastPos + ", pos=" + this.pos + ", prevPos=" + this.prevPos);
                        return count > 0;
                    }
                }
            }
            this.prevChunk = chunk;
            this.pos = inter.getEnd();
        }
        return count > 0;
    }

    public boolean consume(Node node) {
        TrackNode tn = (TrackNode)node;
        long nodePos = this.chunkOfs - this.modelOfs + LineUtil.getNanoOfs((long)tn.getTick(), (double)this.modelRate);
        if (this.size >= this.maxSize && nodePos != this.lastPos) {
            this.loadMore = false;
            return false;
        }
        MergedNode m = new MergedNode();
        m.node = tn;
        m.tick = LineUtil.getUnitOfs((long)nodePos, (double)this.tickRate);
        if (this.last == null) {
            this.last = m;
            this.first = m;
        } else {
            this.last.next = m;
            this.last = m;
        }
        ++this.size;
        this.lastPos = nodePos;
        return true;
    }

    protected class EnqueueAllNotesOff
    implements NodeConsumer {
        protected long tick;

        protected EnqueueAllNotesOff() {
        }

        public boolean consume(Node node) {
            TrackNode tn = (TrackNode)node;
            int status = tn.getStatus();
            switch (status & 0xF0) {
                case 144: {
                    if (tn.getData2() == 0) break;
                    MergedMidiTrackReader.this.enqueueNoteOff(this.tick, (MidiNode)tn, status);
                    break;
                }
                case 160: {
                    MergedMidiTrackReader.this.enqueueNoteOff(this.tick, (MidiNode)tn, status);
                }
            }
            return true;
        }
    }

    protected static class NoteOff
    implements MidiNode {
        protected int status;
        protected int data1;

        protected NoteOff() {
        }

        public long getTick() {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            return 3;
        }

        public int getStatus() {
            return this.status;
        }

        public int getData1() {
            return this.data1;
        }

        public int getData2() {
            return 0;
        }

        public int read(int ofs, byte[] dst, int off, int len) {
            throw new UnsupportedOperationException();
        }

        public boolean compare(MidiNode o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class MergedNode
    implements TrackNode {
        MergedNode next;
        protected long tick;
        protected MidiNode node;

        protected MergedNode() {
        }

        public String toString() {
            return super.toString() + "[tick=" + this.tick + ", node=" + this.node + "]";
        }

        public MidiNode getNode() {
            return this.node;
        }

        public long getTick() {
            return this.tick;
        }

        public int getLength() {
            return this.node.getLength();
        }

        public int getStatus() {
            return this.node.getStatus();
        }

        public int getData1() {
            return this.node.getData1();
        }

        public int getData2() {
            return this.node.getData2();
        }

        public int read(int ofs, byte[] dst, int off, int len) {
            return this.node.read(ofs, dst, off, len);
        }

        public boolean compare(MidiNode o) {
            return this.node.compare(o);
        }
    }
}

