/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.model.ChunkInterval;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.impl.ChunkSampleModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.impl.MergedLineModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MergedSampleModel
extends MergedLineModel
implements SampleModel {
    private static final Logger logger = Logger.getLogger(MergedSampleModel.class.getName());
    public static final long DEFAULT_MIN_UNUSED_MILLIS = 60000L;
    protected final int channels;
    protected final ChunkInterval[] inters;
    protected double out;
    protected Part[] parts;
    protected int partCount;
    protected Map modelMap;
    protected LinkedList unusedList;
    protected long minUnusedMillis;
    protected Map chunkMap;
    protected Part[] partPool;
    protected int partHead;
    protected int partTail;

    public MergedSampleModel(DefaultChunkModel chunkModel, ReadWriteLock lock, float unitRate, int channels, int maxParts) {
        super(chunkModel, lock, unitRate);
        if (channels < 1) {
            throw new IllegalArgumentException("Invalid number of channels: " + channels + " < 1");
        }
        if (maxParts < 2) {
            throw new IllegalArgumentException("Invalid number of parts: " + maxParts + " < 2");
        }
        this.channels = channels;
        this.inters = new ChunkInterval[3];
        this.parts = new Part[maxParts];
        this.modelMap = new HashMap();
        this.unusedList = new LinkedList();
        this.chunkMap = new HashMap();
        this.minUnusedMillis = 60000L;
        int poolLen = maxParts * 2;
        this.partPool = new Part[poolLen + 1];
        for (int i = 0; i < poolLen; ++i) {
            this.partPool[i] = new Part();
        }
        this.partHead = 0;
        this.partTail = poolLen;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.chunkModel + "]";
    }

    public long getMinUnusedMillis() {
        return this.minUnusedMillis;
    }

    public void setMinUnusedMillis(long minUnusedMillis) {
        this.minUnusedMillis = minUnusedMillis;
    }

    public final float getFrameRate() {
        return this.unitRate;
    }

    public final int getChannels() {
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this.lock.lockRead();
            boolean bl = this.unitLen < 1L;
            return bl;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public void set(long i, float v) throws IOException {
    }

    public void set(long i, double v) throws IOException {
    }

    public void set(long i, float[] src, int off, int len) throws IOException {
    }

    public void set(long i, FloatBuffer src, int len) throws IOException {
    }

    public void set(long i, double[] src, int off, int len) throws IOException {
    }

    public void set(long i, DoubleBuffer src, int len) throws IOException {
    }

    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
    }

    public void clear(long i, int len) throws IOException {
    }

    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.lock.lockWrite();
            Object object = this;
            synchronized (object) {
                for (Map.Entry me : this.modelMap.entrySet()) {
                    ModelEntry mm = (ModelEntry)me.getValue();
                    SampleModel val = mm.val;
                    if (val == null || val == mm.key) continue;
                    this.closeUnused(val);
                }
                this.modelMap.clear();
                this.unusedList.clear();
            }
            object = this.chunkMap;
            synchronized (object) {
                this.chunkMap.clear();
            }
            int n = this.partCount;
            if (n > 0) {
                Arrays.fill(this.parts, 0, n, null);
            }
            this.partCount = 0;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    protected int indexFor(long x) {
        int lo = 0;
        int hi = this.partCount - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            long v = this.parts[i].ofs;
            if (x < v) {
                hi = i - 1;
                continue;
            }
            if (x > v) {
                lo = i + 1;
                continue;
            }
            return i;
        }
        return lo;
    }

    protected int indexOf(long x) {
        int lo = 0;
        int hi = this.partCount - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            Part p = this.parts[i];
            if (x < p.ofs) {
                hi = i - 1;
                continue;
            }
            if (x >= p.end) {
                lo = i + 1;
                continue;
            }
            return i;
        }
        return lo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkAdded(LineChunk chunk, int index) {
        this.invalidate(chunk.getChunkOfs(), chunk.getChunkEnd());
        if (chunk != null) {
            Map map = this.chunkMap;
            synchronized (map) {
                this.chunkMap.remove(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkRemoved(LineChunk chunk, int index) {
        this.invalidate(chunk.getChunkOfs(), chunk.getChunkEnd());
        if (chunk != null) {
            Map map = this.chunkMap;
            synchronized (map) {
                this.chunkMap.remove(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkMoved(LineChunk chunk, int index, int oldIndex, long oldOfs, long oldEnd) {
        this.invalidate(oldOfs, oldEnd);
        this.invalidate(chunk.getChunkOfs(), chunk.getChunkEnd());
        if (chunk != null) {
            Map map = this.chunkMap;
            synchronized (map) {
                this.chunkMap.remove(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunksChanged(long ofs, long end) {
        this.invalidate(ofs, end);
        Map map = this.chunkMap;
        synchronized (map) {
            this.chunkMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(long x, long z) {
        long sx = (long)this.channels * LineUtil.getUnitOfs((long)x, (double)this.unitRate);
        long sz = (long)this.channels * LineUtil.getUnitOfs((long)z, (double)this.unitRate);
        try {
            int n;
            this.lock.lockWrite();
            int ix = this.indexOf(sx);
            int iz = this.indexOf(sz - 1L) + 1;
            if (iz > this.partCount) {
                iz = this.partCount;
            }
            if ((n = iz - ix) > 0) {
                for (int i = ix; i < iz; ++i) {
                    Part p = this.parts[i];
                    MergedSampleModel mergedSampleModel = this;
                    synchronized (mergedSampleModel) {
                        int tail;
                        ModelEntry mm = p.mm;
                        if (mm != null && --mm.used == 0) {
                            mm.lastUsed = System.currentTimeMillis();
                            this.unusedList.add(mm);
                        }
                        if ((tail = (this.partTail + 1) % this.partPool.length) != this.partHead) {
                            this.partPool[this.partTail] = p;
                            this.partTail = tail;
                        }
                        continue;
                    }
                }
                if (iz < this.partCount) {
                    System.arraycopy(this.parts, iz, this.parts, ix, this.partCount - iz);
                }
                iz = this.partCount;
                this.partCount -= n;
                Arrays.fill(this.parts, this.partCount, iz, null);
            }
            this.unitLen = (long)Math.ceil(LineUtil.getUnitPos((long)this.chunkModel.computeTimeLength(), (double)this.unitRate));
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recycleUnusedModels() {
        long lastUsed = System.currentTimeMillis() - this.minUnusedMillis;
        int count = 0;
        while (true) {
            ModelEntry mm;
            MergedSampleModel mergedSampleModel = this;
            synchronized (mergedSampleModel) {
                if (this.unusedList.isEmpty()) {
                    break;
                }
                mm = (ModelEntry)this.unusedList.getFirst();
                if (mm.lastUsed > lastUsed) {
                    break;
                }
                this.unusedList.removeFirst();
                if (mm.used > 0) {
                    continue;
                }
                this.modelMap.remove(mm.key);
            }
            SampleModel val = mm.val;
            if (val != null && val != mm.key) {
                this.closeUnused(val);
            }
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeUnused(SampleModel model) {
        if (model instanceof ChunkSampleModel) {
            ChunkSampleModel csm = (ChunkSampleModel)model;
            LineChunk chunk = csm.chunk;
            if (chunk != null) {
                Map map = this.chunkMap;
                synchronized (map) {
                    this.chunkMap.remove(chunk);
                }
            }
        }
        try {
            model.close();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Part part(long i) {
        Part p;
        int ix;
        try {
            this.lock.lockRead();
            ix = this.indexOf(i);
            if (ix < this.partCount) {
                p = this.parts[ix];
                if (p.ofs <= i) {
                    Part part = p;
                    return part;
                }
            }
        }
        finally {
            this.lock.unlockRead();
        }
        long nof = LineUtil.getNanoOfs((long)(i / (long)this.channels), (double)this.unitRate);
        ChunkInterval[] chunkIntervalArray = this.inters;
        synchronized (this.inters) {
            long mo;
            ChunkSampleModel m;
            ModelEntry mm;
            long end;
            long ofs;
            this.chunkModel.getIntervalsAround(nof, this.inters);
            ChunkInterval interBefore = this.inters[0];
            ChunkInterval inter = this.inters[1];
            ChunkInterval interAfter = this.inters[2];
            // ** MonitorExit[var18_8] (shouldn't be in output)
            if (inter == null) {
                if (interBefore == null) {
                    ofs = Long.MIN_VALUE;
                } else {
                    long io = interBefore.getEnd();
                    ofs = (long)this.channels * LineUtil.getUnitOfs((long)io, (double)this.unitRate);
                }
                if (interAfter == null) {
                    end = Long.MAX_VALUE;
                } else {
                    long ie = interAfter.getOfs();
                    end = (long)this.channels * (long)Math.ceil(LineUtil.getUnitPos((long)ie, (double)this.unitRate));
                }
                if (end <= ofs) {
                    end = ofs + (long)this.channels;
                }
                mm = null;
                m = null;
                mo = 0L;
            } else {
                LineChunk chunk;
                LineModel model;
                long io = inter.getOfs();
                long ie = inter.getEnd();
                ofs = (long)this.channels * LineUtil.getUnitOfs((long)io, (double)this.unitRate);
                end = (long)this.channels * (long)Math.ceil(LineUtil.getUnitPos((long)ie, (double)this.unitRate));
                if (end <= ofs) {
                    end = ofs + (long)this.channels;
                }
                LineModel lineModel = model = (chunk = inter.getLastChunk()) == null ? null : chunk.getLineModel();
                if (model != null && model instanceof SampleModel) {
                    ChunkSampleModel csm;
                    SampleModel sm = (SampleModel)model;
                    mm = this.getMergedModel(sm);
                    m = csm = mm == null ? null : this.getChunkSampleModel(chunk, mm);
                    mo = (long)this.channels * LineUtil.getUnitOfs((long)(io - chunk.getChunkOfs()), (double)this.unitRate);
                } else {
                    mm = null;
                    m = null;
                    mo = 0L;
                }
            }
            try {
                this.lock.lockWrite();
                ix = this.indexFor(ofs);
                if (ix < this.partCount) {
                    p = this.parts[ix];
                    if (p.ofs < end) {
                        if (p.ofs <= i && p.end > i) {
                            if (mm != null) {
                                this.recycleEntry(mm);
                            }
                            Part part = p;
                            return part;
                        }
                        if (p.end > end) {
                            p.mo += end - p.ofs;
                            p.ofs = end;
                        } else {
                            this.removePartAt(ix);
                        }
                    }
                }
                if (ix > 0) {
                    p = this.parts[ix - 1];
                    if (p.end > ofs) {
                        if (p.ofs < ofs) {
                            p.end = ofs;
                        } else {
                            this.removePartAt(--ix);
                        }
                    }
                }
                if (this.partCount >= this.parts.length) {
                    if (ix > 0) {
                        this.removePartAt(0);
                        --ix;
                    } else {
                        this.removePartAt(this.partCount - 1);
                        if (ix > this.partCount) {
                            ix = this.partCount;
                        }
                    }
                }
                MergedSampleModel mergedSampleModel = this;
                synchronized (mergedSampleModel) {
                    if (this.partHead == this.partTail) {
                        p = null;
                    } else {
                        p = this.partPool[this.partHead];
                        this.partPool[this.partHead] = null;
                        this.partHead = (this.partHead + 1) % this.partPool.length;
                    }
                }
                if (p == null) {
                    p = new Part();
                }
                p.ofs = ofs;
                p.end = end;
                p.mo = mo;
                p.m = m;
                p.mm = mm;
                if (ix < this.partCount) {
                    System.arraycopy(this.parts, ix, this.parts, ix + 1, this.partCount - ix);
                }
                this.parts[ix] = p;
                ++this.partCount;
            }
            finally {
                this.lock.unlockWrite();
            }
            return p;
        }
    }

    protected void removePartAt(int i) {
        Part p = this.parts[i];
        --this.partCount;
        if (i < this.partCount) {
            System.arraycopy(this.parts, i + 1, this.parts, i, this.partCount - i);
        }
        this.recyclePart(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recyclePart(Part p) {
        ModelEntry mm = p.mm;
        if (mm != null) {
            this.recycleEntry(mm);
        }
        MergedSampleModel mergedSampleModel = this;
        synchronized (mergedSampleModel) {
            int tail = (this.partTail + 1) % this.partPool.length;
            if (tail != this.partHead) {
                this.partPool[this.partTail] = p;
                this.partTail = tail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleEntry(ModelEntry mm) {
        MergedSampleModel mergedSampleModel = this;
        synchronized (mergedSampleModel) {
            if (mm.used > 1) {
                --mm.used;
            } else {
                mm.used = 0;
                mm.lastUsed = System.currentTimeMillis();
                this.unusedList.add(mm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpParts(Logger logger, Level level) throws IllegalStateException {
        try {
            this.lock.lockRead();
            int num = this.partCount;
            logger.log(level, "dumpParts: " + this);
            logger.log(level, "Number of parts: " + num);
            for (int i = 0; i < num; ++i) {
                Part p = this.parts[i];
                logger.log(level, " - #" + i + ": " + p);
            }
            MergedSampleModel mergedSampleModel = this;
            synchronized (mergedSampleModel) {
                logger.log(level, "Number of models: " + this.modelMap.size());
                for (Map.Entry me : this.modelMap.entrySet()) {
                    ModelEntry mm = (ModelEntry)me.getValue();
                    logger.log(level, " - " + mm);
                }
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIntegrity() throws IllegalStateException {
        try {
            this.lock.lockRead();
            int num = this.partCount;
            long prevEnd = Long.MIN_VALUE;
            for (int i = 0; i < num; ++i) {
                Part p = this.parts[i];
                if (p.ofs >= p.end) {
                    throw new IllegalStateException("Invalid part offset: " + p.ofs + " >= " + p.end);
                }
                if (p.ofs < prevEnd) {
                    throw new IllegalStateException("Invalid part offset: " + p.ofs + " < " + prevEnd);
                }
                prevEnd = p.end;
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }

    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        Part p;
        int n;
        while ((len -= (n = (p = this.part(i)).get(i, dst, off, len))) >= 1) {
            off += n;
            i += (long)n;
        }
        return;
    }

    public void get(long i, double[] dst, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        Part p;
        int n;
        while ((len -= (n = (p = this.part(i)).get(i, dst, off, len))) >= 1) {
            off += n;
            i += (long)n;
        }
        return;
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        Part p;
        int n;
        while ((len -= (n = (p = this.part(i)).get(i, dst, off, len))) >= 1) {
            off += n;
            i += (long)n;
        }
        return;
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        if (len < 1) {
            return;
        }
        Part p;
        int n;
        while ((len -= (n = (p = this.part(i)).get(i, dst, len))) >= 1) {
            i += (long)n;
        }
        return;
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        if (len < 1) {
            return;
        }
        Part p;
        int n;
        while ((len -= (n = (p = this.part(i)).get(i, dst, len))) >= 1) {
            i += (long)n;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelEntry getMergedModel(SampleModel key) {
        ModelEntry mm;
        MergedSampleModel mergedSampleModel = this;
        synchronized (mergedSampleModel) {
            mm = (ModelEntry)this.modelMap.get(key);
            if (mm != null) {
                ++mm.used;
                return mm;
            }
        }
        SampleModel conv = this.createConvertedModel(key);
        if (conv == null) {
            return null;
        }
        MergedSampleModel mergedSampleModel2 = this;
        synchronized (mergedSampleModel2) {
            mm = (ModelEntry)this.modelMap.get(key);
            if (mm != null) {
                ++mm.used;
                if (conv != key) {
                    this.closeUnused(conv);
                }
                return mm;
            }
            mm = new ModelEntry();
            mm.key = key;
            mm.val = conv;
            mm.used = 1;
            this.modelMap.put(key, mm);
        }
        return mm;
    }

    protected abstract SampleModel createConvertedModel(SampleModel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChunkSampleModel getChunkSampleModel(LineChunk chunk, ModelEntry mm) {
        ChunkSampleModel csm;
        SampleModel sm = mm.val;
        if (sm == null) {
            return null;
        }
        Map map = this.chunkMap;
        synchronized (map) {
            csm = (ChunkSampleModel)this.chunkMap.get(chunk);
            if ((csm == null || csm.model != sm) && (csm = this.createChunkSampleModel(chunk, sm)) != null) {
                this.chunkMap.put(chunk, csm);
            }
        }
        return csm;
    }

    protected abstract ChunkSampleModel createChunkSampleModel(LineChunk var1, SampleModel var2);

    protected class Part {
        protected long ofs;
        protected long end;
        protected SampleModel m;
        protected long mo;
        protected ModelEntry mm;

        protected Part() {
        }

        public String toString() {
            return super.toString() + "[ofs=" + this.ofs + ", end=" + this.end + ", modelOfs=" + this.mo + ", model=" + this.m + "]";
        }

        public int get(long i, SampleBuffer dst, int off, int len) throws IOException {
            int n = (int)Math.min((long)len, this.end - i);
            SampleModel sm = this.m;
            if (sm == null) {
                dst.fill(off, n, MergedSampleModel.this.out);
            } else {
                sm.get(i - this.ofs + this.mo, dst, off, n);
            }
            return n;
        }

        public int get(long i, double[] dst, int off, int len) throws IOException {
            int n = (int)Math.min((long)len, this.end - i);
            SampleModel sm = this.m;
            if (sm == null) {
                double v = MergedSampleModel.this.out;
                int end = off + n;
                while (off < end) {
                    dst[off++] = v;
                }
            } else {
                sm.get(i - this.ofs + this.mo, dst, off, n);
            }
            return n;
        }

        public int get(long i, float[] dst, int off, int len) throws IOException {
            int n = (int)Math.min((long)len, this.end - i);
            SampleModel sm = this.m;
            if (sm == null) {
                float v = (float)MergedSampleModel.this.out;
                int end = off + n;
                while (off < end) {
                    dst[off++] = v;
                }
            } else {
                sm.get(i - this.ofs + this.mo, dst, off, n);
            }
            return n;
        }

        public int get(long i, DoubleBuffer dst, int len) throws IOException {
            int n = (int)Math.min((long)len, this.end - i);
            SampleModel sm = this.m;
            if (sm == null) {
                double v = MergedSampleModel.this.out;
                while (n-- > 0) {
                    dst.put(v);
                }
            } else {
                sm.get(i - this.ofs + this.mo, dst, n);
            }
            return n;
        }

        public int get(long i, FloatBuffer dst, int len) throws IOException {
            int n = (int)Math.min((long)len, this.end - i);
            SampleModel sm = this.m;
            if (sm == null) {
                float v = (float)MergedSampleModel.this.out;
                while (n-- > 0) {
                    dst.put(v);
                }
            } else {
                sm.get(i - this.ofs + this.mo, dst, n);
            }
            return n;
        }
    }

    protected static class ModelEntry {
        protected SampleModel key;
        protected SampleModel val;
        protected int used;
        protected long lastUsed;

        protected ModelEntry() {
        }

        public String toString() {
            return super.toString() + "[key=" + this.key + ", val=" + this.val + ", used=" + this.used + "]";
        }
    }
}

