/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.model.MidiState;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.StateNode;
import com.waxmonster.fader.Fader;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.VolumeShader;
import com.waxmonster.fader.midi.AbstractMidiFaderDecoder;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.ModelFaderDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MidiModelFaderDecoder
extends AbstractMidiFaderDecoder
implements ModelFaderDecoder {
    protected static final double[] NO_VOLUMES = new double[0];
    protected final MidiConsumer mcons;
    protected final StateConsumer scons;
    protected MidiModel midiModel;
    protected float tickRate;
    protected double[] initVol = NO_VOLUMES;
    protected CacheState[] cache;
    protected int cacheLen;
    protected int cacheLen2;
    protected int cacheSize;
    protected double[] cacheVol;

    public MidiModelFaderDecoder(int cacheCapacity) {
        this.scons = new StateConsumer();
        this.mcons = new MidiConsumer();
        this.setCacheCapacity(cacheCapacity);
    }

    public synchronized MidiModel getMidiModel() {
        return this.midiModel;
    }

    public synchronized void setMidiModel(MidiModel midiModel) {
        if (this.midiModel == midiModel) {
            return;
        }
        this.midiModel = midiModel;
        this.tickRate = midiModel.getTickRate();
        this.scons.tick = Long.MIN_VALUE;
        this.mcons.tick = Long.MIN_VALUE;
        this.cacheSize = 0;
    }

    public synchronized void setChannelCount(int channelCount) {
        int prev = this.getChannelCount();
        super.setChannelCount(channelCount);
        if (prev != this.getChannelCount()) {
            this.initVolume();
        }
    }

    public synchronized void setFaderConfigArray(FaderConfig[] array) {
        super.setFaderConfigArray(array);
        this.initVolume();
    }

    public synchronized void setVolumeShaderArray(VolumeShader[] array) {
        if (array == null) {
            throw new IllegalArgumentException("VolumeShader(s) is null");
        }
        super.setVolumeShaderArray(array);
        int shaderCount = array.length;
        if (shaderCount != this.initVol.length) {
            this.initVol = new double[shaderCount];
            this.cacheVol = this.prepareCache(this.cache);
            this.initVolume();
        }
    }

    protected void initVolume() {
        this.clearCache();
        VolumeShader[] sha = this.volumeShaders;
        int n = sha.length;
        for (int i = 0; i < n; ++i) {
            this.initVol[i] = sha[i].getInitVolume();
        }
        this.setShaderVolumes(this.initVol, 0);
    }

    protected void getShaderVolumes(double[] vol, int off) {
        VolumeShader[] sha = this.volumeShaders;
        int n = sha.length;
        for (int i = 0; i < n; ++i) {
            vol[off++] = sha[i].getVolume();
        }
    }

    protected void setShaderVolumes(double[] vol, int off) {
        VolumeShader[] sha = this.volumeShaders;
        int n = sha.length;
        for (int i = 0; i < n; ++i) {
            sha[i].reset(vol[off++]);
        }
    }

    public void seek(long lineOfs) {
        long tickOfs = LineUtil.getUnitOfs((long)lineOfs, (double)this.tickRate);
        this.seekTick(tickOfs);
    }

    public void seekTick(long tickOfs) {
        CacheState cs;
        MidiModel model = this.midiModel;
        if (model == null) {
            return;
        }
        if (tickOfs == this.mcons.tick) {
            return;
        }
        int cx = this.cacheIndexFor(tickOfs + 1L);
        if (cx > 0) {
            cs = this.cache[cx - 1];
            this.scons.tick = cs.tick;
            this.mcons.tick = cs.tick;
            this.setShaderVolumes(this.cacheVol, cs.vidx);
        } else if (tickOfs < this.mcons.tick) {
            this.scons.tick = Long.MIN_VALUE;
            this.mcons.tick = Long.MIN_VALUE;
            this.setShaderVolumes(this.initVol, 0);
        }
        this.mcons.seek = true;
        this.resetFaderValues();
        StateModel stateModel = model.getStateModel();
        if (stateModel != null) {
            stateModel.getNodes(this.scons.tick, tickOfs, (NodeConsumer)this.scons);
            if (this.cacheLen > 0 && ((cx = this.cacheIndexFor(this.scons.tick)) >= this.cacheSize || this.cache[cx].tick != this.scons.tick)) {
                if (this.cacheSize < this.cacheLen) {
                    if (cx < this.cacheSize) {
                        cs = this.cache[this.cacheSize - 1];
                        System.arraycopy(this.cache, cx, this.cache, cx + 1, this.cacheSize - cx);
                        this.cache[cx] = cs;
                    }
                    ++this.cacheSize;
                } else if (cx > this.cacheLen2) {
                    cs = this.cache[0];
                    System.arraycopy(this.cache, 1, this.cache, 0, --cx);
                    this.cache[cx] = cs;
                } else {
                    cs = this.cache[this.cacheLen - 1];
                    System.arraycopy(this.cache, cx, this.cache, cx + 1, this.cacheLen - cx - 1);
                    this.cache[cx] = cs;
                }
                cs = this.cache[cx];
                cs.tick = this.scons.tick;
                this.getShaderVolumes(this.cacheVol, cs.vidx);
            }
        }
        if (this.scons.tick < tickOfs) {
            model.getNodes(this.scons.tick, tickOfs, (NodeConsumer)this.mcons);
        }
    }

    public int decode(long lineOfs) {
        long tickEnd = LineUtil.getUnitOfs((long)lineOfs, (double)this.tickRate);
        return this.decodeTicks(tickEnd);
    }

    public int decodeTicks(long tickEnd) {
        MidiModel model = this.midiModel;
        if (model == null) {
            return 0;
        }
        long tickOfs = this.mcons.tick;
        if (tickEnd <= tickOfs) {
            return 0;
        }
        this.mcons.seek = false;
        model.getNodes(tickOfs, tickEnd, (NodeConsumer)this.mcons);
        return this.mcons.done;
    }

    public void clearCache() {
        this.cacheSize = 0;
    }

    public int getCacheCapacity() {
        return this.cacheLen;
    }

    public synchronized void setCacheCapacity(int len) {
        if (this.cache != null && this.cacheLen == len) {
            return;
        }
        CacheState[] arr = new CacheState[len];
        int i = 0;
        if (this.cacheLen > 0) {
            int num = Math.min(this.cacheLen, len);
            System.arraycopy(this.cache, 0, arr, 0, num);
            i = num;
        }
        while (i < len) {
            arr[i] = new CacheState();
            ++i;
        }
        this.cacheVol = this.prepareCache(arr);
        this.cacheSize = 0;
        this.cacheLen = len;
        this.cacheLen2 = len / 2;
        this.cache = arr;
    }

    protected double[] prepareCache(CacheState[] arr) {
        int len = arr.length;
        int vlen = this.initVol.length;
        int vidx = 0;
        for (int i = 0; i < len; ++i) {
            arr[i].vidx = vidx;
            vidx += vlen;
        }
        return new double[vidx];
    }

    protected int cacheIndexFor(long tick) {
        int lo = 0;
        int hi = this.cacheSize - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            long t = this.cache[i].tick;
            if (t < tick) {
                lo = i + 1;
                continue;
            }
            if (t > tick) {
                hi = i - 1;
                continue;
            }
            return i;
        }
        return lo;
    }

    public void checkIntegrity() throws IllegalStateException {
        long minTick = Long.MIN_VALUE;
        for (int i = 0; i < this.cacheSize; ++i) {
            CacheState cs = this.cache[i];
            if (cs.tick < minTick) {
                throw new IllegalStateException("Invalid cache tick offset: " + cs.tick + " <= " + minTick);
            }
            minTick = cs.tick + 1L;
        }
    }

    public void dumpDecoder(Logger logger, Level level) {
        AbstractMidiFaderDecoder.FaderImpl[] faders = this.faders;
        int faderCount = faders.length;
        VolumeShader[] shaders = this.volumeShaders;
        int shaderCount = shaders.length;
        logger.log(level, "Dump: " + (Object)((Object)this) + ", channels=" + this.channelCount + ", faders=" + faderCount + ", shaders=" + shaderCount + ", cacheSize=" + this.cacheSize + "/" + this.cacheLen);
        for (int i = 0; i < faderCount; ++i) {
            AbstractMidiFaderDecoder.FaderImpl fader = faders[i];
            VolumeShader[] faderShaders = fader.getShaders();
            logger.log(level, " - Fader #" + i + ": " + fader + ", mask=" + Fader.toChannelMaskString((int)fader.mask, (int)this.channelCount) + ", shaders=" + faderShaders.length + ", initVol=" + fader.getInitVolume());
            for (int k = 0; k < faderShaders.length; ++k) {
                logger.log(level, "     -> Shader: " + faderShaders[k]);
            }
        }
        for (int i = 0; i < shaderCount; ++i) {
            VolumeShader shader = shaders[i];
            Fader[] shaderFaders = shader.getFaders();
            logger.log(level, " - Shader #" + i + ": " + shader + ", mask=" + Fader.toChannelMaskString((int)shader.getChannelMask(), (int)this.channelCount) + ", faders=" + shaderFaders.length + ", initVol=" + shader.getInitVolume());
            for (int k = 0; k < shaderFaders.length; ++k) {
                logger.log(level, "     -> Fader: " + shaderFaders[k]);
            }
        }
    }

    protected static class CacheState {
        protected long tick;
        protected int vidx;

        protected CacheState() {
        }
    }

    protected class StateConsumer
    implements NodeConsumer {
        long tick = Long.MIN_VALUE;

        public boolean consume(Node node) {
            StateNode n = (StateNode)node;
            MidiState state = (MidiState)n.getState();
            this.tick = state.getTick();
            state.getCtrls((NodeConsumer)MidiModelFaderDecoder.this.mcons);
            return true;
        }
    }

    protected class MidiConsumer
    implements NodeConsumer {
        protected boolean seek;
        protected long tick = Long.MIN_VALUE;
        protected int done;

        public boolean consume(Node node) {
            MidiNode n = (MidiNode)node;
            int status = n.getStatus();
            if ((status & 0xF0) != 176) {
                return true;
            }
            int channel = status & 0xF;
            AbstractMidiFaderDecoder.Fadeable[] arr = MidiModelFaderDecoder.this.matrix[channel];
            if (arr == null) {
                return true;
            }
            int data1 = n.getData1();
            if (data1 < 0 || data1 >= 128) {
                return true;
            }
            AbstractMidiFaderDecoder.Fadeable fader = arr[data1];
            if (fader != null && fader.move(n.getData2())) {
                long tk = n.getTick();
                if (this.seek) {
                    VolumeShader[] sha = fader.getShaders();
                    int num = sha.length;
                    int i = 0;
                    while (i < num) {
                        sha[i++].seek();
                    }
                } else {
                    long time = LineUtil.getNanoOfs((long)tk, (double)MidiModelFaderDecoder.this.tickRate);
                    VolumeShader[] sha = fader.getShaders();
                    int num = sha.length;
                    int i = 0;
                    while (i < num) {
                        sha[i++].move(time);
                    }
                }
                this.tick = tk;
                ++this.done;
            }
            return true;
        }
    }
}

