/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Resource;
import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.midi.MidiMeta;
import com.spacekiller.util.midi.impl.DefaultMidiMeta;
import com.spacekiller.util.midi.list.ListStateModel;
import com.spacekiller.util.midi.list.ListTrackModel;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.StateModelAccess;
import com.spacekiller.util.midi.model.TrackModel;
import com.spacekiller.util.midi.model.TrackModelAccess;
import com.spacekiller.util.midi.model.TrackNode;
import com.spacekiller.util.midi.tree.TreeStateModel;
import com.spacekiller.util.midi.tree.TreeTrackModel;
import com.spacekiller.util.time.MicrosecondsPerUnit;
import com.spacekiller.util.time.UnitsPerSecond;
import com.waxmonster.midi.common.MetaMidiMsg;
import com.waxmonster.midi.common.ShortMidiMsg;
import com.waxmonster.midi.common.SysexMidiMsg;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MidiTrack;
import com.waxmonster.model.impl.DefaultMidiModel;
import com.waxmonster.model.impl.DefaultMidiTrack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiModelUtil {
    private static final Logger logger = Logger.getLogger(MidiModelUtil.class.getName());
    public static final String MIDI_FILE_EXTENSION = ".mid";
    private static final byte[] MIDI_HEADER_MAGIC = "MThd".getBytes();
    public static final int ALL_TRACKS = -1;
    public static final long DEFAULT_PPQ_MICROS_PER_BEAT = 500000L;
    public static final int MODEL_TYPE_LIST = 1;
    public static final int MODEL_TYPE_TREE = 2;
    private static MidiModelUtil INSTANCE;

    protected MidiModelUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final MidiModelUtil getInstance() {
        MidiModelUtil instance = INSTANCE;
        if (instance != null) return instance;
        Class<MidiModelUtil> clazz = MidiModelUtil.class;
        synchronized (MidiModelUtil.class) {
            instance = INSTANCE;
            if (instance != null) return instance;
            INSTANCE = instance = new MidiModelUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static TrackNode newNode(TrackModel model, MidiEvent event) {
        long tick = event.getTick();
        MidiMessage msg = event.getMessage();
        int len = msg.getLength();
        switch (len) {
            case 1: {
                return model.newNode(tick, msg.getStatus());
            }
            case 2: {
                if (!(msg instanceof ShortMessage)) break;
                ShortMessage sm = (ShortMessage)msg;
                return model.newNode(tick, sm.getStatus(), sm.getData1());
            }
            case 3: {
                if (!(msg instanceof ShortMessage)) break;
                ShortMessage sm = (ShortMessage)msg;
                return model.newNode(tick, sm.getStatus(), sm.getData1(), sm.getData2());
            }
        }
        byte[] data = msg.getMessage();
        return model.newNode(tick, msg.getStatus(), data, 0, len);
    }

    public static MidiMessage newMessage(TrackNode node) {
        int len = node.getLength();
        switch (len) {
            case 1: {
                return new ShortMidiMsg(node.getStatus());
            }
            case 2: {
                return new ShortMidiMsg(node.getStatus(), node.getData1());
            }
            case 3: {
                return new ShortMidiMsg(node.getStatus(), node.getData1(), node.getData2());
            }
        }
        if (len < 1) {
            return null;
        }
        switch (node.getStatus()) {
            case 240: {
                byte[] data = new byte[len];
                node.read(0, data, 0, len);
                return new SysexMidiMsg(data);
            }
            case 255: {
                byte[] data = new byte[len];
                node.read(0, data, 0, len);
                return new MetaMidiMsg(data);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMidiFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.seek(0L);
            if (raf.length() < (long)MIDI_HEADER_MAGIC.length) {
                boolean bl = false;
                return bl;
            }
            byte[] magic = new byte[MIDI_HEADER_MAGIC.length];
            raf.readFully(magic);
            boolean bl = Arrays.equals(magic, MIDI_HEADER_MAGIC);
            return bl;
        }
        finally {
            raf.close();
        }
    }

    public TimeUnit computeMidiTimeUnit(Sequence sequence) {
        float divisionType = sequence.getDivisionType();
        int resolution = sequence.getResolution();
        return this.computeMidiTimeUnit(divisionType, resolution);
    }

    public TimeUnit computeMidiTimeUnit(MidiFileFormat fileFormat) {
        float divisionType = fileFormat.getDivisionType();
        int resolution = fileFormat.getResolution();
        return this.computeMidiTimeUnit(divisionType, resolution);
    }

    public TimeUnit computeMidiTimeUnit(float divisionType, int resolution) {
        if (divisionType == 0.0f) {
            int ticksPerBeat = resolution;
            double microsPerBeat = 500000.0;
            double microsPerTick = microsPerBeat / (double)ticksPerBeat;
            return new MicrosecondsPerUnit(microsPerTick);
        }
        float framesPerSecond = divisionType;
        int ticksPerFrame = resolution;
        double ticksPerSecond = framesPerSecond * (float)ticksPerFrame;
        return new UnitsPerSecond(ticksPerSecond);
    }

    public MidiModel createMidiModel(double secondsPerState, int modelType, int initCapacity, TimeUnit timeUnit, LockFactory lockFactory, boolean fair) {
        TrackModelAccess trackModel = this.createTrackModel(modelType, initCapacity);
        StateModelAccess stateModel = this.createStateModel((TrackModel)trackModel, modelType, timeUnit, secondsPerState);
        DefaultMidiModel midiModel = new DefaultMidiModel((TrackModel)trackModel, (StateModel)stateModel, timeUnit, lockFactory, fair);
        return midiModel;
    }

    public TrackModelAccess createTrackModel(int modelType, int initCapacity) {
        TreeTrackModel trackModel;
        switch (modelType) {
            case 1: {
                if (initCapacity < 32) {
                    initCapacity = 32;
                }
                trackModel = new ListTrackModel(initCapacity);
                break;
            }
            case 2: {
                trackModel = new TreeTrackModel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid track model type: " + modelType);
            }
        }
        return trackModel;
    }

    public StateModelAccess createStateModel(TrackModel trackModel, int modelType, TimeUnit timeUnit, double secondsPerState) {
        TreeStateModel stateModel;
        if (secondsPerState <= 0.0) {
            return null;
        }
        double tickRate = timeUnit.unitsPerSecond();
        long ticksPerState = (long)(secondsPerState * tickRate);
        if (ticksPerState < 1L) {
            ticksPerState = 1L;
        }
        switch (modelType) {
            case 1: {
                int initCapacity = -1;
                TrackNode firstNode = (TrackNode)trackModel.getFirst();
                TrackNode lastNode = (TrackNode)trackModel.getLast();
                if (firstNode != null && lastNode != null) {
                    long firstTick = firstNode.getTick();
                    long lastTick = lastNode.getTick();
                    long ticks = lastTick - firstTick + 1L;
                    if (ticks > 0L) {
                        initCapacity = (int)(ticks / ticksPerState);
                    }
                }
                if (initCapacity < 8) {
                    initCapacity = 8;
                }
                stateModel = new ListStateModel(trackModel, ticksPerState, initCapacity);
                break;
            }
            case 2: {
                stateModel = new TreeStateModel(trackModel, ticksPerState);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid track model type: " + modelType);
            }
        }
        return stateModel;
    }

    public int loadTrackIntoTrackModel(Track track, TrackModel model) {
        int num = track.size();
        if (num < 1) {
            return 0;
        }
        ArrayList<TrackNode> nodes = new ArrayList<TrackNode>(num);
        for (int i = 0; i < num; ++i) {
            TrackNode node = MidiModelUtil.newNode(model, track.get(i));
            if (node == null) continue;
            nodes.add(node);
        }
        return model.addNodes(Long.MIN_VALUE, Long.MAX_VALUE, nodes);
    }

    public int loadTrackModelIntoTrack(TrackModel model, Track track) {
        LoadTrackModelIntoTrack dst = new LoadTrackModelIntoTrack(track);
        long off = Long.MIN_VALUE;
        long end = Long.MAX_VALUE;
        model.getNodes(off, end, (NodeConsumer)dst);
        return dst.getEventCount();
    }

    public Sequence readSequence(InputStream stream) throws Exception {
        return MidiSystem.getSequence(stream);
    }

    public int writeSequence(Sequence sequence, int fileType, OutputStream stream) throws Exception {
        return MidiSystem.write(sequence, fileType, stream);
    }

    public int writeSequence(Sequence sequence, MidiFileFormat fileFormat, OutputStream stream) throws Exception {
        int fileType = fileFormat.getType();
        return this.writeSequence(sequence, fileType, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiTrack[] readMidiTracks(Resource resource, String[] trackIds) throws Exception {
        Track[] tracks;
        Sequence sequence;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Reading Midi-Tracks: resource=" + resource);
        }
        InputStream stream = resource.createInputStream();
        try {
            sequence = this.readSequence(stream);
        }
        finally {
            stream.close();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Midi-Sequence: " + sequence);
        }
        TimeUnit timeUnit = this.computeMidiTimeUnit(sequence);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Midi-TimeUnit: " + timeUnit);
        }
        int numTracks = (tracks = sequence.getTracks()) == null ? 0 : tracks.length;
        ArrayList<MidiTrack> midiTrackList = new ArrayList<MidiTrack>(numTracks);
        HashMap<String, DefaultMidiTrack> midiTrackMap = new HashMap<String, DefaultMidiTrack>(numTracks);
        for (int i = 0; i < numTracks; ++i) {
            Track track = tracks[i];
            String trackId = String.valueOf(i);
            if (trackIds != null) {
                boolean wanted = false;
                for (int k = 0; k < trackIds.length; ++k) {
                    if (!trackId.equals(trackIds[k])) continue;
                    wanted = true;
                    break;
                }
                if (!wanted) continue;
            }
            String trackName = null;
            int numEvents = track.size();
            for (int k = 0; k < numEvents; ++k) {
                MetaMessage metaMsg;
                MidiMeta midiMeta;
                MidiMessage msg;
                MidiEvent event = track.get(k);
                if (event == null || (msg = event.getMessage()) == null || !(msg instanceof MetaMessage) || (midiMeta = DefaultMidiMeta.parseMidiMeta((MetaMessage)(metaMsg = (MetaMessage)msg))) == null || !(midiMeta instanceof MidiMeta.SequenceName) || trackName != null || (trackName = ((MidiMeta.SequenceName)midiMeta).getText()) == null || (trackName = trackName.trim()).length() >= 1) continue;
                trackName = null;
            }
            if (trackName == null) {
                trackName = "Track #" + trackId;
            }
            DefaultMidiTrack midiTrack = new DefaultMidiTrack(resource, trackId, trackName, timeUnit, track);
            midiTrackList.add(midiTrack);
            midiTrackMap.put(trackId, midiTrack);
        }
        if (trackIds != null) {
            midiTrackList.clear();
            for (int i = 0; i < trackIds.length; ++i) {
                String trackId = trackIds[i];
                MidiTrack midiTrack = (MidiTrack)midiTrackMap.get(trackId);
                midiTrackList.add(midiTrack);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded Midi-Tracks: " + midiTrackList);
        }
        MidiTrack[] midiTracks = midiTrackList.toArray(new MidiTrack[midiTrackList.size()]);
        return midiTracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiModel createMidiModel(MidiTrack[] midiTracks, double secondsPerState, int modelType, int initCapacity, TimeUnit timeUnit, LockFactory lockFactory, boolean fair) throws Exception {
        DefaultMidiTrack defTrack;
        MidiModel midiModel;
        MidiTrack midiTrack;
        if (midiTracks.length < 1) {
            return null;
        }
        if (midiTracks.length == 1 && (midiTrack = midiTracks[0]) != null && midiTrack instanceof DefaultMidiTrack && (midiModel = (defTrack = (DefaultMidiTrack)midiTrack).getMidiModel()) != null) {
            defTrack.setMidiModel(null);
            defTrack.dispose();
            return midiModel;
        }
        boolean success = false;
        MidiModel midiModel2 = this.createMidiModel(secondsPerState, modelType, initCapacity, timeUnit, lockFactory, fair);
        try {
            Resource resource = null;
            String[] trackIds = new String[midiTracks.length];
            int trackIdCount = 0;
            long totalEventCount = 0L;
            for (int i = 0; i < midiTracks.length; ++i) {
                int mergedCount;
                String trackId;
                TimeUnit trackUnit;
                DefaultMidiTrack defTrack2;
                Track track;
                MidiTrack midiTrack2 = midiTracks[i];
                if (midiTrack2 == null || !(midiTrack2 instanceof DefaultMidiTrack) || (track = (defTrack2 = (DefaultMidiTrack)midiTrack2).getTrack()) == null || (trackUnit = defTrack2.getTimeUnit()) == null) continue;
                int trackInitCapacity = 32;
                long eventCount = defTrack2.getEventCount();
                if (eventCount > (long)trackInitCapacity && eventCount <= Integer.MAX_VALUE) {
                    trackInitCapacity = (int)eventCount;
                }
                ListTrackModel trackModel = new ListTrackModel(trackInitCapacity);
                this.loadTrackIntoTrackModel(track, (TrackModel)trackModel);
                if (resource == null) {
                    resource = defTrack2.getResource();
                }
                if ((trackId = defTrack2.getTrackId()) != null) {
                    trackIds[trackIdCount++] = trackId;
                }
                if ((mergedCount = midiModel2.mergeMidiModel(0L, Long.MAX_VALUE, (TrackModel)trackModel, trackUnit, 0L, Long.MAX_VALUE)) > 0) {
                    totalEventCount += (long)mergedCount;
                }
                defTrack2.setTrack(null);
                defTrack2.dispose();
            }
            MidiModel trackModel = midiModel2;
            int nodeCount = trackModel.getNodeCount();
            if ((long)nodeCount != totalEventCount) {
                logger.warning("Unexpected number of MIDI messages: " + nodeCount + " != " + totalEventCount);
            }
            midiModel2.setResource(resource);
            if (trackIdCount < trackIds.length) {
                String[] arr = new String[trackIdCount];
                System.arraycopy(trackIds, 0, arr, 0, trackIdCount);
                trackIds = arr;
            }
            midiModel2.setTrackIds(trackIds);
            success = true;
            MidiModel midiModel3 = midiModel2;
            return midiModel3;
        }
        finally {
            if (!success) {
                midiModel2.close();
            }
        }
    }

    protected static class LoadTrackModelIntoTrack
    implements NodeConsumer {
        protected Track track;
        protected int total;

        public LoadTrackModelIntoTrack(Track track) {
            this.track = track;
        }

        public boolean consume(Node node) {
            TrackNode n = (TrackNode)node;
            MidiMessage m = MidiModelUtil.newMessage(n);
            if (m != null) {
                this.track.add(new MidiEvent(m, n.getTick()));
                ++this.total;
            }
            return true;
        }

        public int getEventCount() {
            return this.total;
        }
    }
}

