/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Resource;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractLineChunk;
import com.waxmonster.model.impl.RealFaderChunk;
import com.waxmonster.model.impl.RealSampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RealFaderModel
extends RealSampleModel
implements FaderModel {
    private final FaderModel faderModel;
    private final int bufFrames;
    private String name;
    private Resource resource;
    private String[] trackIds;
    protected List chunks;

    public RealFaderModel(FaderModel faderModel, SampleModel model, long sampleIndex, boolean readOnly, boolean closeModel, int bufferCount, int bufferSize, SampleBuffer[] sampleBuffers, ReadWriteLock bufLock, ThreadPool threadPool) throws IOException, InterruptedException {
        super(model, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, threadPool);
        this.faderModel = faderModel;
        this.bufFrames = bufferSize / this.channels;
        if (this.channels != 1) {
            throw new IllegalArgumentException("Invalid number of fader channels: " + this.channels + " != 1");
        }
        if (faderModel != null) {
            this.setName(faderModel.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    public long getFrameLength() {
        return this.getSamples();
    }

    public long getUnitLength() {
        return this.getSamples();
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    public long getNanoLength() {
        return (long)Math.ceil(LineUtil.getNanoPos((long)this.getFrameLength(), (double)this.frameRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(double framePos, double fpu, float[] dst, int off, int len) throws IOException {
        int n;
        if (framePos < 0.0) {
            throw new IOException("Invalid frame position: " + framePos);
        }
        if (fpu <= 0.0) {
            throw new IOException("Invalid frames per unit: " + fpu);
        }
        int num = len;
        long i = (long)framePos;
        double d = 0.0;
        int end = off + len;
        this.lock.lockRead();
        try {
            SampleBuffer sb;
            RealSampleModel.Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                sb = this.buf.sb;
                d = framePos - (double)b.ofs;
                n = 1 + (int)(((double)this.bufFrames - d - 1.0) / fpu);
                if (n >= num) {
                    while (off < end) {
                        dst[off++] = sb.getFloat((int)d);
                        d += fpu;
                    }
                    return;
                }
                while (d < (double)this.bufFrames) {
                    dst[off++] = sb.getFloat((int)d);
                    d += fpu;
                }
                b = b.next;
                d -= (double)this.bufFrames;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    sb = b.sb;
                    d = framePos - (double)b.ofs;
                    n = 1 + (int)(((double)this.bufFrames - d - 1.0) / fpu);
                    if (n >= num) {
                        while (off < end) {
                            dst[off++] = sb.getFloat((int)d);
                            d += fpu;
                        }
                        return;
                    }
                    while (d < (double)this.bufFrames) {
                        dst[off++] = sb.getFloat((int)d);
                        d += fpu;
                    }
                    b = b.next;
                    d -= (double)this.bufFrames;
                } else {
                    long fo = this.first.ofs;
                    if (framePos < (double)fo && framePos + (double)(len - 1) * fpu > (double)fo) {
                        n = 1 + (int)(((double)fo - framePos) / fpu);
                        this.faderModel.getValues(framePos, fpu, dst, off, n);
                        off += n;
                        b = this.first;
                        d = framePos + (double)n * fpu - (double)fo;
                    }
                }
            }
            while (b != null) {
                sb = b.sb;
                n = 1 + (int)(((double)this.bufFrames - d - 1.0) / fpu);
                if (n >= end - off) {
                    while (off < end) {
                        dst[off++] = sb.getFloat((int)d);
                        d += fpu;
                    }
                    return;
                }
                while (d < (double)this.bufFrames) {
                    dst[off++] = sb.getFloat((int)d);
                    d += fpu;
                }
                b = b.next;
                d -= (double)this.bufFrames;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        n = end - off;
        this.faderModel.getValues(framePos += (double)(len - n) * fpu, fpu, dst, off, n);
    }

    public final FaderModel getFaderModel() {
        return this.faderModel;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.chunks = null;
    }

    protected final synchronized void chunkCreated(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(chunk);
    }

    protected final synchronized void chunkClosed(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            return;
        }
        this.chunks.remove(chunk);
    }

    public final synchronized int getChunkCount() {
        return this.chunks == null ? 0 : this.chunks.size();
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        RealFaderChunk chunk = new RealFaderChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, this);
        this.chunkCreated(chunk);
        return chunk;
    }
}

