/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.waxmonster.model.MidiChunk;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.impl.MidiTrackWriter;
import com.waxmonster.studio.SyncClock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealMidiTrackWriter
implements MidiTrackWriter {
    private static final Logger logger = Logger.getLogger(RealMidiTrackWriter.class.getName());
    protected final LockSupport lockSupport;
    protected final Work work;
    protected final Thread thread;
    protected volatile boolean active;
    protected final MidiModel model;
    protected final Entry[] queue;
    protected final int len;
    protected volatile int head;
    protected volatile int tail;
    protected final double nanosPerTick;
    protected double start;
    protected SyncClock master;

    public RealMidiTrackWriter(MidiModel model, MidiChunk chunk, SyncClock master, int queueSize, LockSupport lockSupport, ThreadPool threadPool) throws InterruptedException {
        if (model == null) {
            throw new NullPointerException("model is null");
        }
        if (master == null) {
            throw new NullPointerException("master is null");
        }
        if (lockSupport == null) {
            throw new NullPointerException("lockSupport is null");
        }
        this.model = model;
        this.nanosPerTick = model.getTimeUnit().nanosecondsPerUnit();
        this.start = chunk.getChunkOfs();
        this.master = master;
        this.len = queueSize;
        this.lockSupport = lockSupport;
        Entry[] arr = new Entry[queueSize];
        for (int i = 0; i < queueSize; ++i) {
            arr[i] = new Entry();
        }
        this.queue = arr;
        this.active = true;
        this.work = threadPool.start((Runnable)new Writer());
        this.thread = threadPool.getThread(this.work);
    }

    public SyncClock getMaster() {
        return this.master;
    }

    public void setMaster(SyncClock master) {
        if (master == null) {
            throw new NullPointerException("master is null");
        }
        this.master = master;
    }

    @Override
    public void writeNode(long time, int status) {
        int i = this.tail;
        int k = (i + 1) % this.len;
        if (k == this.head) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("FIXME queue is full: " + this + ", len=" + this.len);
            }
            long tick = (long)(((double)this.master.nanoSync(time) - this.start) / this.nanosPerTick);
            this.model.addNode(this.model.newNode(tick, status));
            return;
        }
        Entry entry = this.queue[i];
        entry.time = time;
        entry.len = 1;
        entry.status = status;
        this.tail = k;
        this.lockSupport.unpark(this.thread);
    }

    @Override
    public void writeNode(long time, int status, int data1) {
        int i = this.tail;
        int k = (i + 1) % this.len;
        if (k == this.head) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("FIXME queue is full: " + this + ", len=" + this.len);
            }
            long tick = (long)(((double)this.master.nanoSync(time) - this.start) / this.nanosPerTick);
            this.model.addNode(this.model.newNode(tick, status, data1));
            return;
        }
        Entry entry = this.queue[i];
        entry.time = time;
        entry.len = 2;
        entry.status = status;
        entry.data1 = data1;
        this.tail = k;
        this.lockSupport.unpark(this.thread);
    }

    @Override
    public void writeNode(long time, int status, int data1, int data2) {
        int i = this.tail;
        int k = (i + 1) % this.len;
        if (k == this.head) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("FIXME queue is full: " + this + ", len=" + this.len);
            }
            long tick = (long)(((double)this.master.nanoSync(time) - this.start) / this.nanosPerTick);
            this.model.addNode(this.model.newNode(tick, status, data1, data2));
            return;
        }
        Entry entry = this.queue[i];
        entry.time = time;
        entry.len = 3;
        entry.status = status;
        entry.data1 = data1;
        entry.data2 = data2;
        this.tail = k;
        this.lockSupport.unpark(this.thread);
    }

    @Override
    public void writeNode(long time, int status, byte[] data, int off, int num) {
        int i = this.tail;
        int k = (i + 1) % this.len;
        if (k == this.head) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("FIXME queue is full: " + this + ", len=" + this.len);
            }
            long tick = (long)(((double)this.master.nanoSync(time) - this.start) / this.nanosPerTick);
            this.model.addNode(this.model.newNode(tick, status, data, off, num));
            return;
        }
        Entry entry = this.queue[i];
        entry.time = time;
        entry.len = num;
        entry.status = status;
        switch (num) {
            case 1: {
                break;
            }
            case 2: {
                entry.data1 = data[1] & 0xFF;
                break;
            }
            case 3: {
                entry.data1 = data[1] & 0xFF;
                entry.data2 = data[2] & 0xFF;
                break;
            }
            default: {
                entry.off = off;
                entry.data = data;
            }
        }
        this.tail = k;
        this.lockSupport.unpark(this.thread);
    }

    protected void loop() {
        while (this.active) {
            while (this.head != this.tail) {
                Entry entry = this.queue[this.head];
                long tick = (long)(((double)this.master.nanoSync(entry.time) - this.start) / this.nanosPerTick);
                switch (entry.len) {
                    case 1: {
                        this.model.addNode(this.model.newNode(tick, entry.status));
                        break;
                    }
                    case 2: {
                        this.model.addNode(this.model.newNode(tick, entry.status, entry.data1));
                        break;
                    }
                    case 3: {
                        this.model.addNode(this.model.newNode(tick, entry.status, entry.data1, entry.data2));
                        break;
                    }
                    default: {
                        this.model.addNode(this.model.newNode(tick, entry.status, entry.data, entry.off, entry.len));
                        entry.data = null;
                    }
                }
                this.head = (this.head + 1) % this.len;
            }
            this.lockSupport.park();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void cancel() {
        this.active = false;
        this.lockSupport.unpark(this.thread);
    }

    public void join() throws InterruptedException {
        this.work.join();
    }

    public void join(long millis) throws InterruptedException {
        this.work.join(millis);
    }

    public void join(long millis, int nanos) throws InterruptedException {
        this.work.join(millis, nanos);
    }

    @Override
    public void close() throws InterruptedException {
        this.cancel();
        this.join();
    }

    protected class Writer
    implements Runnable {
        protected Writer() {
        }

        @Override
        public void run() {
            RealMidiTrackWriter.this.loop();
        }
    }

    protected static class Entry {
        protected long time;
        protected int len;
        protected int status;
        protected int data1;
        protected int data2;
        protected int off;
        protected byte[] data;

        protected Entry() {
        }
    }
}

