/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.waxmonster.model.impl.RealSampleModel;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class RealSampleCursor
implements SampleCursor {
    private final RealSampleModel model;
    private final int bufSize;
    private SampleBuffer sb;
    private long bo;
    private int bi;
    private long dropOuts;

    protected RealSampleCursor(RealSampleModel model, int bufSize, boolean readOnly, RealSampleModel.Buf buf, int index) {
        this.model = model;
        this.bufSize = bufSize;
        this.sb = buf.sb;
        this.bo = buf.ofs;
        this.bi = index;
        if (!readOnly) {
            buf.dirty = true;
        }
    }

    public boolean isReadOnly() {
        return this.model.isReadOnly();
    }

    public int getChannels() {
        return this.model.getChannels();
    }

    public float getFrameRate() {
        return this.model.getFrameRate();
    }

    public long getSamples() {
        return this.model.getSamples();
    }

    public long getPosition() {
        return this.bo + (long)this.bi;
    }

    public void flush() {
        this.model.cursorFlush(this);
    }

    public void close() {
        this.flush();
        this.model.cursorClose(this);
        this.sb = null;
        this.bo = -1L;
        this.bi = -1;
    }

    public void get(double[] dst, int off, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.get(this.bi, dst, off, len);
            this.bi += len;
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.get(this.bi, dst, off, num);
        off += num;
        len -= num;
        RealSampleModel.Buf b = this.model.readNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.get(0, dst, off, len);
                this.bi = len;
                this.bo = b.ofs;
                return;
            }
            this.sb.get(0, dst, off, this.bufSize);
            off += this.bufSize;
            len -= this.bufSize;
            b = this.model.readNext();
        }
        ++this.dropOuts;
        Arrays.fill(dst, off, off + len, 0.0);
    }

    public void get(float[] dst, int off, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.get(this.bi, dst, off, len);
            this.bi += len;
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.get(this.bi, dst, off, num);
        off += num;
        len -= num;
        RealSampleModel.Buf b = this.model.readNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.get(0, dst, off, len);
                this.bi = len;
                this.bo = b.ofs;
                return;
            }
            this.sb.get(0, dst, off, this.bufSize);
            off += this.bufSize;
            len -= this.bufSize;
            b = this.model.readNext();
        }
        ++this.dropOuts;
        Arrays.fill(dst, off, off + len, 0.0f);
    }

    public void get(DoubleBuffer dst, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.get(this.bi, dst, len);
            this.bi += len;
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.get(this.bi, dst, num);
        len -= num;
        RealSampleModel.Buf b = this.model.readNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.get(0, dst, len);
                this.bi = len;
                this.bo = b.ofs;
                return;
            }
            this.sb.get(0, dst, this.bufSize);
            len -= this.bufSize;
            b = this.model.readNext();
        }
        ++this.dropOuts;
        while (len-- > 0) {
            dst.put(0.0);
        }
    }

    public void get(FloatBuffer dst, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.get(this.bi, dst, len);
            this.bi += len;
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.get(this.bi, dst, num);
        len -= num;
        RealSampleModel.Buf b = this.model.readNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.get(0, dst, len);
                this.bi = len;
                this.bo = b.ofs;
                return;
            }
            this.sb.get(0, dst, this.bufSize);
            len -= this.bufSize;
            b = this.model.readNext();
        }
        ++this.dropOuts;
        while (len-- > 0) {
            dst.put(0.0f);
        }
    }

    public void get(SampleBuffer dst, int off, int len) {
        if (this.bi + len < this.bufSize) {
            dst.set(off, this.sb, this.bi, len);
            this.bi += len;
            return;
        }
        int num = this.bufSize - this.bi;
        dst.set(off, this.sb, this.bi, num);
        off += num;
        len -= num;
        RealSampleModel.Buf b = this.model.readNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                dst.set(off, this.sb, 0, len);
                this.bi = len;
                this.bo = b.ofs;
                return;
            }
            dst.set(off, this.sb, 0, this.bufSize);
            off += this.bufSize;
            len -= this.bufSize;
            b = this.model.readNext();
        }
        ++this.dropOuts;
        dst.clear(off, len);
    }

    public void set(double[] src, int off, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.set(this.bi, src, off, len);
            this.bi += len;
            this.model.cursorMod(this.bo + (long)this.bi);
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.set(this.bi, src, off, num);
        off += num;
        len -= num;
        RealSampleModel.Buf b = this.model.writeNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.set(0, src, off, len);
                this.bi = len;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            this.sb.set(0, src, off, this.bufSize);
            off += this.bufSize;
            len -= this.bufSize;
            b = this.model.writeNext();
        }
        ++this.dropOuts;
    }

    public void set(float[] src, int off, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.set(this.bi, src, off, len);
            this.bi += len;
            this.model.cursorMod(this.bo + (long)this.bi);
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.set(this.bi, src, off, num);
        off += num;
        len -= num;
        RealSampleModel.Buf b = this.model.writeNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.set(0, src, off, len);
                this.bi = len;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            this.sb.set(0, src, off, this.bufSize);
            off += this.bufSize;
            len -= this.bufSize;
            b = this.model.writeNext();
        }
        ++this.dropOuts;
    }

    public void set(DoubleBuffer src, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.set(this.bi, src, len);
            this.bi += len;
            this.model.cursorMod(this.bo + (long)this.bi);
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.set(this.bi, src, num);
        len -= num;
        RealSampleModel.Buf b = this.model.writeNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.set(0, src, len);
                this.bi = len;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            this.sb.set(0, src, this.bufSize);
            len -= this.bufSize;
            b = this.model.writeNext();
        }
        ++this.dropOuts;
    }

    public void set(FloatBuffer src, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.set(this.bi, src, len);
            this.bi += len;
            this.model.cursorMod(this.bo + (long)this.bi);
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.set(this.bi, src, num);
        len -= num;
        RealSampleModel.Buf b = this.model.writeNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.set(0, src, len);
                this.bi = len;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            this.sb.set(0, src, this.bufSize);
            len -= this.bufSize;
            b = this.model.writeNext();
        }
        ++this.dropOuts;
    }

    public void set(SampleBuffer src, int off, int len) {
        if (this.bi + len < this.bufSize) {
            this.sb.set(this.bi, src, off, len);
            this.bi += len;
            this.model.cursorMod(this.bo + (long)this.bi);
            return;
        }
        int num = this.bufSize - this.bi;
        this.sb.set(this.bi, src, off, num);
        off += num;
        len -= num;
        RealSampleModel.Buf b = this.model.writeNext();
        while (b != null) {
            this.sb = b.sb;
            if (len < this.bufSize) {
                this.sb.set(0, src, off, len);
                this.bi = len;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            this.sb.set(0, src, off, this.bufSize);
            off += this.bufSize;
            len -= this.bufSize;
            b = this.model.writeNext();
        }
        ++this.dropOuts;
    }

    public void move(int n) {
        int x = this.bi + n;
        if (x < 0) {
            throw new IllegalArgumentException("Cannot move realtime cursor backward: n=" + n + ", x=" + x);
        }
        if (x < this.bufSize) {
            this.bi = x;
            return;
        }
        n -= this.bufSize - this.bi;
        RealSampleModel.Buf b = this.model.writeNext();
        while (b != null) {
            this.sb = b.sb;
            if (n < this.bufSize) {
                this.bi = n;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            n -= this.bufSize;
            b = this.model.writeNext();
        }
        b = this.model.writeNextSync();
        while (b != null) {
            this.sb = b.sb;
            if (n < this.bufSize) {
                this.bi = n;
                this.bo = b.ofs;
                this.model.cursorMod(this.bo + (long)this.bi);
                return;
            }
            n -= this.bufSize;
            b = this.model.writeNextSync();
        }
        throw new UnsupportedOperationException("Failed to move cursor: " + n);
    }

    public long getDropOuts() {
        return this.dropOuts;
    }

    public void resetDropOuts() {
        this.dropOuts = 0L;
    }
}

