/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.waxmonster.model.impl.RealSampleCursor;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RealSampleModel
extends AbstractSampleModel {
    public static final int MIN_BUFFER_COUNT = 5;
    private static final Logger logger = Logger.getLogger(RealSampleModel.class.getName());
    protected final SampleModel model;
    protected final boolean readOnly;
    protected final boolean closeModel;
    protected final ReadWriteLock lock;
    protected final int bufCount;
    protected final int bufSize;
    protected final int bufLen;
    private volatile long samples;
    protected Buf first;
    protected Buf last;
    protected volatile Buf buf;
    private RealSampleCursor cur;
    private final Worker worker;
    private final Work work;

    public RealSampleModel(SampleModel model, long sampleIndex, boolean readOnly, boolean closeModel, int bufferCount, int bufferSize, SampleBuffer[] sampleBuffers, ReadWriteLock bufLock, ThreadPool threadPool) throws IOException, InterruptedException {
        super(model.getChannels(), model.getFrameRate());
        if (bufferCount < 5) {
            throw new IllegalArgumentException("Invalid buffer count: " + bufferCount + " < " + 5);
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        this.readOnly = readOnly || model.isReadOnly();
        this.closeModel = closeModel;
        this.model = model;
        this.lock = bufLock;
        this.bufCount = bufferCount;
        this.bufSize = bufferSize;
        this.bufLen = bufferSize * bufferCount;
        this.first = null;
        this.last = null;
        this.samples = model.getSamples();
        long start = sampleIndex / (long)bufferSize * (long)bufferSize;
        for (int i = 0; i < bufferCount; ++i) {
            SampleBuffer sb = sampleBuffers[i];
            if (sb.getSamples() < bufferSize) {
                throw new IllegalArgumentException("Invalid sample buffer size: " + sb.getSamples() + " < " + bufferSize);
            }
            Buf newBuf = new Buf(sb);
            newBuf.ofs = start;
            newBuf.end = start += (long)this.bufSize;
            if (this.last == null) {
                this.first = newBuf;
            } else {
                this.last.next = newBuf;
            }
            newBuf.prev = this.last;
            this.last = newBuf;
            this.load(newBuf);
        }
        this.buf = this.first;
        if (model.getSamples() <= 0L && this.readOnly) {
            this.worker = null;
            this.work = null;
        } else {
            this.worker = new Worker();
            this.work = threadPool.start((Runnable)this.worker);
        }
    }

    public long getSamples() {
        return this.samples;
    }

    public boolean isModelEmpty() {
        return this.samples < 1L;
    }

    public boolean isEmpty() {
        return this.samples < 1L;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void flush() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.flushRealtime();
        this.model.flush();
    }

    final void flushRealtime() throws IOException {
        if (this.readOnly) {
            return;
        }
        Buf exclude = null;
        if (this.cur != null) {
            exclude = this.buf;
        }
        Buf b = this.first;
        while (b != null) {
            if (b.dirty && b != exclude) {
                this.save(b);
            }
            b = b.next;
        }
    }

    public void close() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing model: " + (Object)((Object)this));
        }
        if (this.worker != null) {
            this.worker.stop();
            try {
                this.work.join();
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (!this.readOnly) {
            this.flush();
        }
        if (this.closeModel) {
            this.model.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SampleCursor openRealtimeCursor(long sampleIndex) throws IOException {
        Buf theBuf;
        if (this.cur != null) {
            throw new IllegalStateException("Realtime-SampleCursor is already initialized: " + this.cur);
        }
        this.lock.lockWrite();
        try {
            theBuf = sampleIndex < this.buf.ofs || sampleIndex >= this.buf.end ? this.getBuf(sampleIndex) : this.buf;
            if (theBuf == null) {
                long start;
                if (sampleIndex < this.last.end && sampleIndex + (long)(this.bufCount * this.bufSize) > this.first.ofs) {
                    start = this.first.ofs;
                    while (sampleIndex < start) {
                        Buf b = this.last;
                        if (b.dirty) {
                            this.save(b);
                        }
                        b.end = start;
                        b.ofs = start -= (long)this.bufSize;
                        b.loaded = false;
                        this.last = b.prev;
                        this.last.next = null;
                        b.prev = null;
                        b.next = this.first;
                        this.first.prev = b;
                        this.first = b;
                    }
                } else {
                    start = sampleIndex / (long)this.bufSize * (long)this.bufSize;
                    Buf b = this.first;
                    while (b != null) {
                        if (b.dirty) {
                            this.save(b);
                        }
                        b.ofs = start;
                        b.end = start += (long)this.bufSize;
                        b.loaded = false;
                        b = b.next;
                    }
                }
                theBuf = this.first;
            } else {
                while (this.first != theBuf) {
                    if (this.first.dirty) {
                        this.save(this.first);
                    }
                    this.first.ofs = this.last.end;
                    this.first.end = this.first.ofs + (long)this.bufSize;
                    this.first.loaded = false;
                    this.first.prev = this.last;
                    this.last.next = this.first;
                    this.last = this.first;
                    this.first = this.first.next;
                    this.last.next = null;
                }
                theBuf.prev = null;
            }
            this.buf = theBuf;
        }
        finally {
            this.lock.unlockWrite();
        }
        if (!theBuf.loaded) {
            this.load(theBuf);
        }
        this.loadAll();
        int index = (int)(sampleIndex - theBuf.ofs);
        this.cur = new RealSampleCursor(this, this.bufSize, this.readOnly, theBuf, index);
        return this.cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void cursorFlush(RealSampleCursor c) {
        if (c == this.cur && !this.readOnly) {
            try {
                this.lock.lockRead();
                try {
                    Buf b = this.first;
                    while (b != null) {
                        if (b.dirty) {
                            this.save(b);
                        }
                        b = b.next;
                    }
                }
                finally {
                    this.lock.unlockRead();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    final synchronized void cursorClose(RealSampleCursor c) {
        if (c == this.cur) {
            this.cur = null;
        }
    }

    final void cursorMod(long end) {
        if (end > this.samples) {
            this.samples = end;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buf readNext() {
        Buf b;
        this.lock.lockRead();
        try {
            b = this.buf.next;
            if (b == null) {
                Buf buf = null;
                return buf;
            }
            if (!b.loaded) {
                Buf buf = null;
                return buf;
            }
            this.buf = b;
        }
        finally {
            this.lock.unlockRead();
        }
        this.worker.bufferSwitch();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buf writeNext() {
        Buf b;
        this.lock.lockRead();
        try {
            b = this.buf.next;
            if (b == null) {
                Buf buf = null;
                return buf;
            }
            if (!b.loaded) {
                Buf buf = null;
                return buf;
            }
            this.buf = b;
            b.dirty = true;
        }
        finally {
            this.lock.unlockRead();
        }
        this.worker.bufferSwitch();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buf writeNextSync() {
        Buf b;
        boolean unlock = true;
        this.lock.lockRead();
        try {
            b = this.buf.next;
            if (b == null || !b.loaded) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("waiting for next buffer...");
                }
                RealSampleModel realSampleModel = this;
                synchronized (realSampleModel) {
                    unlock = false;
                    this.lock.unlockRead();
                    while (true) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        unlock = true;
                        this.lock.lockRead();
                        b = this.buf.next;
                        if (b != null && b.loaded) break;
                        unlock = false;
                        this.lock.unlockRead();
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("resume next buffer: " + b);
                }
            }
            this.buf = b;
            b.dirty = true;
        }
        finally {
            if (unlock) {
                this.lock.unlockRead();
            }
        }
        this.worker.bufferSwitch();
        return b;
    }

    protected void load(Buf b) throws IOException {
        long samples;
        int i = 0;
        int len = this.bufSize;
        SampleBuffer sb = b.sb;
        long index = b.ofs;
        if (index < 0L) {
            if (index <= (long)(-this.bufSize)) {
                if (!b.clean) {
                    sb.clear(0, this.bufSize);
                    b.clean = true;
                }
                b.loaded = true;
                return;
            }
            int n = (int)(-index);
            sb.clear(0, n);
            i += n;
            len -= n;
            index = 0L;
        }
        if (index + (long)len > (samples = this.model.getSamples())) {
            long z = index + (long)len - samples;
            if (z >= (long)this.bufSize) {
                if (!b.clean) {
                    sb.clear(0, this.bufSize);
                    b.clean = true;
                }
                b.loaded = true;
                return;
            }
            int n = (int)z;
            sb.clear(i + (len -= n), n);
        }
        b.clean = false;
        b.dirty = false;
        this.model.get(index, sb, i, len);
        b.loaded = true;
    }

    protected void save(Buf b) throws IOException {
        long samps;
        int i = 0;
        int len = this.bufSize;
        SampleBuffer sb = b.sb;
        long index = b.ofs;
        if (index < 0L) {
            if (index <= (long)(-this.bufSize)) {
                b.dirty = false;
                return;
            }
            i = (int)(-index);
            len -= i;
            index = 0L;
        }
        if (index + (long)len > (samps = this.samples)) {
            if (index >= samps) {
                b.dirty = false;
                return;
            }
            len = (int)(samps - index);
        }
        this.model.set(index, sb, i, len);
        b.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAll() throws IOException {
        while (true) {
            Buf b;
            this.lock.lockWrite();
            try {
                b = this.first;
                while (b != null) {
                    if (!b.loaded && b != this.buf) {
                        break;
                    }
                    b = b.next;
                }
            }
            finally {
                this.lock.unlockWrite();
            }
            if (b == null) break;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Loading skipped buffer: ofs=" + b.ofs + ", end=" + b.end);
            }
            this.load(b);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded all skipped buffers.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void work(boolean forward) throws IOException {
        Buf b;
        boolean dirt;
        if (forward) {
            dirt = false;
            this.lock.lockWrite();
            try {
                if (this.first == this.buf) {
                    return;
                }
                b = this.first;
                if (b.dirty) {
                    dirt = true;
                } else {
                    this.first = b.next;
                    this.first.prev = null;
                    b.next = null;
                    b.loaded = false;
                    b.ofs = this.last.end;
                    b.end = b.ofs + (long)this.bufSize;
                    b.prev = this.last;
                    this.last.next = b;
                    this.last = b;
                }
            }
            finally {
                this.lock.unlockWrite();
            }
            if (dirt) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Saving buffer (async): " + b);
                }
                this.save(b);
                this.lock.lockWrite();
                try {
                    if (this.first != b) {
                        return;
                    }
                    this.first = b.next;
                    this.first.prev = null;
                    b.next = null;
                    b.loaded = false;
                    b.ofs = this.last.end;
                    b.end = b.ofs + (long)this.bufSize;
                    b.prev = this.last;
                    this.last.next = b;
                    this.last = b;
                }
                finally {
                    this.lock.unlockWrite();
                }
            }
        } else {
            dirt = false;
            this.lock.lockWrite();
            try {
                if (this.last == this.buf) {
                    return;
                }
                b = this.last;
                if (b.dirty) {
                    dirt = true;
                } else {
                    this.last = b.prev;
                    this.last.next = null;
                    b.prev = null;
                    b.loaded = false;
                    b.end = this.first.ofs;
                    b.ofs = b.end - (long)this.bufSize;
                    b.next = this.first;
                    this.first.prev = b;
                    this.first = b;
                }
            }
            finally {
                this.lock.unlockWrite();
            }
            if (dirt) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Saving buffer (async): " + b);
                }
                this.save(b);
                this.lock.lockWrite();
                try {
                    if (this.last != b) {
                        return;
                    }
                    this.last = b.prev;
                    this.last.next = null;
                    b.prev = null;
                    b.loaded = false;
                    b.end = this.first.ofs;
                    b.ofs = b.end - (long)this.bufSize;
                    b.next = this.first;
                    this.first.prev = b;
                    this.first = b;
                }
                finally {
                    this.lock.unlockWrite();
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loading buffer (async): " + b);
        }
        this.load(b);
        RealSampleModel realSampleModel = this;
        synchronized (realSampleModel) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected Buf getBuf(long i) {
        if (i < this.first.ofs || i >= this.last.end) {
            return null;
        }
        Buf b = this.first;
        while (b != null) {
            if (i < b.end && i >= b.ofs) {
                return b;
            }
            b = b.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, double[] dst, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, off, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, off, n);
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.get((int)(i - b.ofs), dst, off, len);
                        return;
                    }
                    b.sb.get((int)(i - b.ofs), dst, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.get(i, dst, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, off, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, off, n);
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.get(i, dst, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, float[] dst, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, off, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, off, n);
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.get((int)(i - b.ofs), dst, off, len);
                        return;
                    }
                    b.sb.get((int)(i - b.ofs), dst, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.get(i, dst, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, off, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, off, n);
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.get(i, dst, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, n);
                i += (long)n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.get((int)(i - b.ofs), dst, len);
                        return;
                    }
                    b.sb.get((int)(i - b.ofs), dst, n);
                    i += (long)n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.get(i, dst, n);
                    i += (long)n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, n);
                i += (long)n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.get(i, dst, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, n);
                i += (long)n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.get((int)(i - b.ofs), dst, len);
                        return;
                    }
                    b.sb.get((int)(i - b.ofs), dst, n);
                    i += (long)n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.get(i, dst, n);
                    i += (long)n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.get((int)(i - b.ofs), dst, len);
                    return;
                }
                b.sb.get((int)(i - b.ofs), dst, n);
                i += (long)n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.get(i, dst, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    dst.set(off, b.sb, (int)(i - b.ofs), len);
                    return;
                }
                dst.set(off, b.sb, (int)(i - b.ofs), n);
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        dst.set(off, b.sb, (int)(i - b.ofs), len);
                        return;
                    }
                    dst.set(off, b.sb, (int)(i - b.ofs), n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.get(i, dst, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    dst.set(off, b.sb, (int)(i - b.ofs), len);
                    return;
                }
                dst.set(off, b.sb, (int)(i - b.ofs), n);
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.get(i, dst, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(long i) throws IOException {
        this.lock.lockRead();
        try {
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                double d = b.sb.getDouble((int)(i - b.ofs));
                return d;
            }
            b = this.getBuf(i);
            if (b != null) {
                double d = b.sb.getDouble((int)(i - b.ofs));
                return d;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        return this.model.getDouble(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(long i) throws IOException {
        this.lock.lockRead();
        try {
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                float f = b.sb.getFloat((int)(i - b.ofs));
                return f;
            }
            b = this.getBuf(i);
            if (b != null) {
                float f = b.sb.getFloat((int)(i - b.ofs));
                return f;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        return this.model.getFloat(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, double v) throws IOException {
        if (i >= this.samples) {
            this.grow(i + 1L);
        }
        this.lock.lockRead();
        try {
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                b.sb.set((int)(i - b.ofs), v);
                b.dirty = true;
                return;
            }
            b = this.getBuf(i);
            if (b != null) {
                b.sb.set((int)(i - b.ofs), v);
                b.dirty = true;
                return;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, float v) throws IOException {
        if (i >= this.samples) {
            this.grow(i + 1L);
        }
        this.lock.lockRead();
        try {
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                b.sb.set((int)(i - b.ofs), v);
                b.dirty = true;
                return;
            }
            b = this.getBuf(i);
            if (b != null) {
                b.sb.set((int)(i - b.ofs), v);
                b.dirty = true;
                return;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, double[] src, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        if (i + (long)len > this.samples) {
            this.grow(i + (long)len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, off, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, off, n);
                b.dirty = true;
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.set((int)(i - b.ofs), src, off, len);
                        b.dirty = true;
                        return;
                    }
                    b.sb.set((int)(i - b.ofs), src, off, n);
                    b.dirty = true;
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.set(i, src, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, off, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, off, n);
                b.dirty = true;
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, src, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, float[] src, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        if (i + (long)len > this.samples) {
            this.grow(i + (long)len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, off, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, off, n);
                b.dirty = true;
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.set((int)(i - b.ofs), src, off, len);
                        b.dirty = true;
                        return;
                    }
                    b.sb.set((int)(i - b.ofs), src, off, n);
                    b.dirty = true;
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.set(i, src, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, off, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, off, n);
                b.dirty = true;
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, src, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        if (i + (long)len > this.samples) {
            this.grow(i + (long)len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, off, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, off, n);
                b.dirty = true;
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.set((int)(i - b.ofs), src, off, len);
                        b.dirty = true;
                        return;
                    }
                    b.sb.set((int)(i - b.ofs), src, off, n);
                    b.dirty = true;
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.set(i, src, off, n);
                    i += (long)n;
                    off += n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, off, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, off, n);
                b.dirty = true;
                i += (long)n;
                off += n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, src, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        if (i + (long)len > this.samples) {
            this.grow(i + (long)len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, n);
                b.dirty = true;
                i += (long)n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.set((int)(i - b.ofs), src, len);
                        b.dirty = true;
                        return;
                    }
                    b.sb.set((int)(i - b.ofs), src, n);
                    b.dirty = true;
                    i += (long)n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.set(i, src, n);
                    i += (long)n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, n);
                b.dirty = true;
                i += (long)n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, src, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long i, FloatBuffer src, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        if (i + (long)len > this.samples) {
            this.grow(i + (long)len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, n);
                b.dirty = true;
                i += (long)n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.set((int)(i - b.ofs), src, len);
                        b.dirty = true;
                        return;
                    }
                    b.sb.set((int)(i - b.ofs), src, n);
                    b.dirty = true;
                    i += (long)n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.set(i, src, n);
                    i += (long)n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.set((int)(i - b.ofs), src, len);
                    b.dirty = true;
                    return;
                }
                b.sb.set((int)(i - b.ofs), src, n);
                b.dirty = true;
                i += (long)n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.set(i, src, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(long i, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        if (i + (long)len > this.samples) {
            this.grow(i + (long)len);
        }
        this.lock.lockRead();
        try {
            int n;
            Buf b = this.buf;
            if (i >= b.ofs && i < b.end) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.clear((int)(i - b.ofs), len);
                    b.dirty = true;
                    return;
                }
                b.sb.clear((int)(i - b.ofs), n);
                b.dirty = true;
                i += (long)n;
                len -= n;
                b = b.next;
            } else {
                b = this.getBuf(i);
                if (b != null) {
                    n = (int)(b.end - i);
                    if (len <= n) {
                        b.sb.clear((int)(i - b.ofs), len);
                        b.dirty = true;
                        return;
                    }
                    b.sb.clear((int)(i - b.ofs), n);
                    b.dirty = true;
                    i += (long)n;
                    len -= n;
                    b = b.next;
                } else if (i < this.first.ofs && i + (long)len > this.first.ofs) {
                    n = (int)(this.first.ofs - i);
                    this.model.clear(i, n);
                    i += (long)n;
                    len -= n;
                    b = this.first;
                }
            }
            while (b != null) {
                n = (int)(b.end - i);
                if (len <= n) {
                    b.sb.clear((int)(i - b.ofs), len);
                    b.dirty = true;
                    return;
                }
                b.sb.clear((int)(i - b.ofs), n);
                b.dirty = true;
                i += (long)n;
                len -= n;
                b = b.next;
            }
            this.flushRealtime();
        }
        finally {
            this.lock.unlockRead();
        }
        this.model.clear(i, len);
    }

    private void grow(long size) throws IOException {
        if (size > this.samples) {
            this.samples = size;
        }
    }

    public long append(int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        long i = this.samples;
        this.grow(i + (long)len);
        return i;
    }

    public long append(double[] src, int off, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, off, len);
        return i;
    }

    public long append(float[] src, int off, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, off, len);
        return i;
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, len);
        return i;
    }

    public long append(FloatBuffer src, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, len);
        return i;
    }

    public long append(SampleBuffer src, int off, int len) throws IOException {
        long i = this.samples;
        this.set(i, src, off, len);
        return i;
    }

    public void insert(long i, int len) throws IOException {
        if (i < 0L || i > this.samples) {
            throw new IOException("Invalid sample insert index: i=" + i + ", samples=" + this.samples);
        }
        if (len < 1) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        throw new UnsupportedOperationException();
    }

    public void remove(long i, int len) throws IOException {
        if (i < 0L || i + (long)len > this.samples) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + this.samples);
        }
        if (len < 1) {
            throw new IllegalArgumentException("Invalid number of samples: " + len);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Buffers...\n");
        this.lock.lockRead();
        try {
            int i = 0;
            Buf b = this.first;
            while (b != null) {
                sb.append(" - Buffer #" + i + ": " + b);
                if (b == this.first) {
                    sb.append(" (first)");
                }
                if (b == this.last) {
                    sb.append(" (last)");
                }
                if (b == this.buf) {
                    sb.append(" -> current !");
                }
                sb.append('\n');
                ++i;
                b = b.next;
            }
        }
        finally {
            this.lock.unlockRead();
        }
        logger.info(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency() {
        int count = 0;
        Buf prevBuf = null;
        boolean currentFound = false;
        this.lock.lockRead();
        try {
            long start = this.first.ofs;
            Buf b = this.first;
            while (b != null) {
                if (b.ofs != start) {
                    throw new RuntimeException("Invalid buffer offset: " + b + ", " + b.ofs + " != " + start);
                }
                if (b.end != (start += (long)this.bufSize)) {
                    throw new RuntimeException("Invalid buffer end: " + b + ", " + b.end + " != " + start);
                }
                if (b.prev != prevBuf) {
                    throw new RuntimeException("Invalid prev buffer: #" + count + ", " + b.prev + " != " + prevBuf);
                }
                if (b == this.buf) {
                    currentFound = true;
                }
                prevBuf = b;
                ++count;
                b = b.next;
            }
        }
        finally {
            this.lock.unlockRead();
        }
        if (count != this.bufCount) {
            throw new RuntimeException("Invalid number of buffers: " + count + " != " + this.bufCount);
        }
        if (!currentFound) {
            throw new RuntimeException("Current buffer not found: " + this.buf);
        }
    }

    public String toString() {
        return super.toString() + "[model=" + this.model + "]";
    }

    public final SampleModel getSampleModel() {
        return this.model;
    }

    protected class Worker
    implements Runnable {
        private boolean stop = false;
        private int switchDelta = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean forward = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Realtime worker started: " + (Object)((Object)RealSampleModel.this));
                }
                while (true) {
                    Worker worker = this;
                    synchronized (worker) {
                        if (this.stop) {
                            break;
                        }
                        if (this.switchDelta > 1) {
                            --this.switchDelta;
                            forward = true;
                        } else if (this.switchDelta < -1) {
                            ++this.switchDelta;
                            forward = false;
                        } else {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    RealSampleModel.this.work(forward);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Realtime worker stopped: " + (Object)((Object)RealSampleModel.this));
                }
            }
        }

        public synchronized void stop() {
            this.stop = true;
            this.notifyAll();
        }

        public synchronized void bufferSwitch() {
            ++this.switchDelta;
            this.notifyAll();
        }
    }

    protected static class Buf {
        protected Buf prev;
        protected Buf next;
        protected long ofs;
        protected long end;
        protected boolean loaded;
        protected boolean dirty;
        protected boolean clean;
        protected final SampleBuffer sb;

        public Buf(SampleBuffer sb) {
            this.sb = sb;
        }

        public String toString() {
            return super.toString() + "[ofs=" + this.ofs + ", end=" + this.end + ", loaded=" + this.loaded + ", dirty=" + this.dirty + "]";
        }
    }
}

