/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.SeekableSampleModel;
import java.io.IOException;

public class SeekableAudioModel
extends SeekableSampleModel
implements AudioModel {
    private final double millisPerFrame;
    private String name;
    private double startTime;
    private Resource resource;
    private String[] trackIds;

    public SeekableAudioModel(ByteArraySampleBuffer rsb, SeekableStream sk, long samples) throws IOException {
        super(rsb, sk, samples);
        this.millisPerFrame = 1000.0 / (double)rsb.getFrameRate();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", resource=" + this.resource + "]";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    public long getFrameLength() {
        return this.getSamples() / (long)this.channels;
    }

    public long getUnitLength() {
        return this.getSamples() / (long)this.channels;
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    private double getTimeLength() {
        return this.millisPerFrame * (double)(this.getSamples() / (long)this.channels);
    }

    public long getNanoLength() {
        return (long)Math.ceil(this.getTimeLength() * 1000000.0);
    }

    public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException();
    }

    public int getChunkCount() {
        throw new UnsupportedOperationException();
    }
}

