/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class SeekableSampleModel
extends AbstractSampleModel {
    protected final ByteArraySampleBuffer rsb;
    protected final int ss;
    protected final int ns;
    protected SeekableStream sk;
    protected InputStream is;
    protected long samples;

    public SeekableSampleModel(ByteArraySampleBuffer rsb, SeekableStream sk, long samples) throws IOException {
        super(rsb.getChannels(), rsb.getFrameRate());
        this.rsb = rsb;
        this.ss = rsb.getSampleSize();
        this.ns = rsb.getSamples();
        this.reset(sk, samples);
    }

    public synchronized void reset(SeekableStream sk, long samples) throws IOException {
        if (this.sk != sk) {
            this.sk = sk;
            InputStream old = this.is;
            InputStream inputStream = this.is = sk == null ? null : sk.getInputStream();
            if (old != null && old != this.is) {
                old.close();
            }
        }
        this.samples = samples;
    }

    public boolean isReadOnly() {
        return true;
    }

    public long getSamples() {
        return this.samples;
    }

    public boolean isModelEmpty() {
        return this.samples < 1L;
    }

    public boolean isEmpty() {
        return this.samples < 1L;
    }

    public void get(long i, double[] dst, int off, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        this.sk.seek(i * (long)this.ss);
        while (len > 0) {
            int n = Math.min(len, this.ns);
            int nb = n * this.ss;
            int rb = this.rsb.write(0, this.is, nb);
            if (rb != nb) {
                if (rb < this.ss) {
                    Arrays.fill(dst, off, off + len, 0.0);
                    return;
                }
                n = rb / this.ss;
            }
            this.rsb.get(0, dst, off, n);
            off += n;
            len -= n;
        }
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        this.sk.seek(i * (long)this.ss);
        while (len > 0) {
            int n = Math.min(len, this.ns);
            int nb = n * this.ss;
            int rb = this.rsb.write(0, this.is, nb);
            if (rb != nb) {
                if (rb < this.ss) {
                    Arrays.fill(dst, off, off + len, 0.0f);
                    return;
                }
                n = rb / this.ss;
            }
            this.rsb.get(0, dst, off, n);
            off += n;
            len -= n;
        }
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        long num = this.samples;
        if (i < 0L || i + (long)len > num) {
            throw new IOException("Invalid sample range: i=" + i + ", len=" + len + ", samples=" + num);
        }
        this.sk.seek(i * (long)this.ss);
        while (len > 0) {
            int n = Math.min(len, this.ns);
            int nb = n * this.ss;
            int rb = this.rsb.write(0, this.is, nb);
            if (rb != nb) {
                if (rb < this.ss) {
                    dst.clear(off, len);
                    return;
                }
                n = rb / this.ss;
            }
            dst.set(off, (SampleBuffer)this.rsb, 0, n);
            off += n;
            len -= n;
        }
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float v) throws IOException {
        this.failReadOnly();
    }

    public void set(long i, double v) throws IOException {
        this.failReadOnly();
    }

    public void set(long i, float[] src, int off, int len) throws IOException {
        this.failReadOnly();
    }

    public void set(long i, FloatBuffer src, int len) throws IOException {
        this.failReadOnly();
    }

    public void set(long i, double[] src, int off, int len) throws IOException {
        this.failReadOnly();
    }

    public void set(long i, DoubleBuffer src, int len) throws IOException {
        this.failReadOnly();
    }

    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        this.failReadOnly();
    }

    public void clear(long i, int len) throws IOException {
        this.failReadOnly();
    }

    public void remove(long i, int len) throws IOException {
        this.failReadOnly();
    }

    public void insert(long i, int len) throws IOException {
        this.failReadOnly();
    }

    public long append(int len) throws IOException {
        this.failReadOnly();
        return 0L;
    }

    public long append(double[] src, int off, int len) throws IOException {
        this.failReadOnly();
        return 0L;
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        this.failReadOnly();
        return 0L;
    }

    public long append(float[] src, int off, int len) throws IOException {
        this.failReadOnly();
        return 0L;
    }

    public long append(FloatBuffer src, int len) throws IOException {
        this.failReadOnly();
        return 0L;
    }

    public long append(SampleBuffer src, int off, int len) throws IOException {
        this.failReadOnly();
        return 0L;
    }

    protected void failReadOnly() throws IOException {
        throw new IOException("Read-Only!");
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.reset(null, 0L);
    }
}

