/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl.old;

import com.spacekiller.util.Resource;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.old.MergedSampleModelOLD;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class MergedAudioModelOLD
extends MergedSampleModelOLD
implements AudioModel {
    private final int nc;
    private List models;
    private Part[] parts;
    private boolean valid;
    private String name;
    private Resource resource;
    private String[] trackIds;
    private long samples;
    private double bpm;

    public MergedAudioModelOLD(int channels, float frameRate) {
        super(channels, frameRate);
        this.nc = channels;
        this.models = new ArrayList();
        this.valid = false;
    }

    public String toString() {
        return super.toString() + "[models=" + this.models.size() + "]";
    }

    public long getSamples() {
        return this.samples;
    }

    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long sp, double[] dst, int off, int len) throws IOException {
        if (sp < 0L) {
            throw new IllegalArgumentException("Invalid sample position: " + sp);
        }
        Part[] parts = this.getParts();
        int np = parts.length;
        Part part = null;
        int i = -1;
        int lo = 0;
        int hi = np - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            Part p = parts[i];
            if (p.start > sp) {
                hi = i - 1;
                continue;
            }
            if (p.end <= sp) {
                lo = i + 1;
                continue;
            }
            part = p;
            break;
        }
        int end = off + len;
        while (part != null) {
            int num = (int)Math.min((long)(end - off), part.end - sp);
            if (num > 0) {
                part.get(sp, dst, off, num);
                sp += (long)num;
                if ((off += num) >= end) {
                    return;
                }
            }
            if (++i >= np) break;
            part = parts[i];
        }
        throw new IOException("End of model reached!");
    }

    public void get(long sp, float[] dst, int off, int len) throws IOException {
        if (sp < 0L) {
            throw new IllegalArgumentException("Invalid sample position: " + sp);
        }
        Part[] parts = this.getParts();
        int np = parts.length;
        Part part = null;
        int i = -1;
        int lo = 0;
        int hi = np - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            Part p = parts[i];
            if (p.start > sp) {
                hi = i - 1;
                continue;
            }
            if (p.end <= sp) {
                lo = i + 1;
                continue;
            }
            part = p;
            break;
        }
        int end = off + len;
        while (part != null) {
            int num = (int)Math.min((long)(end - off), part.end - sp);
            if (num > 0) {
                part.get(sp, dst, off, num);
                sp += (long)num;
                if ((off += num) >= end) {
                    return;
                }
            }
            if (++i >= np) break;
            part = parts[i];
        }
        throw new IOException("End of model reached!");
    }

    public void get(long sp, DoubleBuffer dst, int len) throws IOException {
        if (sp < 0L) {
            throw new IllegalArgumentException("Invalid sample position: " + sp);
        }
        Part[] parts = this.getParts();
        int np = parts.length;
        Part part = null;
        int i = -1;
        int lo = 0;
        int hi = np - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            Part p = parts[i];
            if (p.start > sp) {
                hi = i - 1;
                continue;
            }
            if (p.end <= sp) {
                lo = i + 1;
                continue;
            }
            part = p;
            break;
        }
        while (part != null) {
            int num = (int)Math.min((long)len, part.end - sp);
            if (num > 0) {
                part.get(sp, dst, num);
                sp += (long)num;
                if ((len -= num) < 1) {
                    return;
                }
            }
            if (++i >= np) break;
            part = parts[i];
        }
        throw new IOException("End of model reached!");
    }

    public void get(long sp, FloatBuffer dst, int len) throws IOException {
        if (sp < 0L) {
            throw new IllegalArgumentException("Invalid sample position: " + sp);
        }
        Part[] parts = this.getParts();
        int np = parts.length;
        Part part = null;
        int i = -1;
        int lo = 0;
        int hi = np - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            Part p = parts[i];
            if (p.start > sp) {
                hi = i - 1;
                continue;
            }
            if (p.end <= sp) {
                lo = i + 1;
                continue;
            }
            part = p;
            break;
        }
        while (part != null) {
            int num = (int)Math.min((long)len, part.end - sp);
            if (num > 0) {
                part.get(sp, dst, num);
                sp += (long)num;
                if ((len -= num) < 1) {
                    return;
                }
            }
            if (++i >= np) break;
            part = parts[i];
        }
        throw new IOException("End of model reached!");
    }

    public void get(long sp, SampleBuffer dst, int off, int len) throws IOException {
        if (sp < 0L) {
            throw new IllegalArgumentException("Invalid sample position: " + sp);
        }
        Part[] parts = this.getParts();
        int np = parts.length;
        Part part = null;
        int i = -1;
        int lo = 0;
        int hi = np - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            Part p = parts[i];
            if (p.start > sp) {
                hi = i - 1;
                continue;
            }
            if (p.end <= sp) {
                lo = i + 1;
                continue;
            }
            part = p;
            break;
        }
        int end = off + len;
        while (part != null) {
            int num = (int)Math.min((long)(end - off), part.end - sp);
            if (num > 0) {
                part.get(sp, dst, off, num);
                sp += (long)num;
                if ((off += num) >= end) {
                    return;
                }
            }
            if (++i >= np) break;
            part = parts[i];
        }
        throw new IOException("End of model reached!");
    }

    public void getValues(long framePosition, double[] dst, int off, int len) throws IOException {
        this.get(framePosition * (long)this.nc, dst, off, len);
    }

    public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public synchronized int getAudioModelCount() {
        return this.models.size();
    }

    public synchronized AudioModel getAudioModelAt(int index) {
        return (AudioModel)this.models.get(index);
    }

    public synchronized void addAudioModel(AudioModel model) {
        if (model == null) {
            return;
        }
        int modelChannels = model.getChannels();
        if (modelChannels != this.nc) {
            throw new IllegalArgumentException("Invalid number of audio model channels: " + modelChannels + " != " + this.nc);
        }
        float modelRate = model.getFrameRate();
        if (modelRate != this.getFrameRate()) {
            throw new IllegalArgumentException("Invalid audio model frame rate: " + modelRate + " != " + this.getFrameRate());
        }
        this.models.add(model);
        this.valid = false;
        this.adjustFrameLength();
    }

    public synchronized void addAudioModels(AudioModel[] arr) {
        int n = arr.length;
        if (n < 1) {
            return;
        }
        ArrayList<AudioModel> list = new ArrayList<AudioModel>(arr.length);
        for (int i = 0; i < n; ++i) {
            AudioModel model = arr[i];
            int modelChannels = model.getChannels();
            if (modelChannels != this.nc) {
                throw new IllegalArgumentException("Invalid number of audio model channels: " + modelChannels + " != " + this.nc + ", model=" + model);
            }
            float modelRate = model.getFrameRate();
            if (modelRate != this.getFrameRate()) {
                throw new IllegalArgumentException("Invalid audio model frame rate: " + modelRate + " != " + this.getFrameRate() + ", model=" + model);
            }
            list.add(model);
        }
        this.models.addAll(list);
        this.valid = false;
        this.adjustFrameLength();
    }

    public synchronized void removeAudioModel(AudioModel model) {
        int index = this.models.indexOf(model);
        if (index >= 0) {
            this.removeAudioModelAt(index);
        }
    }

    public synchronized void removeAudioModelAt(int index) {
        this.models.remove(index);
        this.valid = false;
        this.adjustFrameLength();
    }

    public synchronized void removeAllAudioModels() {
        if (this.models.isEmpty()) {
            return;
        }
        this.models.clear();
        this.valid = false;
        this.adjustFrameLength();
    }

    protected synchronized void adjustFrameLength() {
        long frames;
        double max = 0.0;
        for (AudioModel model : this.models) {
            double rate = model.getFrameRate();
            double start = 0.0;
            frames = model.getFrameLength();
            double end = start + (double)frames * 1000.0 / rate;
            if (!(end > max)) continue;
            max = end;
        }
        frames = (int)(max * (double)this.getFrameRate() / 1000.0);
        this.samples = frames * (long)this.nc;
    }

    protected synchronized Part[] getParts() throws IOException {
        if (!this.valid) {
            this.validate();
        }
        return this.parts;
    }

    @Override
    public synchronized boolean isValid() {
        return this.valid;
    }

    @Override
    public synchronized void invalidate() {
        this.valid = false;
    }

    @Override
    public synchronized void validate() throws IOException {
        AudioModel[] tma = this.models.toArray(new AudioModel[this.models.size()]);
        Arrays.sort(tma, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                AudioModel a = (AudioModel)arg0;
                AudioModel b = (AudioModel)arg1;
                return -1;
            }
        });
        LinkedList<Part> partList = new LinkedList<Part>();
        long pos = 0L;
        double factor = (double)this.getFrameRate() / 1000.0;
        int n = tma.length;
        for (int i = 0; i < n; ++i) {
            AudioModel m = tma[i];
            long samples = m.getSamples();
            if (samples < 1L) continue;
            long start = 0L;
            long end = start + samples;
            if (i + 1 < n) {
                AudioModel x = tma[i + 1];
                long nextStart = 0L;
                if (nextStart < end) {
                    end = nextStart;
                }
            }
            if (end <= start) continue;
            if (start > pos) {
                partList.add(new FillPart(pos, start));
            }
            partList.add(new ModelPart(start, end, m));
            pos = end;
        }
        partList.add(new FillPart(pos, Long.MAX_VALUE));
        this.parts = partList.toArray(new Part[partList.size()]);
        this.valid = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public boolean isModelEmpty() {
        return this.samples < 1L;
    }

    public boolean isEmpty() {
        return this.samples < 1L;
    }

    public long getFrameLength() {
        return this.samples / (long)this.nc;
    }

    public long getUnitLength() {
        return this.samples / (long)this.nc;
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    public double getTimeLength() {
        return (double)this.getFrameLength() * 1000.0 / (double)this.frameRate;
    }

    public long getNanoLength() {
        return (long)Math.ceil(this.getTimeLength() * 1000000.0);
    }

    public double getBPM() {
        return this.bpm;
    }

    public void setBPM(double bpm) {
        this.bpm = bpm;
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException();
    }

    public int getChunkCount() {
        throw new UnsupportedOperationException();
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    protected static class FillPart
    extends Part {
        public FillPart(long start, long end) {
            super(start, end);
        }

        @Override
        public void get(long i, double[] dst, int off, int len) throws IOException {
            int end = off + len;
            while (off < end) {
                dst[off++] = 0.0;
            }
        }

        @Override
        public void get(long i, float[] dst, int off, int len) throws IOException {
            int end = off + len;
            while (off < end) {
                dst[off++] = 0.0f;
            }
        }

        @Override
        public void get(long i, DoubleBuffer dst, int len) throws IOException {
            while (len-- > 0) {
                dst.put(0.0);
            }
        }

        @Override
        public void get(long i, FloatBuffer dst, int len) throws IOException {
            while (len-- > 0) {
                dst.put(0.0f);
            }
        }

        @Override
        public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
            dst.clear(off, len);
        }
    }

    protected static class ModelPart
    extends Part {
        final AudioModel model;

        public ModelPart(long start, long end, AudioModel model) {
            super(start, end);
            this.model = model;
        }

        @Override
        public void get(long i, double[] dst, int off, int len) throws IOException {
            this.model.get(i - this.start, dst, off, len);
        }

        @Override
        public void get(long i, float[] dst, int off, int len) throws IOException {
            this.model.get(i - this.start, dst, off, len);
        }

        @Override
        public void get(long i, DoubleBuffer dst, int len) throws IOException {
            this.model.get(i - this.start, dst, len);
        }

        @Override
        public void get(long i, FloatBuffer dst, int len) throws IOException {
            this.model.get(i - this.start, dst, len);
        }

        @Override
        public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
            this.model.get(i - this.start, dst, off, len);
        }
    }

    protected static abstract class Part {
        final long start;
        final long end;

        public Part(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public abstract void get(long var1, double[] var3, int var4, int var5) throws IOException;

        public abstract void get(long var1, float[] var3, int var4, int var5) throws IOException;

        public abstract void get(long var1, DoubleBuffer var3, int var4) throws IOException;

        public abstract void get(long var1, FloatBuffer var3, int var4) throws IOException;

        public abstract void get(long var1, SampleBuffer var3, int var4, int var5) throws IOException;
    }
}

