/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl.old;

import com.spacekiller.util.Resource;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.old.MergedSampleModelOLD;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class MergedFaderModelOLD
extends MergedSampleModelOLD
implements FaderModel {
    private static final double LOWEST_VALUE = -1.0E7;
    private float initValue;
    private List models = new ArrayList();
    private Part[] parts;
    private boolean valid = false;
    private String name;
    private Resource resource;
    private String[] trackIds;
    private long samples;

    public MergedFaderModelOLD(float frameRate) {
        super(1, frameRate);
    }

    public String toString() {
        return super.toString() + "[models=" + this.models.size() + "]";
    }

    public float getInitValue() {
        return this.initValue;
    }

    public void setInitValue(float initValue) {
        this.initValue = initValue;
    }

    public void getValues(long framePosition, float[] dst, int off, int len) throws IOException {
        this.getValues(framePosition, 1.0, dst, off, len);
    }

    public void getValues(double framePosition, double framesPerUnit, float[] dst, int off, int len) throws IOException {
        if (framePosition < 0.0) {
            throw new IllegalArgumentException("Invalid frame position: " + framePosition);
        }
        Part[] parts = this.getParts();
        int np = parts.length;
        Part part = null;
        int i = -1;
        int lo = 0;
        int hi = np - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            Part p = parts[i];
            if (p.start > framePosition) {
                hi = i - 1;
                continue;
            }
            if (p.end <= framePosition) {
                lo = i + 1;
                continue;
            }
            part = p;
            break;
        }
        int end = off + len;
        while (part != null) {
            int num = (int)Math.min((double)(end - off), Math.ceil((part.end - framePosition) / framesPerUnit));
            if (num > 0) {
                double pos = (framePosition - part.start) * part.factor;
                double fpu = framesPerUnit * part.factor;
                part.getValues(pos, fpu, dst, off, num);
                if ((off += num) >= end) {
                    return;
                }
                framePosition += (double)num * framesPerUnit;
            }
            if (++i >= np) break;
            part = parts[i];
            if (!(framePosition < part.start)) continue;
            throw new IllegalStateException("Invalid part: pos=" + framePosition + ", part=" + part + ", framesPerUnit=" + framesPerUnit + ", num=" + num);
        }
        throw new IOException("End of model reached: framePosition=" + framePosition + ", framesPerUnit=" + framesPerUnit + ", len=" + len + ", parts=" + np);
    }

    public synchronized int getFaderModelCount() {
        return this.models.size();
    }

    public synchronized FaderModel getFaderModelAt(int index) {
        return (FaderModel)this.models.get(index);
    }

    public synchronized void addFaderModel(FaderModel model) {
        if (model == null) {
            return;
        }
        this.models.add(model);
        this.valid = false;
        this.adjustFrameLength();
    }

    public synchronized void addFaderModels(FaderModel[] arr) {
        int n = arr.length;
        if (n < 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.models.add(arr[i]);
        }
        this.valid = false;
        this.adjustFrameLength();
    }

    public synchronized void removeFaderModel(FaderModel model) {
        int index = this.models.indexOf(model);
        if (index >= 0) {
            this.removeFaderModelAt(index);
        }
    }

    public synchronized void removeFaderModelAt(int index) {
        this.models.remove(index);
        this.valid = false;
        this.adjustFrameLength();
    }

    public synchronized void removeAllFaderModels() {
        if (this.models.isEmpty()) {
            return;
        }
        this.models.clear();
        this.valid = false;
        this.adjustFrameLength();
    }

    protected synchronized void adjustFrameLength() {
        long frames;
        double max = 0.0;
        for (FaderModel model : this.models) {
            double rate = model.getFrameRate();
            double start = 0.0;
            frames = model.getFrameLength();
            double end = start + (double)frames * 1000.0 / rate;
            if (!(end > max)) continue;
            max = end;
        }
        this.samples = frames = (long)((int)(max * (double)this.getFrameRate() / 1000.0));
    }

    protected synchronized Part[] getParts() throws IOException {
        if (!this.valid) {
            this.validate();
        }
        return this.parts;
    }

    @Override
    public synchronized boolean isValid() {
        return this.valid;
    }

    @Override
    public synchronized void invalidate() {
        this.valid = false;
    }

    @Override
    public synchronized void validate() throws IOException {
        double factor;
        FaderModel[] tma = this.models.toArray(new FaderModel[this.models.size()]);
        Arrays.sort(tma, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FaderModel a = (FaderModel)arg0;
                FaderModel b = (FaderModel)arg1;
                return -1;
            }
        });
        LinkedList<Part> partList = new LinkedList<Part>();
        double fact = (double)this.getFrameRate() / 1000.0;
        double pos = -1.0E7;
        float value = this.initValue;
        float[] dst = new float[1];
        int n = tma.length;
        for (int i = 0; i < n; ++i) {
            FaderModel m = tma[i];
            long frames = m.getFrameLength();
            if (frames < 1L) continue;
            double rate = m.getFrameRate();
            factor = rate / 1000.0 / fact;
            double start = 0.0;
            double end = start + (double)frames / factor;
            if (i + 1 < n) {
                FaderModel x = tma[i + 1];
                double nextStart = 0.0;
                if (nextStart < end) {
                    end = nextStart;
                }
            }
            if (end <= start) continue;
            if (start > pos) {
                partList.add(new FillPart(pos, start, factor, value));
            }
            partList.add(new ModelPart(start, end, factor, m));
            pos = end;
            long fl = m.getFrameLength();
            if (fl <= 0L) continue;
            m.get(fl - 1L, dst, 0, 1);
            value = dst[0];
        }
        factor = 1.0;
        partList.add(new FillPart(pos, Double.MAX_VALUE, factor, value));
        this.parts = partList.toArray(new Part[partList.size()]);
        this.valid = true;
    }

    public long getSamples() {
        return this.samples;
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        this.getValues(i, 1.0, dst, off, len);
    }

    public void get(long i, double[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public boolean isModelEmpty() {
        return this.samples < 1L;
    }

    public boolean isEmpty() {
        return this.samples < 1L;
    }

    public long getFrameLength() {
        return this.samples;
    }

    public long getUnitLength() {
        return this.samples;
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    public double getTimeLength() {
        return (double)this.samples * 1000.0 / (double)this.frameRate;
    }

    public long getNanoLength() {
        return (long)Math.ceil(this.getTimeLength() * 1000000.0);
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException();
    }

    public int getChunkCount() {
        throw new UnsupportedOperationException();
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    protected static class FillPart
    extends Part {
        private final float value;

        public FillPart(double start, double end, double factor, float value) {
            super(start, end, factor);
            this.value = value;
        }

        @Override
        public void getValues(double framePosition, double framesPerUnit, float[] dst, int off, int len) throws IOException {
            int end = off + len;
            while (off < end) {
                dst[off++] = this.value;
            }
        }

        public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
            int end = off + len;
            while (off < end) {
                dst[off++] = this.value;
            }
        }
    }

    protected static class ModelPart
    extends Part {
        final FaderModel model;

        public ModelPart(double start, double end, double factor, FaderModel model) {
            super(start, end, factor);
            this.model = model;
        }

        @Override
        public void getValues(double framePosition, double framesPerUnit, float[] dst, int off, int len) throws IOException {
            this.model.getValues(framePosition, framesPerUnit, dst, off, len);
        }
    }

    protected static abstract class Part {
        final double start;
        final double end;
        final double factor;

        public Part(double start, double end, double factor) {
            this.start = start;
            this.end = end;
            this.factor = factor;
        }

        public abstract void getValues(double var1, double var3, float[] var5, int var6, int var7) throws IOException;

        public String toString() {
            return super.toString() + "[start=" + this.start + ", end=" + this.end + ", factor=" + this.factor + "]";
        }
    }
}

