/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.LookAndFeelStyle;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractLookAndFeelStyle
implements LookAndFeelStyle {
    private String name;
    private String tooltip;
    private Icon icon;
    private static final Logger logger = Logger.getLogger(AbstractLookAndFeelStyle.class.getName());

    public static Icon createIcon(Class clazz, String resource) {
        try {
            URL url = clazz.getResource(resource);
            if (url == null) {
                throw new FileNotFoundException(resource);
            }
            return new ImageIcon(url);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Image createImage(Component comp, Class clazz, String resource) throws Exception {
        URL url = clazz.getResource(resource);
        if (url == null) {
            throw new FileNotFoundException(resource);
        }
        Image img = new ImageIcon(url).getImage();
        MediaTracker tracker = new MediaTracker(comp);
        tracker.addImage(img, 0);
        tracker.waitForID(0);
        return img;
    }

    public static TexturePaint createImageTexture(Component comp, Image img) {
        int iw = img.getWidth(comp);
        int ih = img.getHeight(comp);
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.drawImage(img, 0, 0, comp);
        Rectangle r = new Rectangle(0, 0, iw, ih);
        return new TexturePaint(bi, r);
    }

    public static TexturePaint createImageTexture(Component comp, Class clazz, String resource) throws Exception {
        Image img = AbstractLookAndFeelStyle.createImage(comp, clazz, resource);
        return AbstractLookAndFeelStyle.createImageTexture(comp, img);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    protected void setIcon(Icon newIcon) {
        this.icon = newIcon;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    protected void setTooltip(String newTooltip) {
        this.tooltip = newTooltip;
    }
}

