/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class AnimatedComponent
extends JComponent {
    private static final long serialVersionUID = 3237886900126963534L;
    private int repeatCount = 10;
    private Timer timer;
    private int pending = 0;
    private boolean animating = false;
    private int index = 0;
    private int delay = 1000;
    private Component[] animatedComponents;

    public AnimatedComponent() {
        this.setLayout(new GridLayout(1, 1));
    }

    protected void animate() {
        int i;
        int count;
        int index = this.getIndex();
        if (index >= (count = this.getCount()) - 1 && this.pending >= 0) {
            --this.pending;
            if (this.pending < 1) {
                this.stopTimer();
            }
        }
        if ((i = index + 1) >= count) {
            i = 0;
        }
        this.setIndex(i);
        this.refresh();
    }

    protected Timer createTimer() {
        Timer timer = new Timer(this.getDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AnimatedComponent.this.animate();
            }
        });
        return timer;
    }

    public Component[] getAnimatedComponents() {
        return this.animatedComponents;
    }

    public int getCount() {
        return this.animatedComponents == null ? 0 : this.animatedComponents.length;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Dimension getPreferredSize() {
        Component comp = null;
        if (this.animatedComponents != null && this.animatedComponents.length > 0) {
            comp = this.animatedComponents[0];
        }
        return comp == null ? super.getPreferredSize() : comp.getPreferredSize();
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = this.createTimer();
        }
        return this.timer;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    protected void refresh() {
        this.removeAll();
        Component comp = null;
        int i = this.getIndex();
        if (i >= 0 && i < this.getCount()) {
            comp = this.animatedComponents[i];
        }
        if (comp != null) {
            this.add(comp);
        }
        this.validate();
        this.repaint();
    }

    public void setAnimatedComponents(Component[] newAnimatedComponents) {
        this.animatedComponents = newAnimatedComponents;
        this.refresh();
    }

    public void setAnimating(boolean newAnimating) {
        this.animating = newAnimating;
        if (newAnimating) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    public void setDelay(int newDelay) {
        this.delay = newDelay;
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public void setRepeatCount(int newBlinkCount) {
        this.repeatCount = newBlinkCount;
    }

    void setTimer(Timer newBlinkTimer) {
        this.timer = newBlinkTimer;
    }

    protected void startTimer() {
        Timer timer = this.getTimer();
        this.pending = this.getRepeatCount();
        if (timer.isRunning()) {
            return;
        }
        timer.setDelay(this.getDelay());
        timer.setRepeats(true);
        timer.start();
    }

    protected void stopTimer() {
        Timer timer = this.getTimer();
        if (!timer.isRunning()) {
            return;
        }
        timer.stop();
        this.setIndex(0);
        this.refresh();
    }
}

