/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class DisplayModePropertyEditor
extends JPanel
implements PropertyEditor,
ItemSelectable {
    private static final long serialVersionUID = -6947406031352959291L;
    private DisplayMode mode;
    private GraphicsDevice device;
    private boolean refreshing = false;
    private JComboBox jComboBoxResolution = null;
    private JComboBox jComboBoxBitDepth = null;
    private JComboBox jComboBoxRefreshRate = null;
    private EventListenerList itemListeners = new EventListenerList();
    private JLabel jLabelResolution;
    private JLabel jLabelDepth;
    private JLabel jLabelRate;

    public DisplayModePropertyEditor() {
        this.initialize();
        this.refresh();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(0, 0, 0, 5);
        GridBagConstraints gbc_jLabelRate = new GridBagConstraints();
        this.jLabelRate = new JLabel();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        GridBagConstraints gbc_jLabelDepth = new GridBagConstraints();
        this.jLabelDepth = new JLabel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gbc_jLabelResolution = new GridBagConstraints();
        this.jLabelResolution = new JLabel();
        this.setLayout(new GridBagLayout());
        gbc_jLabelResolution.gridx = 0;
        gbc_jLabelResolution.gridy = 0;
        gbc_jLabelResolution.anchor = 17;
        gbc_jLabelResolution.insets = new Insets(0, 0, 2, 5);
        gbc_jLabelResolution.weightx = 1.0;
        this.jLabelResolution.setText("Resolution:");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gbc_jLabelDepth.gridx = 2;
        gbc_jLabelDepth.gridy = 0;
        gbc_jLabelDepth.anchor = 17;
        gbc_jLabelDepth.insets = new Insets(0, 0, 2, 0);
        gbc_jLabelDepth.weightx = 1.0;
        this.jLabelDepth.setText("Depth:");
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        gbc_jLabelRate.gridx = 1;
        gbc_jLabelRate.gridy = 0;
        gbc_jLabelRate.anchor = 17;
        gbc_jLabelRate.insets = new Insets(0, 0, 2, 5);
        gbc_jLabelRate.weightx = 1.0;
        this.jLabelRate.setText("Rate:");
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 1;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.fill = 2;
        this.add((Component)this.jLabelResolution, gbc_jLabelResolution);
        this.add((Component)this.getJComboBoxResolution(), gridBagConstraints2);
        this.add((Component)this.jLabelDepth, gbc_jLabelDepth);
        this.add((Component)this.getJComboBoxBitDepth(), gridBagConstraints6);
        this.add((Component)this.jLabelRate, gbc_jLabelRate);
        this.add((Component)this.getJComboBoxRefreshRate(), gridBagConstraints8);
    }

    public DisplayMode[] getDisplayModes() {
        GraphicsDevice device = this.device;
        if (device == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (env != null) {
                device = env.getDefaultScreenDevice();
            }
            if (device == null) {
                return new DisplayMode[0];
            }
        }
        return device.getDisplayModes();
    }

    public static String formatDisplayMode(DisplayMode m) {
        if (m == null) {
            return "";
        }
        return "" + m.getWidth() + ", " + m.getHeight() + ", " + m.getBitDepth() + ", " + m.getRefreshRate();
    }

    public static DisplayMode parseDisplayMode(GraphicsDevice dev, String m) {
        DisplayMode[] modes;
        int modeWidth = 0;
        int modeHeight = 0;
        int modeDepth = 0;
        int modeRefresh = 0;
        StringTokenizer tok = new StringTokenizer("" + m, ",", false);
        if (tok.hasMoreTokens()) {
            modeWidth = Integer.parseInt(tok.nextToken().trim());
        }
        if (tok.hasMoreTokens()) {
            modeHeight = Integer.parseInt(tok.nextToken().trim());
        }
        if (tok.hasMoreTokens()) {
            modeDepth = Integer.parseInt(tok.nextToken().trim());
        }
        if (tok.hasMoreTokens()) {
            modeRefresh = Integer.parseInt(tok.nextToken().trim());
        }
        DisplayMode[] displayModeArray = modes = dev == null ? null : dev.getDisplayModes();
        if (modes != null) {
            for (int c = 0; c < modes.length; ++c) {
                DisplayMode dm = modes[c];
                if (dm.getWidth() != modeWidth || dm.getHeight() != modeHeight || dm.getBitDepth() != modeDepth || dm.getRefreshRate() != modeRefresh) continue;
                return dm;
            }
        }
        return null;
    }

    @Override
    public String getAsText() {
        return DisplayModePropertyEditor.formatDisplayMode(this.getDisplayMode());
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.getDisplayMode();
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(DisplayModePropertyEditor.parseDisplayMode(this.device, text));
    }

    @Override
    public void setValue(Object value) {
        this.setDisplayMode((DisplayMode)value);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    public DisplayMode getDisplayMode() {
        return this.mode;
    }

    public void setDisplayMode(DisplayMode mode) {
        this.mode = mode;
        this.refresh();
    }

    private JComboBox getJComboBoxResolution() {
        if (this.jComboBoxResolution == null) {
            this.jComboBoxResolution = new JComboBox();
            this.jComboBoxResolution.setToolTipText("Resolution (x,y)");
            this.jComboBoxResolution.setOpaque(false);
            this.jComboBoxResolution.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DisplayModePropertyEditor.this.refreshing) {
                        DisplayModePropertyEditor.this.applyResolution();
                    }
                }
            });
        }
        return this.jComboBoxResolution;
    }

    private JComboBox getJComboBoxBitDepth() {
        if (this.jComboBoxBitDepth == null) {
            this.jComboBoxBitDepth = new JComboBox();
            this.jComboBoxBitDepth.setToolTipText("Bit depth (color)");
            this.jComboBoxBitDepth.setOpaque(false);
            this.jComboBoxBitDepth.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DisplayModePropertyEditor.this.refreshing) {
                        DisplayModePropertyEditor.this.applyBitDepth();
                    }
                }
            });
        }
        return this.jComboBoxBitDepth;
    }

    private JComboBox getJComboBoxRefreshRate() {
        if (this.jComboBoxRefreshRate == null) {
            this.jComboBoxRefreshRate = new JComboBox();
            this.jComboBoxRefreshRate.setToolTipText("Refresh rate (Hz.)");
            this.jComboBoxRefreshRate.setOpaque(false);
            this.jComboBoxRefreshRate.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DisplayModePropertyEditor.this.refreshing) {
                        DisplayModePropertyEditor.this.applyRefreshRate();
                    }
                }
            });
        }
        return this.jComboBoxRefreshRate;
    }

    protected int getSelectedResolutionWidth() {
        Object item = this.getJComboBoxResolution().getSelectedItem();
        if (item == null) {
            return 0;
        }
        String s = "" + item;
        int i = s.indexOf("x");
        if (i < 0) {
            return 0;
        }
        return Integer.parseInt(s.substring(0, i).trim());
    }

    protected int getSelectedResolutionHeight() {
        Object item = this.getJComboBoxResolution().getSelectedItem();
        if (item == null) {
            return 0;
        }
        String s = "" + item;
        int i = s.indexOf("x");
        if (i < 0) {
            return 0;
        }
        return Integer.parseInt(s.substring(i + 1).trim());
    }

    protected int getSelectedBitDepth() {
        Object item = this.getJComboBoxBitDepth().getSelectedItem();
        if (item == null) {
            return 0;
        }
        String s = "" + item;
        return Integer.parseInt(s.trim());
    }

    protected int getSelectedRefreshRate() {
        Object item = this.getJComboBoxRefreshRate().getSelectedItem();
        if (item == null) {
            return 0;
        }
        String s = "" + item;
        return Integer.parseInt(s.trim());
    }

    protected DisplayMode getSelectedDisplayMode() {
        int width = this.getSelectedResolutionWidth();
        int height = this.getSelectedResolutionHeight();
        int bits = this.getSelectedBitDepth();
        int rate = this.getSelectedRefreshRate();
        DisplayMode[] modes = this.getDisplayModes();
        DisplayMode selMode = null;
        for (int c = 0; c < modes.length; ++c) {
            if (modes[c].getWidth() != width || modes[c].getHeight() != height) continue;
            if (selMode == null) {
                selMode = modes[c];
            }
            if (modes[c].getBitDepth() != bits) continue;
            selMode = modes[c];
            if (modes[c].getRefreshRate() != rate) continue;
            return modes[c];
        }
        return selMode;
    }

    protected void refresh() {
        this.refreshResolutions();
        this.refreshBitDepths();
        this.refreshRefreshRates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshResolutions() {
        try {
            this.refreshing = true;
            this.getJComboBoxResolution().removeAllItems();
            DisplayMode selMode = this.getDisplayMode();
            DisplayMode[] modes = this.getDisplayModes();
            HashSet<String> resolutions = new HashSet<String>();
            int selIndex = -1;
            for (int c = 0; c < modes.length; ++c) {
                String s = "" + modes[c].getWidth() + " x " + modes[c].getHeight();
                if (resolutions.contains(s)) continue;
                resolutions.add(s);
                this.getJComboBoxResolution().addItem(s);
                if (selMode == null || modes[c].getWidth() != selMode.getWidth() || modes[c].getHeight() != selMode.getHeight()) continue;
                selIndex = resolutions.size() - 1;
            }
            this.getJComboBoxResolution().setSelectedIndex(selIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshBitDepths() {
        try {
            this.refreshing = true;
            this.getJComboBoxBitDepth().removeAllItems();
            DisplayMode selMode = this.getDisplayMode();
            DisplayMode[] modes = this.getDisplayModes();
            int resWidth = this.getSelectedResolutionWidth();
            int resHeight = this.getSelectedResolutionHeight();
            HashSet<String> depths = new HashSet<String>();
            int selIndex = -1;
            for (int c = 0; c < modes.length; ++c) {
                String s;
                if (modes[c].getWidth() != resWidth || modes[c].getHeight() != resHeight || depths.contains(s = "" + modes[c].getBitDepth())) continue;
                depths.add(s);
                this.getJComboBoxBitDepth().addItem(s);
                if (selMode == null || modes[c].getBitDepth() != selMode.getBitDepth()) continue;
                selIndex = depths.size() - 1;
            }
            this.getJComboBoxBitDepth().setSelectedIndex(selIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshRefreshRates() {
        try {
            this.refreshing = true;
            this.getJComboBoxRefreshRate().removeAllItems();
            DisplayMode selMode = this.getDisplayMode();
            DisplayMode[] modes = this.getDisplayModes();
            int resWidth = this.getSelectedResolutionWidth();
            int resHeight = this.getSelectedResolutionHeight();
            int bits = this.getSelectedBitDepth();
            HashSet<String> rates = new HashSet<String>();
            int selIndex = -1;
            for (int c = 0; c < modes.length; ++c) {
                String s;
                if (modes[c].getWidth() != resWidth || modes[c].getHeight() != resHeight || modes[c].getBitDepth() != bits || rates.contains(s = "" + modes[c].getRefreshRate())) continue;
                rates.add(s);
                this.getJComboBoxRefreshRate().addItem(s);
                if (selMode == null || modes[c].getRefreshRate() != selMode.getRefreshRate()) continue;
                selIndex = rates.size() - 1;
            }
            this.getJComboBoxRefreshRate().setSelectedIndex(selIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.jLabelResolution != null) {
            this.getJLabelResolution().setForeground(fg);
            this.getJLabelDepth().setForeground(fg);
            this.getJLabelRate().setForeground(fg);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.getJComboBoxResolution().setEnabled(enabled);
        this.getJComboBoxBitDepth().setEnabled(enabled);
        this.getJComboBoxRefreshRate().setEnabled(enabled);
    }

    protected void applyResolution() {
        DisplayMode selMode = this.getSelectedDisplayMode();
        if (selMode == null) {
            return;
        }
        this.mode = selMode;
        this.refreshBitDepths();
        this.refreshRefreshRates();
        this.fireItemEvent(new ItemEvent(this, 701, selMode, 1));
    }

    protected void applyBitDepth() {
        DisplayMode selMode = this.getSelectedDisplayMode();
        if (selMode == null) {
            return;
        }
        this.mode = selMode;
        this.refreshRefreshRates();
        this.fireItemEvent(new ItemEvent(this, 701, selMode, 1));
    }

    protected void applyRefreshRate() {
        DisplayMode selMode = this.getSelectedDisplayMode();
        if (selMode == null) {
            return;
        }
        this.mode = selMode;
        this.fireItemEvent(new ItemEvent(this, 701, selMode, 1));
    }

    protected void fireItemEvent(ItemEvent e) {
        Object[] l = this.itemListeners.getListenerList();
        for (int c = 0; c < l.length; c += 2) {
            ((ItemListener)l[c + 1]).itemStateChanged(e);
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListeners.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(ItemListener.class, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        if (this.mode == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.mode;
        }
        return objectArray;
    }

    public GraphicsDevice getDevice() {
        return this.device;
    }

    public void setDevice(GraphicsDevice device) {
        this.device = device;
        this.refresh();
    }

    protected JLabel getJLabelResolution() {
        return this.jLabelResolution;
    }

    protected JLabel getJLabelDepth() {
        return this.jLabelDepth;
    }

    protected JLabel getJLabelRate() {
        return this.jLabelRate;
    }
}

