/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.FadeUtil;
import com.spacekiller.util.swing.Fadeable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class FadeablePanel
extends JPanel
implements Fadeable {
    private static final long serialVersionUID = 4030415198333492385L;
    private float alpha;

    public FadeablePanel() {
        this.setOpaque(false);
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color back = this.getBackground();
        if (back != null && this.alpha > 0.0f) {
            back = FadeUtil.getFadeColor(back, this.alpha);
            g.setColor(back);
            int w = this.getWidth();
            int h = this.getHeight();
            g.fillRect(0, 0, w, h);
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        Component[] comps = this.getComponents();
        ArrayList backup = new ArrayList();
        for (int c = 0; c < comps.length; ++c) {
            Component comp = comps[c];
            this.fadeComponent(comp, backup);
        }
        super.paintChildren(g);
        Iterator i = backup.iterator();
        while (i.hasNext()) {
            ((Backup)i.next()).restore();
        }
    }

    protected void fadeComponent(Component comp, List backup) {
        Container cont;
        Component[] comps;
        if (comp instanceof Fadeable) {
            Fadeable fade = (Fadeable)((Object)comp);
            fade.setAlpha(this.alpha);
        } else {
            Color back = comp.getBackground();
            Color fore = comp.getForeground();
            backup.add(new Backup(comp, back, fore));
            back = FadeUtil.getFadeColor(back, this.alpha);
            fore = FadeUtil.getFadeColor(fore, this.alpha);
            comp.setBackground(back);
            comp.setForeground(fore);
        }
        if (comp instanceof Container && (comps = (cont = (Container)comp).getComponents()) != null) {
            for (int c = 0; c < comps.length; ++c) {
                this.fadeComponent(comps[c], backup);
            }
        }
    }

    protected class Backup {
        public Component component;
        public Color background;
        public Color foreground;

        public Backup() {
        }

        public Backup(Component component, Color background, Color foreground) {
            this.component = component;
            this.background = background;
            this.foreground = foreground;
        }

        public void restore() {
            this.component.setBackground(this.background);
            this.component.setForeground(this.foreground);
        }
    }
}

