/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class FullscreenSupport {
    private static final Logger logger = Logger.getLogger(FullscreenSupport.class.getName());
    private static final int MAGIC_DELAY = 1000;
    private WindowHandler windowHandler;
    private ComponentHandler componentHandler;
    private Frame frame;
    private boolean undecorated = true;
    private boolean wasUndecorated;
    private boolean fullscreenEnabled = true;
    private EnterFullscreen enterFullscreen = new EnterFullscreen();
    private boolean exclusiveMode = false;
    private GraphicsDevice displayDevice;
    private DisplayMode displayMode;
    private boolean exclusiveFullscreen = false;
    private boolean pseudoFullscreen = false;
    private Rectangle pseudoWindowBounds;

    public FullscreenSupport() {
    }

    public FullscreenSupport(Frame frame) {
        this();
        this.setFrame(frame);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public synchronized void setFrame(Frame frame) {
        Frame old = this.frame;
        if (frame == old) {
            return;
        }
        if (old != null) {
            if (this.windowHandler != null) {
                old.removeWindowListener(this.windowHandler);
            }
            if (this.componentHandler != null) {
                old.removeComponentListener(this.componentHandler);
            }
        }
        this.frame = frame;
        if (frame != null) {
            if (this.windowHandler == null) {
                this.windowHandler = new WindowHandler();
            }
            frame.addWindowListener(this.windowHandler);
            if (this.componentHandler == null) {
                this.componentHandler = new ComponentHandler();
            }
            frame.addComponentListener(this.componentHandler);
        }
    }

    public GraphicsDevice getDisplayDevice() {
        return this.displayDevice;
    }

    public synchronized void setDisplayDevice(GraphicsDevice displayDevice) {
        this.displayDevice = displayDevice;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public synchronized void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public boolean isFullscreenEnabled() {
        return this.fullscreenEnabled;
    }

    public synchronized void setFullscreenEnabled(boolean fullscreenEnabled) {
        this.fullscreenEnabled = fullscreenEnabled;
        if (!fullscreenEnabled) {
            this.setWindowFullscreen(false);
        }
    }

    public boolean isWindowMaximized() {
        Frame f = this.frame;
        return f != null && (f.getExtendedState() & 6) == 6;
    }

    public void setWindowMaximized(boolean windowMaximized) {
        Frame f = this.frame;
        if (f == null) {
            return;
        }
        if (windowMaximized) {
            if (!this.isWindowMaximized()) {
                f.setExtendedState(6);
            }
        } else if (this.isWindowMaximized() && !this.isWindowFullscreen()) {
            f.setExtendedState(0);
        }
    }

    public boolean isExclusiveMode() {
        return this.exclusiveMode;
    }

    public void setExclusiveMode(boolean exclusiveMode) {
        this.exclusiveMode = exclusiveMode;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
    }

    public boolean isExclusiveFullscreen() {
        return this.exclusiveFullscreen;
    }

    public boolean isPseudoFullscreen() {
        return this.pseudoFullscreen;
    }

    public boolean isWindowFullscreen() {
        Frame f = this.frame;
        if (f != null) {
            GraphicsDevice dev;
            GraphicsConfiguration gc;
            if (this.isPseudoFullscreen() && f.isUndecorated()) {
                return true;
            }
            if (this.isExclusiveFullscreen() && (gc = f.getGraphicsConfiguration()) != null && (dev = gc.getDevice()) != null && dev.isFullScreenSupported()) {
                return dev.getFullScreenWindow() == f;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setWindowFullscreen(boolean windowFullscreen) {
        Frame f = this.frame;
        if (f == null) {
            return false;
        }
        if (windowFullscreen) {
            if (!this.isFullscreenEnabled()) {
                return false;
            }
            if (this.exclusiveMode && !this.pseudoFullscreen) {
                GraphicsDevice dev = this.getDisplayDevice();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("setWindowFullscreen: exclusiveMode=" + this.exclusiveMode + ", device=" + dev);
                }
                if (dev != null && dev.isFullScreenSupported()) {
                    try {
                        return this.enterExclusiveFullscreen();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            FullscreenSupport fullscreenSupport = this;
            synchronized (fullscreenSupport) {
                return this.enterPseudoFullscreen();
            }
        }
        if (this.exclusiveFullscreen) {
            return this.exitExclusiveFullscreen();
        }
        if (this.pseudoFullscreen) {
            FullscreenSupport fullscreenSupport = this;
            synchronized (fullscreenSupport) {
                return this.exitPseudoFullscreen();
            }
        }
        return false;
    }

    protected boolean enterPseudoFullscreen() {
        Rectangle fullBounds;
        Frame f = this.frame;
        if (f == null) {
            return false;
        }
        GraphicsConfiguration gc = f.getGraphicsConfiguration();
        if (gc == null) {
            return false;
        }
        GraphicsDevice dev = gc.getDevice();
        if (dev == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("enterPseudoFullscreen: device=" + dev);
        }
        this.wasUndecorated = f.isUndecorated();
        GraphicsConfiguration defaultConfig = dev.getDefaultConfiguration();
        Rectangle rectangle = fullBounds = defaultConfig == null ? null : defaultConfig.getBounds();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("setting fullscreen-bounds: " + fullBounds);
        }
        if (fullBounds == null) {
            return false;
        }
        this.pseudoWindowBounds = f.getBounds();
        f.dispose();
        f.setUndecorated(this.undecorated);
        f.setBounds(fullBounds);
        f.validate();
        f.setVisible(true);
        this.pseudoFullscreen = true;
        this.exclusiveFullscreen = false;
        this.handleFullscreenChanged(true);
        return true;
    }

    protected boolean exitPseudoFullscreen() {
        Frame f = this.frame;
        if (f == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("exitPseudoFullscreen: frame=" + f);
        }
        this.pseudoFullscreen = false;
        f.dispose();
        f.setUndecorated(this.wasUndecorated);
        Rectangle bounds = this.pseudoWindowBounds;
        if (bounds != null) {
            f.setBounds(bounds);
        }
        f.validate();
        f.setVisible(true);
        this.handleFullscreenChanged(false);
        return true;
    }

    protected boolean enterExclusiveFullscreen() {
        Frame f = this.frame;
        if (f == null) {
            return false;
        }
        GraphicsDevice dev = this.getDisplayDevice();
        if (dev == null) {
            GraphicsConfiguration gc = f.getGraphicsConfiguration();
            if (gc == null) {
                return false;
            }
            dev = gc.getDevice();
            if (dev == null) {
                return false;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("enterExclusiveFullscreen: device=" + dev);
        }
        this.wasUndecorated = f.isUndecorated();
        f.dispose();
        f.setUndecorated(this.undecorated);
        dev.setFullScreenWindow(f);
        DisplayMode dm = this.displayMode;
        if (dm != null) {
            GraphicsConfiguration gconf;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setting display-mode: " + dm.getWidth() + "x" + dm.getHeight() + "#" + dm.getBitDepth() + "@" + dm.getRefreshRate() + " -> " + dm);
            }
            dev.setDisplayMode(dm);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("GCONF2=" + f.getGraphicsConfiguration());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("GCONF3=" + f.getGraphicsConfiguration());
            }
            if ((gconf = f.getGraphicsConfiguration()) != null) {
                f.setBounds(gconf.getBounds());
            }
        }
        f.setVisible(true);
        this.exclusiveFullscreen = true;
        this.pseudoFullscreen = false;
        this.handleFullscreenChanged(true);
        return true;
    }

    protected boolean exitExclusiveFullscreen() {
        Frame f = this.frame;
        if (f == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("exitExclusiveFullscreen: frame=" + f);
        }
        this.exclusiveFullscreen = false;
        GraphicsDevice dev = f.getGraphicsConfiguration().getDevice();
        if (dev != null && dev.getFullScreenWindow() == f) {
            dev.setFullScreenWindow(null);
            f.dispose();
            f.setUndecorated(this.wasUndecorated);
            this.handleFullscreenChanged(false);
        }
        return true;
    }

    protected void handleFullscreenChanged(boolean fullscreen) {
    }

    protected class EnterFullscreen
    implements Runnable {
        protected EnterFullscreen() {
        }

        @Override
        public void run() {
            FullscreenSupport.this.frame.setExtendedState(0);
            FullscreenSupport.this.setWindowFullscreen(true);
        }
    }

    protected class ComponentHandler
    extends ComponentAdapter {
        protected ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component comp = e.getComponent();
            if (comp == FullscreenSupport.this.frame && FullscreenSupport.this.isWindowMaximized() && FullscreenSupport.this.isFullscreenEnabled() && !FullscreenSupport.this.isWindowFullscreen()) {
                SwingUtilities.invokeLater(FullscreenSupport.this.enterFullscreen);
            }
        }
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            super.windowIconified(e);
            FullscreenSupport.this.setWindowFullscreen(false);
        }
    }
}

