/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import javax.swing.JScrollBar;

public class LongJScrollBar
extends JScrollBar {
    private static final long serialVersionUID = -89164334433858103L;
    private long longValue;
    private long longExtent;
    private long longMinimum;
    private long longMaximum;
    private long longUnit;
    private long longBlock;
    private long factor = 1L;

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long value) {
        if (value == this.longValue) {
            return;
        }
        if (value + this.longExtent > this.longMaximum) {
            value = this.longMaximum - this.longExtent;
        }
        if (value < this.longMinimum) {
            value = this.longMinimum;
        }
        if (value == this.longValue) {
            return;
        }
        this.longValue = value;
        int intValue = this.castInt((long)this.model.getMinimum() + (value - this.longMinimum) / this.factor);
        if (intValue != this.model.getValue()) {
            super.setValue(intValue);
        } else {
            int id = 601;
            int type = 5;
            super.fireAdjustmentValueChanged(id, type, intValue);
        }
    }

    public long getLongExtent() {
        return this.longExtent;
    }

    public void setLongExtent(long extent) {
        if (extent == this.longExtent) {
            return;
        }
        this.setLongVals(this.longValue, extent, this.longMinimum, this.longMaximum);
    }

    public long getLongMinimum() {
        return this.longMinimum;
    }

    public void setLongMinimum(long minimum) {
        if (minimum == this.longMinimum) {
            return;
        }
        if (this.longMaximum < minimum) {
            this.setLongVals(this.longValue, this.longExtent, minimum, minimum);
        } else {
            this.setLongVals(this.longValue, this.longExtent, minimum, this.longMaximum);
        }
    }

    public long getLongMaximum() {
        return this.longMaximum;
    }

    public void setLongMaximum(long maximum) {
        if (maximum == this.longMaximum) {
            return;
        }
        if (maximum < this.longMinimum) {
            this.setLongVals(this.longValue, this.longExtent, maximum, maximum);
        } else {
            this.setLongVals(this.longValue, this.longExtent, this.longMinimum, maximum);
        }
    }

    public void setLongValues(long newValue, long newExtent, long newMin, long newMax) {
        if (newMax < newMin) {
            newMax = newMin;
        }
        if (newExtent < 0L) {
            newExtent = 0L;
        }
        this.setLongVals(newValue, newExtent, newMin, newMax);
    }

    protected void setLongVals(long newValue, long newExtent, long newMin, long newMax) {
        if (newValue > newMax - newExtent) {
            newValue = newMax - newExtent;
        }
        if (newValue < newMin) {
            newValue = newMin;
        }
        if (newValue == this.longValue && newExtent == this.longExtent && newMin == this.longMinimum && newMax == this.longMaximum) {
            return;
        }
        this.longValue = newValue;
        this.longExtent = newExtent;
        this.longMinimum = newMin;
        this.longMaximum = newMax;
        long range = newMax - newMin;
        long fact = range > Integer.MAX_VALUE ? 1L + range / Integer.MAX_VALUE : (range < 0L ? 1L + (newMax / 2L - newMin / 2L) / Integer.MAX_VALUE * 2L : 1L);
        if (fact != this.factor) {
            this.factor = fact;
        }
        int intVal = (int)(newValue / fact);
        int intExt = (int)(newExtent / fact);
        int intMin = (int)(newMin / fact);
        int intMax = (int)(newMax / fact);
        if (intVal != this.model.getValue() || intExt != this.model.getExtent() || intMin != this.model.getMinimum() || intMax != this.model.getMaximum()) {
            super.setValues(intVal, intExt, intMin, intMax);
        } else {
            int id = 601;
            int type = 5;
            this.fireAdjustmentValueChanged(id, type, intVal);
        }
    }

    public long getLongUnit() {
        return this.longUnit;
    }

    public void setLongUnit(long unit) {
        if (unit == this.longUnit) {
            return;
        }
        this.longUnit = unit;
        int intUnit = (int)(unit / this.factor);
        super.setUnitIncrement(intUnit);
    }

    public long getLongBlock() {
        return this.longBlock;
    }

    public void setLongBlock(long block) {
        if (block == this.longBlock) {
            return;
        }
        this.longBlock = block;
        int intBlock = (int)(block / this.factor);
        super.setBlockIncrement(intBlock);
    }

    private int castInt(long val) {
        if (val > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (val < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)val;
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int value) {
        long v = this.longMinimum + (long)(value - this.model.getMinimum()) * this.factor;
        if (v + this.longExtent > this.longMaximum) {
            v = this.longMaximum - this.longExtent;
        }
        if (v < this.longMinimum) {
            v = this.longMinimum;
        }
        this.longValue = v;
        super.setValue(value);
    }

    @Override
    public int getVisibleAmount() {
        return super.getVisibleAmount();
    }

    @Override
    public void setVisibleAmount(int extent) {
        super.setVisibleAmount(extent);
    }

    @Override
    public int getMinimum() {
        return super.getMinimum();
    }

    @Override
    public void setMinimum(int minimum) {
        super.setMinimum(minimum);
    }

    @Override
    public int getMaximum() {
        return super.getMaximum();
    }

    @Override
    public void setMaximum(int maximum) {
        super.setMaximum(maximum);
    }

    @Override
    public void setValues(int newValue, int newExtent, int newMin, int newMax) {
        super.setValues(newValue, newExtent, newMin, newMax);
    }

    @Override
    public int getUnitIncrement() {
        return super.getUnitIncrement();
    }

    @Override
    public int getUnitIncrement(int direction) {
        return super.getUnitIncrement(direction);
    }

    @Override
    public void setUnitIncrement(int unitIncrement) {
        super.setUnitIncrement(unitIncrement);
    }

    @Override
    public int getBlockIncrement() {
        return super.getBlockIncrement();
    }

    @Override
    public int getBlockIncrement(int direction) {
        return super.getBlockIncrement(direction);
    }

    @Override
    public void setBlockIncrement(int blockIncrement) {
        super.setBlockIncrement(blockIncrement);
    }
}

