/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.LookAndFeelManager;
import com.spacekiller.util.swing.LookAndFeelStyle;
import com.spacekiller.util.swing.LookAndFeelType;
import com.spacekiller.util.swing.LookAndFeelWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LookAndFeelChooser
extends JPanel {
    private static final long serialVersionUID = 3095750458908670075L;
    private JLabel ivjJLabel = null;
    private JLabel ivjJLabel1 = null;
    private JPanel ivjJPanelPreview = null;
    private JPanel ivjJPanel1 = null;
    private LookAndFeel lookAndFeel;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JComboBox ivjJComboBoxStyle = null;
    private JComboBox ivjJComboBoxType = null;
    private Component previewComponent;
    private Method paintComponentMethod;
    private Class previewComponentClass;
    private static final Logger logger = Logger.getLogger(LookAndFeelChooser.class.getName());

    public LookAndFeelChooser() {
        this.initialize();
    }

    private void connEtoC1() {
        try {
            this.lookAndFeelChooser_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.jComboBoxType_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ItemEvent arg1) {
        try {
            this.jComboBoxStyle_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected JInternalFrame createPreviewFrame() {
        JInternalFrame preview = new JInternalFrame();
        preview.setTitle("Preview");
        preview.setOpaque(true);
        preview.setClosable(false);
        preview.setIconifiable(true);
        preview.setMaximizable(true);
        preview.setResizable(true);
        preview.setBounds(0, 0, 200, 200);
        try {
            preview.setMaximum(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return preview;
    }

    private JComboBox getJComboBoxStyle() {
        if (this.ivjJComboBoxStyle == null) {
            try {
                this.ivjJComboBoxStyle = new JComboBox();
                this.ivjJComboBoxStyle.setName("JComboBoxStyle");
                this.ivjJComboBoxStyle.setOpaque(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJComboBoxStyle;
    }

    private JComboBox getJComboBoxType() {
        if (this.ivjJComboBoxType == null) {
            try {
                this.ivjJComboBoxType = new JComboBox();
                this.ivjJComboBoxType.setName("JComboBoxType");
                this.ivjJComboBoxType.setOpaque(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJComboBoxType;
    }

    private JLabel getJLabel() {
        if (this.ivjJLabel == null) {
            try {
                this.ivjJLabel = new JLabel();
                this.ivjJLabel.setName("JLabel");
                this.ivjJLabel.setText("Style:");
                this.ivjJLabel.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Type:");
                this.ivjJLabel1.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setOpaque(false);
                this.ivjJPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Look & Feel", 0, 0, null, null));
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
                constraintsJLabel1.gridx = 0;
                constraintsJLabel1.gridy = 0;
                constraintsJLabel1.anchor = 17;
                constraintsJLabel1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel1(), constraintsJLabel1);
                GridBagConstraints constraintsJLabel = new GridBagConstraints();
                constraintsJLabel.gridx = 0;
                constraintsJLabel.gridy = 1;
                constraintsJLabel.anchor = 17;
                constraintsJLabel.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel(), constraintsJLabel);
                GridBagConstraints constraintsJComboBoxType = new GridBagConstraints();
                constraintsJComboBoxType.gridx = 1;
                constraintsJComboBoxType.gridy = 0;
                constraintsJComboBoxType.fill = 2;
                constraintsJComboBoxType.weightx = 1.0;
                constraintsJComboBoxType.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJComboBoxType(), constraintsJComboBoxType);
                GridBagConstraints constraintsJComboBoxStyle = new GridBagConstraints();
                constraintsJComboBoxStyle.gridx = 1;
                constraintsJComboBoxStyle.gridy = 1;
                constraintsJComboBoxStyle.fill = 2;
                constraintsJComboBoxStyle.weightx = 1.0;
                constraintsJComboBoxStyle.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJComboBoxStyle(), constraintsJComboBoxStyle);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanelPreview() {
        if (this.ivjJPanelPreview == null) {
            try {
                this.ivjJPanelPreview = new JPanel();
                this.ivjJPanelPreview.setName("JPanelPreview");
                this.ivjJPanelPreview.setOpaque(false);
                this.ivjJPanelPreview.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Preview", 0, 0, null, null));
                this.ivjJPanelPreview.setLayout(new GridLayout());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelPreview;
    }

    public LookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public Component getPreviewComponent() {
        return this.previewComponent;
    }

    public Class getPreviewComponentClass() {
        return this.previewComponentClass;
    }

    private void handleException(Throwable exception) {
        logger.fine("--------- UNCAUGHT EXCEPTION ---------");
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void initConnections() throws Exception {
        this.getJComboBoxType().addItemListener(this.ivjEventHandler);
        this.getJComboBoxStyle().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("LookAndFeelChooser");
            this.setLayout(new GridBagLayout());
            this.setSize(486, 331);
            GridBagConstraints constraintsJPanelPreview = new GridBagConstraints();
            constraintsJPanelPreview.gridx = 0;
            constraintsJPanelPreview.gridy = 1;
            constraintsJPanelPreview.fill = 1;
            constraintsJPanelPreview.weightx = 1.0;
            constraintsJPanelPreview.weighty = 1.0;
            constraintsJPanelPreview.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getJPanelPreview(), constraintsJPanelPreview);
            GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
            constraintsJPanel1.gridx = 0;
            constraintsJPanel1.gridy = 0;
            constraintsJPanel1.fill = 1;
            constraintsJPanel1.weightx = 1.0;
            constraintsJPanel1.insets = new Insets(4, 4, 0, 4);
            this.add((Component)this.getJPanel1(), constraintsJPanel1);
            this.initConnections();
            this.connEtoC1();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void jComboBoxStyle_ItemStateChanged() {
        try {
            LookAndFeelType[] types = LookAndFeelManager.getInstance().getLookAndFeelTypes();
            int sel = this.getJComboBoxType().getSelectedIndex();
            if (sel >= 0) {
                LookAndFeel laf;
                LookAndFeelType type = types[sel];
                LookAndFeelStyle style = null;
                sel = this.getJComboBoxStyle().getSelectedIndex();
                if (sel >= 0) {
                    style = type.getStyleAt(sel);
                }
                if (style != null && (laf = type.getLookAndFeel(style)) != null) {
                    logger.fine("Style: " + style.getName());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LookAndFeelChooser.this.setLookAndFeel(laf);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void jComboBoxType_ItemStateChanged() {
        this.refreshStyles();
        this.jComboBoxStyle_ItemStateChanged();
    }

    private void lookAndFeelChooser_Initialize() {
        this.refreshLookAndFeels();
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            LookAndFeelChooser aLookAndFeelChooser = new LookAndFeelChooser();
            frame.setContentPane(aLookAndFeelChooser);
            frame.setSize(aLookAndFeelChooser.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void refreshLookAndFeels() {
        LookAndFeelType[] types = LookAndFeelManager.getInstance().getLookAndFeelTypes();
        if (this.getJComboBoxType().getItemCount() > 0) {
            this.getJComboBoxType().removeAllItems();
        }
        if (types != null) {
            for (int c = 0; c < types.length; ++c) {
                this.getJComboBoxType().addItem(types[c].getName());
            }
        }
    }

    public void refreshPreview() {
        final LookAndFeel previewLAF2 = this.getLookAndFeel();
        if (previewLAF2 == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LookAndFeel currentLAF = UIManager.getLookAndFeel();
                try {
                    logger.fine("LookAndFeel: " + previewLAF2);
                    ClassLoader loader = previewLAF2.getClass().getClassLoader();
                    logger.fine("ClassLoader: " + loader);
                    LookAndFeel previewLAF = previewLAF2;
                    if (loader != null && loader != ClassLoader.getSystemClassLoader()) {
                        previewLAF = new LookAndFeelWrapper(previewLAF2, loader);
                        UIDefaults def = previewLAF.getDefaults();
                        def.put("ClassLoader", loader);
                        logger.info("ClassLoader2: " + previewLAF.getDefaults().get("ClassLoader"));
                        logger.info("ClassLoader3: " + def.get("ClassLoader"));
                    }
                    int width = 380;
                    int height = 250;
                    BufferedImage image = new BufferedImage(width, height, 1);
                    Graphics ig = image.getGraphics();
                    logger.fine("Buffered-Graphics: " + System.identityHashCode(ig));
                    try {
                        UIManager.setLookAndFeel(previewLAF);
                        PreviewPane pan = new PreviewPane(ig);
                        pan.setDoubleBuffered(false);
                        pan.setBounds(0, 0, width, height);
                        pan.setLayout(new GridLayout(2, 2));
                        JLabel lab = new JLabel("Label");
                        lab.setBounds(20, 20, 100, 20);
                        lab.setVerticalTextPosition(1);
                        pan.add(lab);
                        JCheckBox check = new JCheckBox("Checkbox");
                        check.setSelected(true);
                        check.setOpaque(false);
                        check.setBounds(20, 50, 100, 20);
                        pan.add(check);
                        JButton but = new JButton("Button");
                        but.setOpaque(false);
                        but.setBounds(20, 80, 100, 25);
                        pan.add(but);
                        JTree tree = new JTree();
                        tree.setOpaque(false);
                        tree.setBounds(20, 120, 100, 100);
                        pan.add(tree);
                        JScrollPane scroll1 = new JScrollPane();
                        scroll1.setBounds(150, 20, 150, 100);
                        scroll1.setHorizontalScrollBarPolicy(32);
                        scroll1.setVerticalScrollBarPolicy(22);
                        pan.add(scroll1);
                        JList list1 = new JList();
                        DefaultListModel<String> listModel1 = new DefaultListModel<String>();
                        listModel1.addElement("red");
                        listModel1.addElement("green");
                        listModel1.addElement("blue");
                        list1.setModel(listModel1);
                        list1.setBounds(152, 22, 150, 100);
                        list1.setOpaque(false);
                        pan.add(list1);
                        JInternalFrame intFrame = new JInternalFrame("View");
                        intFrame.setVisible(true);
                        intFrame.setBounds(150, 140, 150, 100);
                        intFrame.setOpaque(false);
                        pan.add(intFrame);
                        pan.validate();
                        JPanel dummy = new JPanel();
                        dummy.setDoubleBuffered(false);
                        dummy.updateUI();
                        SwingUtilities.paintComponent(ig, pan, dummy, pan.getBounds());
                    }
                    finally {
                        JLabel label = new JLabel();
                        label.setIcon(new ImageIcon(image));
                        LookAndFeelChooser.this.setPreviewComponent(label);
                        ig.dispose();
                    }
                }
                catch (Throwable e) {
                    logger.fine("Error setting look and feel: " + previewLAF2);
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                finally {
                    try {
                        UIManager.setLookAndFeel(currentLAF);
                    }
                    catch (Exception e) {
                        logger.fine("Error restoring look and feel: " + currentLAF);
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        });
    }

    public void refreshStyles() {
        LookAndFeelType type;
        if (this.getJComboBoxStyle().getItemCount() > 0) {
            this.getJComboBoxStyle().removeAllItems();
        }
        LookAndFeelType[] types = LookAndFeelManager.getInstance().getLookAndFeelTypes();
        int i = this.getJComboBoxType().getSelectedIndex();
        LookAndFeelType lookAndFeelType = type = i < 0 ? null : types[i];
        if (type != null) {
            int styleCount = type.getStyleCount();
            for (int c = 0; c < styleCount; ++c) {
                this.getJComboBoxStyle().addItem(type.getStyleAt(c).getName());
            }
            if (styleCount > 0) {
                this.getJComboBoxStyle().setSelectedIndex(styleCount - 1);
            }
        }
    }

    public synchronized void setLookAndFeel(LookAndFeel newLookAndFeel) {
        this.lookAndFeel = newLookAndFeel;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LookAndFeelChooser.this.refreshPreview();
            }
        });
        thread.setContextClassLoader(newLookAndFeel.getClass().getClassLoader());
        thread.start();
    }

    public synchronized void setPreviewComponent(Component newPreviewComponent) {
        this.previewComponent = newPreviewComponent;
        this.getJPanelPreview().removeAll();
        this.getJPanelPreview().add(newPreviewComponent);
        this.getJPanelPreview().validate();
        this.getJPanelPreview().repaint();
    }

    public void setPreviewComponentClass(Class newPreviewComponentClass) {
        this.previewComponentClass = newPreviewComponentClass;
    }

    protected void setDoubleBuffered(Component comp, boolean doubleBuffered) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setDoubleBuffered(doubleBuffered);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] comps = cont.getComponents();
            for (int c = 0; c < comps.length; ++c) {
                this.setDoubleBuffered(comps[c], doubleBuffered);
            }
        }
    }

    protected void paintComponent(JComponent comp, Graphics g) throws Exception {
        if (this.paintComponentMethod == null) {
            this.paintComponentMethod = JComponent.class.getDeclaredMethod("paintComponent", Graphics.class);
            this.paintComponentMethod.setAccessible(true);
        }
        comp.paint(g);
        Component[] children = comp.getComponents();
        for (int c = 0; c < children.length; ++c) {
            try {
                if (!(children[c] instanceof JComponent)) continue;
                JComponent jc = (JComponent)children[c];
                int x = jc.getX();
                int y = jc.getY();
                g.translate(x, y);
                this.paintComponent(jc, g);
                g.translate(-x, -y);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public LookAndFeelType getSelectedLookAndFeelType() {
        int index = this.getJComboBoxType().getSelectedIndex();
        if (index < 0) {
            return null;
        }
        LookAndFeelType[] types = LookAndFeelManager.getInstance().getLookAndFeelTypes();
        return types[index];
    }

    public LookAndFeelStyle getSelectedLookAndFeelStyle() {
        LookAndFeelType type = this.getSelectedLookAndFeelType();
        if (type == null) {
            return null;
        }
        int index = this.getJComboBoxStyle().getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return type.getStyleAt(index);
    }

    public void setSelectedLookAndFeel(LookAndFeelType lafType, LookAndFeelStyle lafStyle) {
        if (lafType == null) {
            return;
        }
        String typeName = lafType.getName();
        this.getJComboBoxType().setSelectedItem(typeName);
        if (lafStyle != null) {
            String styleName = lafStyle.getName();
            this.getJComboBoxStyle().setSelectedItem(styleName);
        }
    }

    class IvjEventHandler
    implements ItemListener {
        IvjEventHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == LookAndFeelChooser.this.getJComboBoxType()) {
                LookAndFeelChooser.this.connEtoC2(e);
            }
            if (e.getSource() == LookAndFeelChooser.this.getJComboBoxStyle()) {
                LookAndFeelChooser.this.connEtoC3(e);
            }
        }
    }

    public static class PreviewPane
    extends JPanel {
        private static final long serialVersionUID = 735087335560908841L;
        private Graphics graphics;

        public PreviewPane(Graphics graphics) {
            this.setDoubleBuffered(false);
            this.graphics = graphics;
        }

        @Override
        public Graphics getGraphics() {
            return this.graphics;
        }

        @Override
        public void paint(Graphics g) {
            this.paintComponent(g);
            Component[] comps = this.getComponents();
            for (int c = 0; c < comps.length; ++c) {
                Rectangle r = comps[c].getBounds();
                g.translate(r.x, r.y);
                comps[c].paint(g);
                g.translate(-r.x, -r.y);
            }
        }
    }
}

