/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.Tools;
import com.spacekiller.util.swing.LookAndFeelChooser;
import com.spacekiller.util.swing.LookAndFeelManager;
import com.spacekiller.util.swing.SwingTestPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;

public class LookAndFeelDialog
extends JDialog {
    private static final long serialVersionUID = 3893457439411679904L;
    private static LookAndFeelDialog instance;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjJButton = null;
    private JButton ivjJButton1 = null;
    private JButton ivjJButton2 = null;
    private JPanel ivjJDialogContentPane = null;
    private JPanel ivjJPanel1 = null;
    private LookAndFeelChooser ivjLookAndFeelChooser1 = null;
    private JPanel ivjJPanel2 = null;
    private static final Logger logger;

    public LookAndFeelDialog() {
        this.initialize();
    }

    public LookAndFeelDialog(Dialog owner) {
        super(owner);
        this.initialize();
    }

    public LookAndFeelDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void action_Apply() throws Exception {
        LookAndFeel laf = this.getLookAndFeelChooser1().getLookAndFeel();
        logger.fine("Applying LookAndFeel: " + laf);
        LookAndFeelManager.getInstance().setLookAndFeel(laf);
    }

    private void action_Cancel() {
        this.dispose();
    }

    private void action_Okay() throws Exception {
        this.action_Apply();
        this.dispose();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.action_Apply();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.action_Okay();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.action_Cancel();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4() {
        try {
            this.lookAndFeelDialog_Initialize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static LookAndFeelDialog getInstance() {
        if (instance == null) {
            JFrame owner = new JFrame();
            try {
                owner.setIconImage(Tools.createImage((Component)owner, LookAndFeelDialog.class, (String)"/lafChooser.gif"));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            logger.fine("Creating LookAndFeelDialog..");
            instance = new LookAndFeelDialog(owner);
            logger.fine("Config LookAndFeelDialog..");
            instance.setTitle("Look & Feel");
            instance.setModal(true);
            LookAndFeelManager lafManager = LookAndFeelManager.getInstance();
            if (lafManager != null) {
                lafManager.registerComponent(instance);
            }
        }
        return instance;
    }

    private JButton getJButton() {
        if (this.ivjJButton == null) {
            try {
                this.ivjJButton = new JButton();
                this.ivjJButton.setName("JButton");
                this.ivjJButton.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/MatchingMapping.gif")));
                this.ivjJButton.setText("Okay");
                this.ivjJButton.setMargin(new Insets(2, 4, 2, 4));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton;
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/okay.gif")));
                this.ivjJButton1.setText("Apply");
                this.ivjJButton1.setMargin(new Insets(2, 4, 2, 4));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton1;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/cancel.gif")));
                this.ivjJButton2.setText("Cancel");
                this.ivjJButton2.setMargin(new Insets(2, 4, 2, 4));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton2;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLookAndFeelChooser1 = new GridBagConstraints();
                constraintsLookAndFeelChooser1.gridx = 0;
                constraintsLookAndFeelChooser1.gridy = 0;
                constraintsLookAndFeelChooser1.fill = 1;
                constraintsLookAndFeelChooser1.weightx = 1.0;
                constraintsLookAndFeelChooser1.weighty = 1.0;
                this.getJDialogContentPane().add((Component)this.getLookAndFeelChooser1(), constraintsLookAndFeelChooser1);
                GridBagConstraints constraintsJPanel2 = new GridBagConstraints();
                constraintsJPanel2.gridx = 0;
                constraintsJPanel2.gridy = 1;
                constraintsJPanel2.fill = 1;
                constraintsJPanel2.weightx = 1.0;
                constraintsJPanel2.insets = new Insets(4, 0, 0, 0);
                this.getJDialogContentPane().add((Component)this.getJPanel2(), constraintsJPanel2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setOpaque(false);
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJButton1 = new GridBagConstraints();
                constraintsJButton1.gridx = 0;
                constraintsJButton1.gridy = 0;
                constraintsJButton1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButton1(), constraintsJButton1);
                GridBagConstraints constraintsJButton = new GridBagConstraints();
                constraintsJButton.gridx = 1;
                constraintsJButton.gridy = 0;
                constraintsJButton.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButton(), constraintsJButton);
                GridBagConstraints constraintsJButton2 = new GridBagConstraints();
                constraintsJButton2.gridx = 2;
                constraintsJButton2.gridy = 0;
                constraintsJButton2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJButton2(), constraintsJButton2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setOpaque(false);
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 0;
                constraintsJPanel1.gridy = 0;
                constraintsJPanel1.anchor = 13;
                constraintsJPanel1.weightx = 1.0;
                this.getJPanel2().add((Component)this.getJPanel1(), constraintsJPanel1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private LookAndFeelChooser getLookAndFeelChooser1() {
        if (this.ivjLookAndFeelChooser1 == null) {
            try {
                this.ivjLookAndFeelChooser1 = new LookAndFeelChooser();
                this.ivjLookAndFeelChooser1.setName("LookAndFeelChooser1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLookAndFeelChooser1;
    }

    private void handleException(Throwable exception) {
        logger.fine("--------- UNCAUGHT EXCEPTION ---------");
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void initConnections() throws Exception {
        this.getJButton1().addActionListener(this.ivjEventHandler);
        this.getJButton().addActionListener(this.ivjEventHandler);
        this.getJButton2().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("LookAndFeelDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(413, 399);
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
            this.connEtoC4();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void lookAndFeelDialog_Initialize() {
        SwingTestPanel preview = new SwingTestPanel();
        preview.setOpaque(false);
        logger.fine("init.setPreview: " + preview);
        this.getLookAndFeelChooser1().setPreviewComponent(preview);
        this.getLookAndFeelChooser1().setPreviewComponentClass(preview.getClass());
        logger.fine("init.setPreview: OK");
    }

    public static void main(String[] args) {
        try {
            LookAndFeelDialog.getInstance().showLookAndFeelDialog();
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public synchronized void showLookAndFeelDialog() {
        this.pack();
        Tools.centerWindow((Window)this);
        this.setVisible(true);
    }

    static {
        logger = Logger.getLogger(LookAndFeelDialog.class.getName());
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LookAndFeelDialog.this.getJButton1()) {
                LookAndFeelDialog.this.connEtoC1(e);
            }
            if (e.getSource() == LookAndFeelDialog.this.getJButton()) {
                LookAndFeelDialog.this.connEtoC2(e);
            }
            if (e.getSource() == LookAndFeelDialog.this.getJButton2()) {
                LookAndFeelDialog.this.connEtoC3(e);
            }
        }
    }
}

