/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class ManagedTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 3119924148079065668L;
    private JButton closeButton;
    private int closeButtonTabIndex = -1;
    private boolean showCloseButton = true;
    private static final Logger logger = Logger.getLogger(ManagedTabbedPane.class.getName());

    public ManagedTabbedPane() {
        this.initManagedTabbedPane();
    }

    public void addCloseButtonActionListener(ActionListener l) {
        this.getCloseButton().addActionListener(l);
    }

    protected JButton createCloseButton() {
        JButton closeButton = new JButton();
        ImageIcon icon1 = null;
        try {
            icon1 = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/swing/icons/cancel.gif"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        ImageIcon icon2 = icon1 == null ? null : new ImageIcon(GrayFilter.createDisabledImage(icon1.getImage()));
        closeButton.setIcon(icon2);
        closeButton.setRolloverEnabled(true);
        closeButton.setRolloverIcon(icon1);
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.setOpaque(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                ManagedTabbedPane.this.hideCloseButton();
            }
        };
        closeButton.addMouseListener(mouseAdapter);
        return closeButton;
    }

    protected JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = this.createCloseButton();
        }
        return this.closeButton;
    }

    public int getCloseButtonTabIndex() {
        return this.closeButtonTabIndex;
    }

    public int getTabIndex(int x, int y) {
        int tabIndex = -1;
        TabbedPaneUI tabbedUI = this.getUI();
        if (tabbedUI != null) {
            int tabCount = this.getTabCount();
            for (int c = 0; c < tabCount; ++c) {
                Rectangle rect = tabbedUI.getTabBounds(this, c);
                if (rect == null || !rect.contains(x, y)) continue;
                tabIndex = c;
                break;
            }
        }
        return tabIndex;
    }

    public synchronized void hideCloseButton() {
        JButton button = this.getCloseButton();
        if (button == null) {
            return;
        }
        Container parent = button.getParent();
        if (parent != null) {
            Rectangle rect = button.getBounds();
            parent.remove(button);
            if (rect != null) {
                parent.repaint(rect.x, rect.y, rect.width, rect.height);
            }
        }
        button.setEnabled(false);
        button.setEnabled(true);
        this.closeButtonTabIndex = -1;
    }

    protected void initManagedTabbedPane() {
        final MouseMotionAdapter motionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                int x = e.getX();
                int y = e.getY();
                int tabIndex = ManagedTabbedPane.this.getTabIndex(x, y);
                ManagedTabbedPane.this.showCloseButton(tabIndex);
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                motionAdapter.mouseMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                int x = e.getX();
                int y = e.getY();
                if (ManagedTabbedPane.this.isCloseButtonArea(x, y)) {
                    motionAdapter.mouseMoved(e);
                } else {
                    ManagedTabbedPane.this.hideCloseButton();
                }
            }
        };
        ComponentAdapter compAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                super.componentResized(ev);
                ManagedTabbedPane.this.hideCloseButton();
            }

            @Override
            public void componentMoved(ComponentEvent ev) {
                super.componentMoved(ev);
                ManagedTabbedPane.this.hideCloseButton();
            }
        };
        this.addComponentListener(compAdapter);
        this.addMouseMotionListener(motionAdapter);
        this.addMouseListener(mouseAdapter);
    }

    protected boolean isCloseButtonArea(int x, int y) {
        Rectangle rect;
        JButton button;
        Point point = this.translatePointToLayeredPane(x, y);
        return point != null && (button = this.getCloseButton()) != null && button.getParent() != null && (rect = button.getBounds()) != null && rect.contains(point.x, point.y);
    }

    public boolean isShowCloseButton() {
        return this.showCloseButton;
    }

    @Override
    public void removeAll() {
        this.hideCloseButton();
        super.removeAll();
    }

    public void removeCloseButtonActionListener(ActionListener l) {
        this.getCloseButton().removeActionListener(l);
    }

    @Override
    public void removeTabAt(int i) {
        this.hideCloseButton();
        super.removeTabAt(i);
    }

    protected void setCloseButton(JButton newCloseButton) {
        this.closeButton = newCloseButton;
    }

    public void setShowCloseButton(boolean newShowCloseButton) {
        this.showCloseButton = newShowCloseButton;
    }

    public synchronized void showCloseButton(int tabIndex) {
        JButton button = this.getCloseButton();
        if (button == null) {
            return;
        }
        if (!this.isShowCloseButton()) {
            tabIndex = -1;
        }
        if (tabIndex < 0) {
            this.hideCloseButton();
        } else if (this.closeButtonTabIndex != tabIndex) {
            JLayeredPane layeredPane;
            this.hideCloseButton();
            TabbedPaneUI tabbedUI = this.getUI();
            JRootPane rootPane = this.getRootPane();
            JLayeredPane jLayeredPane = layeredPane = rootPane == null ? null : rootPane.getLayeredPane();
            if (tabbedUI != null && layeredPane != null) {
                Rectangle tabRect = tabbedUI.getTabBounds(this, tabIndex);
                int h = tabRect.height;
                int absX = tabRect.x + tabRect.width - h;
                int absY = tabRect.y + h / 2 - 8;
                Point point = this.translatePointToLayeredPane(absX, absY);
                if (point != null) {
                    absX = point.x;
                    absY = point.y;
                    button.setBounds(absX, absY, h, h);
                    layeredPane.add(button);
                    layeredPane.setLayer(button, JLayeredPane.DEFAULT_LAYER - 1);
                    this.closeButtonTabIndex = tabIndex;
                }
            }
        }
    }

    protected Point translatePointToLayeredPane(int x, int y) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return null;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        if (layeredPane == null) {
            return null;
        }
        int absX = x;
        int absY = y;
        for (Container comp = this; comp != null && !(comp instanceof Window) && !(comp instanceof JRootPane); comp = comp.getParent()) {
            absX += ((Component)comp).getX();
            absY += ((Component)comp).getY();
        }
        return new Point(absX, absY);
    }
}

