/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class SwingTools {
    private static final Logger logger = Logger.getLogger(SwingTools.class.getName());
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private SwingTools() {
    }

    public static void clearJComboBox(JComboBox box) {
        int num = box.getItemCount();
        for (int i = num - 1; i >= 0; --i) {
            box.removeItemAt(i);
        }
    }

    public static void clearJTabbedPane(JTabbedPane pane) {
        int num = pane.getTabCount();
        for (int i = num - 1; i >= 0; --i) {
            pane.removeTabAt(i);
        }
    }

    public static JDialog createJDialog(Component owner) {
        Window window;
        JDialog dialog = null;
        Window window2 = window = owner == null ? null : SwingUtilities.getWindowAncestor(owner);
        if (window != null) {
            if (window instanceof Frame) {
                dialog = new JDialog((Frame)window);
            }
            if (window instanceof Dialog) {
                dialog = new JDialog((Dialog)window);
            }
        }
        if (dialog == null) {
            dialog = new JDialog();
        }
        return dialog;
    }

    public static Object[] getSelectedObjects(JList list) {
        int[] sel = list.getSelectedIndices();
        int num = sel.length;
        if (num < 1) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] arr = new Object[num];
        ListModel lm = list.getModel();
        for (int i = 0; i < num; ++i) {
            arr[i] = lm.getElementAt(sel[i]);
        }
        return arr;
    }

    private static Method lookupMethodSetAlwaysOnTop(Window window) {
        if (window == null) {
            return null;
        }
        try {
            Class<?> windowClass = window.getClass();
            if (windowClass == null) {
                return null;
            }
            Method methodSetAlwaysOnTop = windowClass.getMethod("setAlwaysOnTop", Boolean.TYPE);
            return methodSetAlwaysOnTop;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean supportsWindowAlwaysOnTop(Window window) {
        return SwingTools.lookupMethodSetAlwaysOnTop(window) != null;
    }

    public static boolean setWindowAlwaysOnTop(Window window, boolean alwaysOnTop) {
        try {
            Method methodSetAlwaysOnTop = SwingTools.lookupMethodSetAlwaysOnTop(window);
            if (methodSetAlwaysOnTop != null) {
                Boolean param = alwaysOnTop ? Boolean.TRUE : Boolean.FALSE;
                methodSetAlwaysOnTop.invoke((Object)window, param);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private static Method lookupMethodSetShape(Window window) {
        if (window == null) {
            return null;
        }
        try {
            Class<?> windowClass = window.getClass();
            if (windowClass == null) {
                return null;
            }
            Method methodSetShape = windowClass.getMethod("setShape", Shape.class);
            return methodSetShape;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method lookupMethodSetWindowShape(Window window) {
        if (window == null) {
            return null;
        }
        try {
            Class<?> classAWTUtilities = Class.forName("com.sun.awt.AWTUtilities");
            Method methodSetWindowShape = classAWTUtilities.getMethod("setWindowShape", Window.class, Shape.class);
            return methodSetWindowShape;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean supportsWindowShape(Window window) {
        if (SwingTools.lookupMethodSetShape(window) != null) {
            return true;
        }
        return SwingTools.lookupMethodSetWindowShape(window) != null;
    }

    public static boolean setWindowShape(Window window, Shape shape) {
        try {
            Method methodSetShape = SwingTools.lookupMethodSetShape(window);
            if (methodSetShape != null) {
                methodSetShape.invoke((Object)window, shape);
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            Method methodSetWindowShape = SwingTools.lookupMethodSetWindowShape(window);
            if (methodSetWindowShape != null) {
                methodSetWindowShape.invoke(null, window, shape);
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }
}

