/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableRowHeader
extends JComponent
implements TableModelListener,
PropertyChangeListener {
    private static final long serialVersionUID = 9149967038778520420L;
    private JTable table;
    private TableModel tableModel;
    private TableCellRenderer rowHeaderCellRenderer;
    private CellRendererPane rendererPane;

    public TableRowHeader() {
        this.initTableRowHeader();
    }

    protected int calculatePreferredHeight() {
        JTable table = this.getTable();
        if (table != null) {
            int rowCount = table.getRowCount();
            int rowHeight = table.getRowHeight();
            return rowCount * rowHeight;
        }
        return 0;
    }

    protected int calculatePreferredWidth() {
        int rc = 0;
        TableModel model = this.getTableModel();
        if (model != null) {
            int rowCount = model.getRowCount();
            for (int c = 0; c < rowCount; ++c) {
                Dimension dim;
                Component comp = this.getRendererComponent(c);
                if (comp == null || (dim = comp.getPreferredSize()) == null || dim.width <= rc) continue;
                rc = dim.width;
            }
        }
        return rc;
    }

    protected Component getRendererComponent(int row) {
        TableCellRenderer renderer = this.getRowHeaderCellRenderer();
        if (renderer != null) {
            int column = -1;
            Object value = this.getRowHeaderValue(row);
            boolean isSelected = this.isRowHeaderSelected(row);
            boolean hasFocus = this.hasRowHeaderFocus(row);
            return renderer.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        }
        return null;
    }

    protected CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public TableCellRenderer getRowHeaderCellRenderer() {
        return this.rowHeaderCellRenderer;
    }

    protected Object getRowHeaderValue(int row) {
        return null;
    }

    public JTable getTable() {
        return this.table;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    protected boolean hasRowHeaderFocus(int row) {
        return false;
    }

    protected void initTableRowHeader() {
        this.setOpaque(false);
        this.setForeground(Color.darkGray);
        CellRendererPane pane = new CellRendererPane();
        this.setRendererPane(pane);
        this.setLayout(null);
        this.add(pane);
        this.resizeAndRepaint();
    }

    protected boolean isRowHeaderSelected(int row) {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int c;
        int w = this.getWidth();
        JTable table = this.getTable();
        if (table == null) {
            return;
        }
        int rowCount = table.getRowCount();
        int rowHeight = table.getRowHeight();
        Rectangle rect = new Rectangle();
        int y = 0;
        for (c = 0; c < rowCount; ++c) {
            rect.x = 0;
            rect.y = y;
            rect.width = w;
            rect.height = rowHeight - 1;
            this.paintRowHeader(g, c, rect);
            y += rowHeight;
        }
        this.rendererPane.removeAll();
        g.setColor(this.getForeground());
        y = rowHeight - 1;
        for (c = 0; c < rowCount; ++c) {
            g.drawLine(0, y, w - 2, y);
            y += rowHeight;
        }
        g.drawLine(w - 1, 0, w - 1, y - rowHeight);
    }

    protected void paintRowHeader(Graphics g, int row, Rectangle rect) {
        Component component = this.getRendererComponent(row);
        if (component != null) {
            this.rendererPane.add(component);
            this.rendererPane.paintComponent(g, component, this, rect.x, rect.y, rect.width, rect.height, true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model")) {
            Object newValue = evt.getNewValue();
            TableModel newModel = newValue instanceof TableModel ? (TableModel)newValue : null;
            this.setTableModel(newModel);
        }
    }

    protected void resizeAndRepaint() {
        int prefWidth = this.calculatePreferredWidth();
        int prefHeight = this.calculatePreferredHeight();
        this.setPreferredSize(new Dimension(prefWidth, prefHeight));
        this.revalidate();
        this.repaint();
    }

    protected void setRendererPane(CellRendererPane newRendererPane) {
        this.rendererPane = newRendererPane;
    }

    public void setRowHeaderCellRenderer(TableCellRenderer newRowHeaderCellRenderer) {
        this.rowHeaderCellRenderer = newRowHeaderCellRenderer;
    }

    public synchronized void setTable(JTable newTable) {
        if (this.table != null) {
            this.table.removePropertyChangeListener(this);
        }
        this.table = newTable;
        if (this.table != null) {
            this.table.addPropertyChangeListener(this);
        }
    }

    protected synchronized void setTableModel(TableModel newTableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
        this.tableModel = newTableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this);
        }
        this.resizeAndRepaint();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.resizeAndRepaint();
    }
}

