/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor;

import com.spacekiller.util.Platform;
import com.waxmonster.editor.ScratchPatternProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScratchPatternManager {
    private static final Logger logger = Logger.getLogger(ScratchPatternManager.class.getName());
    private static ScratchPatternManager INSTANCE;
    private List scratchPatternProviders = new ArrayList();

    protected ScratchPatternManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScratchPatternManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ScratchPatternManager> clazz = ScratchPatternManager.class;
        synchronized (ScratchPatternManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ScratchPatternManager();
            INSTANCE.loadServices();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected void loadServices() {
        try {
            Iterator scratchPatternProviderIter = Platform.getInstance().getServices(ScratchPatternProvider.class);
            while (scratchPatternProviderIter.hasNext()) {
                try {
                    Object obj = scratchPatternProviderIter.next();
                    if (obj == null || !(obj instanceof ScratchPatternProvider)) continue;
                    ScratchPatternProvider scratchPatternProvider = (ScratchPatternProvider)obj;
                    this.registerScratchPatternProvider(scratchPatternProvider);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("ScratchPatternProvider: " + scratchPatternProvider);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected synchronized void registerScratchPatternProvider(ScratchPatternProvider provider) {
        if (provider == null) {
            return;
        }
        this.scratchPatternProviders.add(provider);
    }

    protected synchronized void unregisterScratchPatternProvider(ScratchPatternProvider provider) {
        this.scratchPatternProviders.remove(provider);
    }

    public synchronized ScratchPatternProvider[] getScratchPatternProviders() {
        return this.scratchPatternProviders.toArray(new ScratchPatternProvider[this.scratchPatternProviders.size()]);
    }
}

