/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.plugin;

import com.spacekiller.util.Tools;
import com.spacekiller.util.member.AbstractUserRegistry;
import com.spacekiller.util.member.Group;
import com.spacekiller.util.member.Member;
import com.spacekiller.util.member.User;
import com.spacekiller.util.swing.AbstractCellRenderer;
import com.spacekiller.util.swing.DocumentAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserRegistryPanel
extends JPanel {
    private static final long serialVersionUID = -146928111301554817L;
    private AbstractUserRegistry registry;
    private Icon iconUser;
    private Icon iconGroup;
    private boolean dialogConfirm = false;
    private Group editGroup;
    private DefaultListModel groupMemberListModel;
    private JToolBar jToolBar = null;
    private JButton jButtonCreateUser = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelUsers = null;
    private JPanel jPanelGroups = null;
    private JButton jButtonCreateGroup = null;
    private JScrollPane jScrollPane = null;
    private JList jListUsers = null;
    private JScrollPane jScrollPane1 = null;
    private JList jListGroups = null;
    private JDialog jDialogUser = null;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JTextField jTextFieldUserName = null;
    private JTextField jTextFieldUserDescr = null;
    private JTextField jTextFieldUserEmail = null;
    private JButton jButtonUserOk = null;
    private JLabel jLabel3 = null;
    private JCheckBox jCheckBoxUserRevoked = null;
    private JDialog jDialogGroup = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JTextField jTextFieldGroupName = null;
    private JTextField jTextFieldGroupDescr = null;
    private JButton jButtonGroupOk = null;
    private JDialog jDialogSetPassword = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel6 = null;
    private JLabel jLabel7 = null;
    private JTextField jTextFieldSetPassUser = null;
    private JButton jButtonSetPassOk = null;
    private JLabel jLabel8 = null;
    private JPasswordField jPasswordFieldSetPass1 = null;
    private JPasswordField jPasswordFieldSetPass2 = null;
    private JButton jButtonUserSetPass = null;
    private JButton jButtonProperties = null;
    private JButton jButtonRemove = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel9 = null;
    private JScrollPane jScrollPane2 = null;
    private JList jListGroupMembers = null;
    private JPanel jPanel5 = null;
    private JButton jButtonGroupMemberAdd = null;
    private JButton jButtonGroupMemberRemove = null;
    private JDialog jDialogAddMember = null;
    private JPanel jPanel6 = null;
    private JLabel jLabel12 = null;
    private JScrollPane jScrollPane3 = null;
    private JList jListAddMember = null;
    private JPanel jPanel7 = null;
    private JButton jButtonAddMember = null;
    private JButton jButtonOpenRegistry = null;
    private JPanel jPanel8 = null;
    private static final Logger logger = Logger.getLogger(UserRegistryPanel.class.getName());

    public UserRegistryPanel() {
        this.initialize();
        this.initUserRegistryPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(464, 338));
        this.add((Component)this.getJToolBar(), gridBagConstraints);
        this.add((Component)this.getJTabbedPane(), gridBagConstraints1);
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setOpaque(false);
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJButtonOpenRegistry());
            this.jToolBar.add(this.getJPanel8());
            this.jToolBar.add(this.getJButtonCreateUser());
            this.jToolBar.add(this.getJButtonCreateGroup());
            this.jToolBar.add(this.getJPanel3());
            this.jToolBar.add(this.getJButtonProperties());
            this.jToolBar.add(this.getJButtonUserSetPass());
            this.jToolBar.add(this.getJPanel4());
            this.jToolBar.add(this.getJButtonRemove());
        }
        return this.jToolBar;
    }

    private JButton getJButtonCreateUser() {
        if (this.jButtonCreateUser == null) {
            this.jButtonCreateUser = new JButton();
            this.jButtonCreateUser.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/user_object.gif")));
            this.jButtonCreateUser.setToolTipText("Create user account..");
            this.jButtonCreateUser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionCreateUser();
                }
            });
        }
        return this.jButtonCreateUser;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Users", new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/user_object.gif")), this.getJPanelUsers(), null);
            this.jTabbedPane.addTab("Groups", new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/group_object.gif")), this.getJPanelGroups(), null);
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UserRegistryPanel.this.checkEnable();
                }
            });
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelUsers() {
        if (this.jPanelUsers == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.gridx = 0;
            this.jPanelUsers = new JPanel();
            this.jPanelUsers.setLayout(new GridBagLayout());
            this.jPanelUsers.setOpaque(false);
            this.jPanelUsers.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.jPanelUsers;
    }

    private JPanel getJPanelGroups() {
        if (this.jPanelGroups == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridx = 0;
            this.jPanelGroups = new JPanel();
            this.jPanelGroups.setLayout(new GridBagLayout());
            this.jPanelGroups.setOpaque(false);
            this.jPanelGroups.add((Component)this.getJScrollPane1(), gridBagConstraints3);
        }
        return this.jPanelGroups;
    }

    private JButton getJButtonCreateGroup() {
        if (this.jButtonCreateGroup == null) {
            this.jButtonCreateGroup = new JButton();
            this.jButtonCreateGroup.setToolTipText("Create group..");
            this.jButtonCreateGroup.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/group_object.gif")));
            this.jButtonCreateGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionCreateGroup();
                }
            });
        }
        return this.jButtonCreateGroup;
    }

    protected AbstractUserRegistry getRegistry() {
        return this.registry;
    }

    protected void setRegistry(AbstractUserRegistry registry) {
        this.registry = registry;
        this.refresh();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJListUsers());
        }
        return this.jScrollPane;
    }

    private JList getJListUsers() {
        if (this.jListUsers == null) {
            this.jListUsers = new JList();
            this.jListUsers.setOpaque(false);
            this.jListUsers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    UserRegistryPanel.this.checkEnable();
                }
            });
        }
        return this.jListUsers;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane1.setViewportView(this.getJListGroups());
        }
        return this.jScrollPane1;
    }

    private JList getJListGroups() {
        if (this.jListGroups == null) {
            this.jListGroups = new JList();
            this.jListGroups.setOpaque(false);
            this.jListGroups.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    UserRegistryPanel.this.checkEnable();
                }
            });
        }
        return this.jListGroups;
    }

    protected void refresh() {
        TreeMap<String, Member> users = new TreeMap<String, Member>();
        TreeMap<String, Member> groups = new TreeMap<String, Member>();
        if (this.registry != null) {
            try {
                Iterator i = this.registry.getMembers();
                while (i.hasNext()) {
                    Member member = (Member)i.next();
                    if (member instanceof Group) {
                        groups.put(member.getName(), member);
                        continue;
                    }
                    if (!(member instanceof User)) continue;
                    users.put(member.getName(), member);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        DefaultListModel userModel = new DefaultListModel();
        Iterator i = users.values().iterator();
        while (i.hasNext()) {
            userModel.addElement(i.next());
        }
        this.getJListUsers().setModel(userModel);
        DefaultListModel groupModel = new DefaultListModel();
        Iterator i2 = groups.values().iterator();
        while (i2.hasNext()) {
            groupModel.addElement(i2.next());
        }
        this.getJListGroups().setModel(groupModel);
        this.checkEnable();
    }

    protected void initUserRegistryPanel() {
        UserGroupListCellRenderer renderer = new UserGroupListCellRenderer();
        this.getJListUsers().setCellRenderer(renderer);
        this.getJListGroups().setCellRenderer(renderer);
        this.getJListGroupMembers().setCellRenderer(renderer);
        this.getJListAddMember().setCellRenderer(renderer);
        this.iconUser = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/user_object.gif"));
        this.iconGroup = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/group_object.gif"));
        this.checkEnable();
        DocumentAdapter passDocAdapter = new DocumentAdapter(){

            protected void handle(DocumentEvent e) {
                UserRegistryPanel.this.handlePwEdited();
            }
        };
        this.getJPasswordFieldSetPass1().getDocument().addDocumentListener((DocumentListener)passDocAdapter);
        this.getJPasswordFieldSetPass2().getDocument().addDocumentListener((DocumentListener)passDocAdapter);
    }

    protected void handlePwEdited() {
        char[] pw1 = this.getJPasswordFieldSetPass1().getPassword();
        char[] pw2 = this.getJPasswordFieldSetPass2().getPassword();
        boolean enable = false;
        if (pw1.length == pw2.length) {
            enable = true;
            for (int c = 0; c < pw1.length; ++c) {
                if (pw1[c] == pw2[c]) continue;
                enable = false;
                break;
            }
        }
        this.getJButtonSetPassOk().setEnabled(enable);
    }

    private JDialog getJDialogUser() {
        if (this.jDialogUser == null) {
            this.jDialogUser = new JDialog();
            this.jDialogUser.setSize(new Dimension(306, 201));
            this.jDialogUser.setTitle("User Account");
            this.jDialogUser.setContentPane(this.getJContentPane());
        }
        return this.jDialogUser;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.gridy = 3;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints11.gridy = 3;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Revoked:");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.anchor = 14;
            gridBagConstraints10.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridy = 4;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 1;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 2;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("E-mail:");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Description:");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("User name:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints4);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints5);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints6);
            this.jContentPane.add((Component)this.getJTextFieldUserName(), gridBagConstraints7);
            this.jContentPane.add((Component)this.getJTextFieldUserDescr(), gridBagConstraints8);
            this.jContentPane.add((Component)this.getJTextFieldUserEmail(), gridBagConstraints9);
            this.jContentPane.add((Component)this.getJButtonUserOk(), gridBagConstraints10);
            this.jContentPane.add((Component)this.jLabel3, gridBagConstraints11);
            this.jContentPane.add((Component)this.getJCheckBoxUserRevoked(), gridBagConstraints12);
        }
        return this.jContentPane;
    }

    private JTextField getJTextFieldUserName() {
        if (this.jTextFieldUserName == null) {
            this.jTextFieldUserName = new JTextField();
            this.jTextFieldUserName.setColumns(20);
        }
        return this.jTextFieldUserName;
    }

    private JTextField getJTextFieldUserDescr() {
        if (this.jTextFieldUserDescr == null) {
            this.jTextFieldUserDescr = new JTextField();
        }
        return this.jTextFieldUserDescr;
    }

    private JTextField getJTextFieldUserEmail() {
        if (this.jTextFieldUserEmail == null) {
            this.jTextFieldUserEmail = new JTextField();
        }
        return this.jTextFieldUserEmail;
    }

    private JButton getJButtonUserOk() {
        if (this.jButtonUserOk == null) {
            this.jButtonUserOk = new JButton();
            this.jButtonUserOk.setText("Ok");
            this.jButtonUserOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.dialogConfirm = true;
                    UserRegistryPanel.this.getJDialogUser().dispose();
                }
            });
        }
        return this.jButtonUserOk;
    }

    private JCheckBox getJCheckBoxUserRevoked() {
        if (this.jCheckBoxUserRevoked == null) {
            this.jCheckBoxUserRevoked = new JCheckBox();
            this.jCheckBoxUserRevoked.setText("");
        }
        return this.jCheckBoxUserRevoked;
    }

    private JDialog getJDialogGroup() {
        if (this.jDialogGroup == null) {
            this.jDialogGroup = new JDialog();
            this.jDialogGroup.setTitle("Group");
            this.jDialogGroup.setSize(new Dimension(356, 265));
            this.jDialogGroup.setContentPane(this.getJPanel1());
        }
        return this.jDialogGroup;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 0;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.fill = 2;
            gridBagConstraints27.gridwidth = 2;
            gridBagConstraints27.gridy = 4;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 1;
            gridBagConstraints26.gridy = 3;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.weighty = 1.0;
            gridBagConstraints26.gridwidth = 2;
            gridBagConstraints26.insets = new Insets(4, 4, 0, 4);
            gridBagConstraints26.gridx = 0;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.insets = new Insets(4, 4, 0, 4);
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.gridy = 2;
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("Members:");
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints16.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.insets = new Insets(4, 4, 4, 4);
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Description:");
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.insets = new Insets(4, 4, 4, 4);
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Group name:");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.jLabel4, gridBagConstraints13);
            this.jPanel1.add((Component)this.jLabel5, gridBagConstraints14);
            this.jPanel1.add((Component)this.getJTextFieldGroupName(), gridBagConstraints16);
            this.jPanel1.add((Component)this.getJTextFieldGroupDescr(), gridBagConstraints17);
            this.jPanel1.add((Component)this.jLabel9, gridBagConstraints25);
            this.jPanel1.add((Component)this.getJScrollPane2(), gridBagConstraints26);
            this.jPanel1.add((Component)this.getJPanel5(), gridBagConstraints27);
        }
        return this.jPanel1;
    }

    private JTextField getJTextFieldGroupName() {
        if (this.jTextFieldGroupName == null) {
            this.jTextFieldGroupName = new JTextField();
            this.jTextFieldGroupName.setColumns(20);
        }
        return this.jTextFieldGroupName;
    }

    private JTextField getJTextFieldGroupDescr() {
        if (this.jTextFieldGroupDescr == null) {
            this.jTextFieldGroupDescr = new JTextField();
        }
        return this.jTextFieldGroupDescr;
    }

    private JButton getJButtonGroupOk() {
        if (this.jButtonGroupOk == null) {
            this.jButtonGroupOk = new JButton();
            this.jButtonGroupOk.setText("Ok");
            this.jButtonGroupOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.dialogConfirm = true;
                    UserRegistryPanel.this.getJDialogGroup().dispose();
                }
            });
        }
        return this.jButtonGroupOk;
    }

    private JDialog getJDialogSetPassword() {
        if (this.jDialogSetPassword == null) {
            this.jDialogSetPassword = new JDialog();
            this.jDialogSetPassword.setTitle("Set Password");
            this.jDialogSetPassword.setSize(new Dimension(295, 169));
            this.jDialogSetPassword.setContentPane(this.getJPanel2());
        }
        return this.jDialogSetPassword;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 2;
            gridBagConstraints24.gridy = 2;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints24.gridx = 1;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.gridy = 1;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints23.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints21.gridy = 2;
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("Confirm password:");
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.anchor = 14;
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridy = 4;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridx = 1;
            gridBagConstraints20.gridy = 0;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.gridy = 1;
            gridBagConstraints18.insets = new Insets(4, 4, 4, 4);
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("New password:");
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.insets = new Insets(4, 4, 4, 4);
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("User name:");
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.jLabel6, gridBagConstraints15);
            this.jPanel2.add((Component)this.jLabel7, gridBagConstraints18);
            this.jPanel2.add((Component)this.getJTextFieldSetPassUser(), gridBagConstraints20);
            this.jPanel2.add((Component)this.getJButtonSetPassOk(), gridBagConstraints22);
            this.jPanel2.add((Component)this.jLabel8, gridBagConstraints21);
            this.jPanel2.add((Component)this.getJPasswordFieldSetPass1(), gridBagConstraints23);
            this.jPanel2.add((Component)this.getJPasswordFieldSetPass2(), gridBagConstraints24);
        }
        return this.jPanel2;
    }

    private JTextField getJTextFieldSetPassUser() {
        if (this.jTextFieldSetPassUser == null) {
            this.jTextFieldSetPassUser = new JTextField();
            this.jTextFieldSetPassUser.setEditable(false);
            this.jTextFieldSetPassUser.setOpaque(false);
            this.jTextFieldSetPassUser.setColumns(14);
        }
        return this.jTextFieldSetPassUser;
    }

    private JButton getJButtonSetPassOk() {
        if (this.jButtonSetPassOk == null) {
            this.jButtonSetPassOk = new JButton();
            this.jButtonSetPassOk.setText("Ok");
            this.jButtonSetPassOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.dialogConfirm = true;
                    UserRegistryPanel.this.getJDialogSetPassword().dispose();
                }
            });
        }
        return this.jButtonSetPassOk;
    }

    private JPasswordField getJPasswordFieldSetPass1() {
        if (this.jPasswordFieldSetPass1 == null) {
            this.jPasswordFieldSetPass1 = new JPasswordField();
            this.jPasswordFieldSetPass1.setOpaque(false);
            this.jPasswordFieldSetPass1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.getJPasswordFieldSetPass2().requestFocus();
                }
            });
        }
        return this.jPasswordFieldSetPass1;
    }

    private JPasswordField getJPasswordFieldSetPass2() {
        if (this.jPasswordFieldSetPass2 == null) {
            this.jPasswordFieldSetPass2 = new JPasswordField();
            this.jPasswordFieldSetPass2.setOpaque(false);
            this.jPasswordFieldSetPass2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.getJButtonSetPassOk().doClick();
                }
            });
        }
        return this.jPasswordFieldSetPass2;
    }

    protected void actionCreateUser() {
        this.getJTabbedPane().setSelectedComponent(this.getJPanelUsers());
        this.getJDialogUser().setTitle("Create User Account");
        this.getJTextFieldUserName().setEditable(true);
        this.getJTextFieldUserName().setText("");
        this.getJTextFieldUserDescr().setText("");
        this.getJTextFieldUserEmail().setText("");
        this.getJCheckBoxUserRevoked().setSelected(false);
        this.getJDialogUser().pack();
        Tools.centerWindow((Component)this, (Window)this.getJDialogUser());
        this.getJDialogUser().setModal(true);
        this.dialogConfirm = false;
        this.getJDialogUser().setVisible(true);
        if (!this.dialogConfirm) {
            return;
        }
        User user = null;
        try {
            String name = this.getJTextFieldUserName().getText().trim();
            if (name.length() < 1) {
                return;
            }
            String descr = this.getJTextFieldUserDescr().getText().trim();
            String email = this.getJTextFieldUserEmail().getText().trim();
            boolean revoke = this.getJCheckBoxUserRevoked().isSelected();
            user = this.registry.createUser(name, descr, email, revoke);
            logger.fine("Created user: " + user);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.refresh();
        if (user != null) {
            this.getJListUsers().setSelectedValue(user, true);
            this.actionSetPass();
        }
    }

    protected void actionCreateGroup() {
        this.getJTabbedPane().setSelectedComponent(this.getJPanelGroups());
        this.getJDialogGroup().setTitle("Create Group");
        this.getJTextFieldGroupName().setEditable(true);
        this.getJTextFieldGroupName().setText("");
        this.getJTextFieldGroupDescr().setText("");
        this.getJDialogGroup().pack();
        Tools.centerWindow((Component)this, (Window)this.getJDialogGroup());
        this.getJDialogGroup().setModal(true);
        this.dialogConfirm = false;
        this.getJDialogGroup().setVisible(true);
        if (!this.dialogConfirm) {
            return;
        }
        Group group = null;
        try {
            String name = this.getJTextFieldGroupName().getText().trim();
            if (name.length() < 1) {
                return;
            }
            String descr = this.getJTextFieldGroupDescr().getText().trim();
            group = this.registry.createGroup(name, descr);
            logger.fine("Created group: " + group);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.refresh();
        if (group != null) {
            this.getJListGroups().setSelectedValue(group, true);
        }
    }

    protected void actionRemove() {
        try {
            Component tab = this.getJTabbedPane().getSelectedComponent();
            if (tab == this.getJPanelUsers()) {
                int[] sel = this.getJListUsers().getSelectedIndices();
                ListModel model = this.getJListUsers().getModel();
                for (int c = 0; c < sel.length; ++c) {
                    User user = (User)model.getElementAt(sel[c]);
                    this.registry.removeUser(user);
                }
            } else {
                int[] sel = this.getJListGroups().getSelectedIndices();
                ListModel model = this.getJListGroups().getModel();
                for (int c = 0; c < sel.length; ++c) {
                    Group group = (Group)model.getElementAt(sel[c]);
                    this.registry.removeGroup(group);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.refresh();
    }

    protected void actionProperties() {
        try {
            Component tab = this.getJTabbedPane().getSelectedComponent();
            if (tab == this.getJPanelUsers()) {
                User user = (User)this.getJListUsers().getSelectedValue();
                if (user == null) {
                    return;
                }
                JDialog dialog = this.getJDialogUser();
                dialog.setTitle("User Properties");
                this.getJTextFieldUserName().setText(user.getName());
                this.getJTextFieldUserName().setEditable(false);
                String descr = user.getDescription();
                if (descr == null) {
                    descr = "";
                }
                this.getJTextFieldUserDescr().setText(descr);
                String email = user.getEmail();
                if (email == null) {
                    email = "";
                }
                this.getJTextFieldUserEmail().setText(email);
                this.getJCheckBoxUserRevoked().setSelected(user.isRevoked());
                dialog.pack();
                Tools.centerWindow((Component)this, (Window)dialog);
                this.dialogConfirm = false;
                dialog.setModal(true);
                dialog.setVisible(true);
                if (this.dialogConfirm) {
                    descr = this.getJTextFieldUserDescr().getText();
                    this.registry.setMemberDescription((Member)user, descr);
                    email = this.getJTextFieldUserEmail().getText();
                    this.registry.setUserEmail(user, email);
                    boolean revoke = this.getJCheckBoxUserRevoked().isSelected();
                    this.registry.setUserRevoked(user, revoke);
                }
            } else {
                Group group = (Group)this.getJListGroups().getSelectedValue();
                if (group == null) {
                    return;
                }
                this.editGroup = group;
                JDialog dialog = this.getJDialogGroup();
                dialog.setTitle("Group Properties");
                this.getJTextFieldGroupName().setText(group.getName());
                this.getJTextFieldGroupName().setEditable(false);
                String descr = group.getDescription();
                if (descr == null) {
                    descr = "";
                }
                this.getJTextFieldGroupDescr().setText(descr);
                this.refreshGroupMembers();
                dialog.pack();
                Tools.centerWindow((Component)this, (Window)dialog);
                this.dialogConfirm = false;
                dialog.setModal(true);
                dialog.setVisible(true);
                if (this.dialogConfirm) {
                    descr = this.getJTextFieldGroupDescr().getText();
                    this.registry.setMemberDescription((Member)group, descr);
                    Member[] oldMembers = this.registry.getGroupMembers(group, false);
                    HashSet<Member> oldSet = new HashSet<Member>();
                    for (int c = 0; c < oldMembers.length; ++c) {
                        oldSet.add(oldMembers[c]);
                    }
                    int newCount = this.groupMemberListModel.getSize();
                    for (int c = 0; c < newCount; ++c) {
                        Member member = (Member)this.groupMemberListModel.getElementAt(c);
                        if (member == group) continue;
                        if (oldSet.contains(member)) {
                            oldSet.remove(member);
                            continue;
                        }
                        this.registry.addGroupMember(group, member);
                    }
                    for (Member member : oldSet) {
                        this.registry.removeGroupMember(group, member);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void refreshGroupMembers() throws Exception {
        this.getJButtonGroupMemberRemove().setEnabled(false);
        DefaultListModel model = new DefaultListModel();
        if (this.editGroup != null) {
            Member[] members = this.registry.getGroupMembers(this.editGroup, false);
            TreeMap<String, Member> mapUsers = new TreeMap<String, Member>();
            TreeMap<String, Member> mapGroups = new TreeMap<String, Member>();
            for (int c = 0; c < members.length; ++c) {
                Member member = members[c];
                if (member instanceof User) {
                    mapUsers.put(member.getName(), member);
                    continue;
                }
                if (!(member instanceof Group)) continue;
                mapGroups.put(member.getName(), member);
            }
            Iterator i = mapUsers.values().iterator();
            while (i.hasNext()) {
                model.addElement(i.next());
            }
            i = mapGroups.values().iterator();
            while (i.hasNext()) {
                model.addElement(i.next());
            }
        }
        this.getJListGroupMembers().setModel(model);
        this.groupMemberListModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionSetPass() {
        int i = this.getJListUsers().getSelectedIndex();
        if (i < 0) {
            return;
        }
        User user = (User)this.getJListUsers().getModel().getElementAt(i);
        JDialog dialog = this.getJDialogSetPassword();
        this.getJTextFieldSetPassUser().setText(user.getName());
        this.getJPasswordFieldSetPass1().setText("");
        this.getJPasswordFieldSetPass2().setText("");
        this.handlePwEdited();
        dialog.pack();
        Tools.centerWindow((Component)this, (Window)dialog);
        this.dialogConfirm = false;
        dialog.setModal(true);
        dialog.setVisible(true);
        try {
            if (!this.dialogConfirm) {
                return;
            }
            char[] pw = this.getJPasswordFieldSetPass1().getPassword();
            String pass = new String(pw);
            Properties credentials = new Properties();
            credentials.put("user", user.getName());
            credentials.put("pass", pass);
            this.registry.setCredentials(user, credentials);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.getJPasswordFieldSetPass1().setText("");
            this.getJPasswordFieldSetPass2().setText("");
        }
    }

    protected void actionAddGroupMembers(Group group) {
        TreeMap<String, Member> users = new TreeMap<String, Member>();
        TreeMap<String, Member> groups = new TreeMap<String, Member>();
        if (this.registry != null) {
            try {
                Iterator i = this.registry.getMembers();
                while (i.hasNext()) {
                    Member member = (Member)i.next();
                    if (member == this.editGroup || this.groupMemberListModel.contains(member)) continue;
                    if (member instanceof Group) {
                        groups.put(member.getName(), member);
                        continue;
                    }
                    if (!(member instanceof User)) continue;
                    users.put(member.getName(), member);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        DefaultListModel model = new DefaultListModel();
        Iterator i = users.values().iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
        i = groups.values().iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
        this.getJListAddMember().setModel(model);
        JDialog dialog = this.getJDialogAddMember();
        dialog.setBounds(0, 0, 250, 300);
        Tools.centerWindow((Component)this, (Window)dialog);
        this.dialogConfirm = false;
        dialog.setModal(true);
        dialog.setVisible(true);
        if (!this.dialogConfirm) {
            return;
        }
        int[] sel = this.getJListAddMember().getSelectedIndices();
        for (int c = 0; c < sel.length; ++c) {
            try {
                Member member = (Member)model.getElementAt(sel[c]);
                if (member == group) continue;
                this.groupMemberListModel.addElement(member);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void actionRemoveGroupMembers() {
        Object[] members = this.getJListGroupMembers().getSelectedValues();
        for (int c = 0; c < members.length; ++c) {
            this.groupMemberListModel.removeElement(members[c]);
        }
    }

    private JButton getJButtonUserSetPass() {
        if (this.jButtonUserSetPass == null) {
            this.jButtonUserSetPass = new JButton();
            this.jButtonUserSetPass.setText("");
            this.jButtonUserSetPass.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/passwordfield_obj.gif")));
            this.jButtonUserSetPass.setFont(new Font("Dialog", 0, 12));
            this.jButtonUserSetPass.setToolTipText("Set password..");
            this.jButtonUserSetPass.setMaximumSize(new Dimension(28, 28));
            this.jButtonUserSetPass.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonUserSetPass.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionSetPass();
                }
            });
        }
        return this.jButtonUserSetPass;
    }

    private JButton getJButtonProperties() {
        if (this.jButtonProperties == null) {
            this.jButtonProperties = new JButton();
            this.jButtonProperties.setFont(new Font("Dialog", 1, 12));
            this.jButtonProperties.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonProperties.setText("");
            this.jButtonProperties.setToolTipText("Properties..");
            this.jButtonProperties.setPreferredSize(new Dimension(28, 28));
            this.jButtonProperties.setSize(new Dimension(28, 28));
            this.jButtonProperties.setMinimumSize(new Dimension(28, 28));
            this.jButtonProperties.setMaximumSize(new Dimension(28, 28));
            this.jButtonProperties.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/edit2.gif")));
            this.jButtonProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionProperties();
                }
            });
        }
        return this.jButtonProperties;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton();
            this.jButtonRemove.setFont(new Font("Dialog", 0, 12));
            this.jButtonRemove.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonRemove.setText("");
            this.jButtonRemove.setToolTipText("Remove");
            this.jButtonRemove.setMaximumSize(new Dimension(28, 28));
            this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/delete_edit.gif")));
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionRemove();
                }
            });
        }
        return this.jButtonRemove;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setOpaque(false);
            this.jPanel3.setMaximumSize(new Dimension(10, 10));
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setMaximumSize(new Dimension(10, 10));
            this.jPanel4.setOpaque(false);
        }
        return this.jPanel4;
    }

    protected void checkEnable() {
        Component tab = this.getJTabbedPane().getSelectedComponent();
        boolean enableCreate = false;
        boolean enableProps = false;
        boolean enableSetPass = false;
        boolean enableRemove = false;
        if (this.registry != null) {
            enableCreate = true;
            if (tab == this.getJPanelUsers()) {
                int[] sel = this.getJListUsers().getSelectedIndices();
                enableSetPass = enableProps = sel.length == 1;
                enableRemove = sel.length > 0;
            } else {
                int[] sel = this.getJListGroups().getSelectedIndices();
                enableProps = sel.length == 1;
                enableSetPass = false;
                enableRemove = sel.length > 0;
            }
        }
        this.getJTabbedPane().setEnabled(enableCreate);
        this.getJButtonCreateUser().setEnabled(enableCreate);
        this.getJButtonCreateGroup().setEnabled(enableCreate);
        this.getJButtonProperties().setEnabled(enableProps);
        this.getJButtonUserSetPass().setEnabled(enableSetPass);
        this.getJButtonRemove().setEnabled(enableRemove);
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setOpaque(false);
            this.jScrollPane2.setViewportView(this.getJListGroupMembers());
        }
        return this.jScrollPane2;
    }

    private JList getJListGroupMembers() {
        if (this.jListGroupMembers == null) {
            this.jListGroupMembers = new JList();
            this.jListGroupMembers.setOpaque(false);
            this.jListGroupMembers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    UserRegistryPanel.this.getJButtonGroupMemberRemove().setEnabled(UserRegistryPanel.this.getJListGroupMembers().getSelectedIndex() >= 0);
                }
            });
        }
        return this.jListGroupMembers;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 1;
            gridBagConstraints29.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints29.gridy = 0;
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 0;
            gridBagConstraints28.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints28.gridy = 0;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.anchor = 14;
            gridBagConstraints19.gridx = 2;
            gridBagConstraints19.gridy = -1;
            gridBagConstraints19.weighty = 0.0;
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.insets = new Insets(4, 4, 4, 4);
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.getJButtonGroupOk(), gridBagConstraints19);
            this.jPanel5.add((Component)this.getJButtonGroupMemberAdd(), gridBagConstraints28);
            this.jPanel5.add((Component)this.getJButtonGroupMemberRemove(), gridBagConstraints29);
        }
        return this.jPanel5;
    }

    private JButton getJButtonGroupMemberAdd() {
        if (this.jButtonGroupMemberAdd == null) {
            this.jButtonGroupMemberAdd = new JButton();
            this.jButtonGroupMemberAdd.setText("Add..");
            this.jButtonGroupMemberAdd.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonGroupMemberAdd.setFont(new Font("Dialog", 0, 12));
            this.jButtonGroupMemberAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionAddGroupMembers(UserRegistryPanel.this.editGroup);
                }
            });
        }
        return this.jButtonGroupMemberAdd;
    }

    private JButton getJButtonGroupMemberRemove() {
        if (this.jButtonGroupMemberRemove == null) {
            this.jButtonGroupMemberRemove = new JButton();
            this.jButtonGroupMemberRemove.setFont(new Font("Dialog", 0, 12));
            this.jButtonGroupMemberRemove.setText("Remove");
            this.jButtonGroupMemberRemove.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonGroupMemberRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionRemoveGroupMembers();
                }
            });
        }
        return this.jButtonGroupMemberRemove;
    }

    private JDialog getJDialogAddMember() {
        if (this.jDialogAddMember == null) {
            this.jDialogAddMember = new JDialog();
            this.jDialogAddMember.setTitle("Add Members");
            this.jDialogAddMember.setContentPane(this.getJPanel6());
        }
        return this.jDialogAddMember;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.fill = 2;
            gridBagConstraints39.gridx = 0;
            gridBagConstraints39.gridy = 4;
            gridBagConstraints39.weightx = 1.0;
            gridBagConstraints39.gridwidth = 2;
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.fill = 1;
            gridBagConstraints35.gridwidth = 2;
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.gridy = 3;
            gridBagConstraints35.weightx = 1.0;
            gridBagConstraints35.weighty = 1.0;
            gridBagConstraints35.insets = new Insets(4, 4, 0, 4);
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.anchor = 17;
            gridBagConstraints34.gridx = 0;
            gridBagConstraints34.gridy = 2;
            gridBagConstraints34.insets = new Insets(4, 4, 0, 4);
            this.jLabel12 = new JLabel();
            this.jLabel12.setText("Users / Groups:");
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new GridBagLayout());
            this.jPanel6.add((Component)this.jLabel12, gridBagConstraints34);
            this.jPanel6.add((Component)this.getJScrollPane3(), gridBagConstraints35);
            this.jPanel6.add((Component)this.getJPanel7(), gridBagConstraints39);
        }
        return this.jPanel6;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setOpaque(false);
            this.jScrollPane3.setViewportView(this.getJListAddMember());
        }
        return this.jScrollPane3;
    }

    private JList getJListAddMember() {
        if (this.jListAddMember == null) {
            this.jListAddMember = new JList();
            this.jListAddMember.setOpaque(false);
            this.jListAddMember.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    logger.fine("valueChanged()");
                }
            });
        }
        return this.jListAddMember;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.anchor = 14;
            gridBagConstraints36.gridx = 2;
            gridBagConstraints36.gridy = -1;
            gridBagConstraints36.weightx = 1.0;
            gridBagConstraints36.weighty = 0.0;
            gridBagConstraints36.insets = new Insets(4, 4, 4, 4);
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new GridBagLayout());
            this.jPanel7.add((Component)this.getJButtonAddMember(), gridBagConstraints36);
        }
        return this.jPanel7;
    }

    private JButton getJButtonAddMember() {
        if (this.jButtonAddMember == null) {
            this.jButtonAddMember = new JButton();
            this.jButtonAddMember.setText("Add");
            this.jButtonAddMember.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.dialogConfirm = true;
                    UserRegistryPanel.this.getJDialogAddMember().dispose();
                }
            });
        }
        return this.jButtonAddMember;
    }

    private JButton getJButtonOpenRegistry() {
        if (this.jButtonOpenRegistry == null) {
            this.jButtonOpenRegistry = new JButton();
            this.jButtonOpenRegistry.setToolTipText("Open user registry...");
            this.jButtonOpenRegistry.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/member/plugin/icons/redo_edit.gif")));
            this.jButtonOpenRegistry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserRegistryPanel.this.actionOpenRegistry();
                }
            });
        }
        return this.jButtonOpenRegistry;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel();
            this.jPanel8.setMaximumSize(new Dimension(10, 10));
            this.jPanel8.setOpaque(false);
        }
        return this.jPanel8;
    }

    protected void actionOpenRegistry() {
    }

    protected class UserGroupListCellRenderer
    extends AbstractCellRenderer
    implements ListCellRenderer {
        private static final long serialVersionUID = -6699188468103097096L;
        private JLabel label = new JLabel();

        public UserGroupListCellRenderer() {
            this.setLayout(new GridLayout(1, 1));
            this.add(this.label);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Group group;
            User user;
            this.setSelected(isSelected);
            this.setFocus(cellHasFocus);
            String text = String.valueOf(value);
            Icon icon = null;
            if (value instanceof User && (user = (User)value) != null) {
                text = String.valueOf(user.getName());
                icon = UserRegistryPanel.this.iconUser;
            }
            if (value instanceof Group && (group = (Group)value) != null) {
                text = String.valueOf(group.getName());
                icon = UserRegistryPanel.this.iconGroup;
            }
            this.label.setText(text);
            this.label.setIcon(icon);
            return this;
        }
    }
}

