/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractBlock;
import com.spacekiller.util.heap.AbstractHeapManager;
import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.Block;
import com.spacekiller.util.heap.Frag;
import com.spacekiller.util.heap.HeapSummary;
import com.spacekiller.util.lock.ReadWriteLock;
import java.io.IOException;

public abstract class AbstractArea
implements Area {
    protected final Object PAGE_LOCK = new Object();
    protected final Object BLOCK_LOCK = new Object();
    protected final AbstractHeapManager manager;
    protected final AbstractArea parent;
    protected String name;
    protected int pageSize;
    protected volatile long size;
    protected volatile long pages;
    protected AbstractPage first;
    protected AbstractPage last;
    protected volatile long free;
    protected volatile long blocks;
    protected AbstractBlock oldest;
    protected AbstractBlock newest;

    public AbstractArea(String name, AbstractHeapManager manager, AbstractArea parent, int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize");
        }
        if (manager == null) {
            throw new IllegalArgumentException("manager is null");
        }
        this.manager = manager;
        this.parent = parent;
        this.name = name;
        this.pageSize = pageSize;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long free() {
        return this.free;
    }

    protected abstract AbstractPage createPage(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removePage(AbstractPage page) throws IOException {
        int pSize;
        if (page.area != this) {
            throw new IllegalArgumentException("Invalid page: " + page);
        }
        Object object = this.PAGE_LOCK;
        synchronized (object) {
            pSize = page.size;
            if (pSize < 1) {
                throw new IllegalArgumentException("Invalid page: " + page);
            }
            if (page.prev == null ? this.first != page : page.prev.next != page) {
                throw new IllegalArgumentException("Invalid page: " + page);
            }
            if (page.next == null ? this.last != page : page.next.prev != page) {
                throw new IllegalArgumentException("Invalid page: " + page);
            }
            if (page.prev == null) {
                this.first = page.next;
            } else {
                page.prev.next = page.next;
            }
            if (page.next == null) {
                this.last = page.prev;
            } else {
                page.next.prev = page.prev;
            }
            page.prev = null;
            page.next = null;
            this.size -= (long)pSize;
            --this.pages;
        }
        object = this.BLOCK_LOCK;
        synchronized (object) {
            this.free -= (long)pSize;
        }
        this.discardPage(page);
        return true;
    }

    protected abstract void discardPage(AbstractPage var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long removeEmptyPages(long amount, boolean force) throws IOException {
        long doneSize = 0L;
        Object object = this.PAGE_LOCK;
        synchronized (object) {
            AbstractPage p = this.last;
            while (p != null) {
                int pSize;
                AbstractPage prev = p.prev;
                Frag frag = p.first;
                if (frag != null && frag.off == 0 && frag.end == (pSize = p.size) && p.last == frag) {
                    this.removePage(p);
                    doneSize += (long)pSize;
                    if ((amount -= (long)pSize) <= 0L && !force) break;
                }
                p = prev;
            }
        }
        return doneSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long evacuateOldBlocks(long amount, boolean force) throws IOException {
        if (this.parent == null) {
            return -1L;
        }
        long doneSize = 0L;
        ReadWriteLock lock = null;
        while (amount > 0L || force) {
            AbstractBlock old;
            Object object = this.BLOCK_LOCK;
            synchronized (object) {
                old = this.oldest;
                while (old != null && !(lock = old.getLock()).tryLockWrite()) {
                    old = old.next;
                }
            }
            if (old == null) break;
            try {
                int oldSize = old.size;
                this.parent.allocate(old, oldSize);
                doneSize += (long)oldSize;
                amount -= (long)oldSize;
            }
            finally {
                lock.unlockWrite();
            }
        }
        return doneSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long prepareNewPages(long amount) throws IOException {
        AbstractPage p;
        long doneSize = 0L;
        while (amount > 0L && (p = this.createPage(this.pageSize)) != null) {
            int pSize = p.size;
            Object object = this.PAGE_LOCK;
            synchronized (object) {
                if (this.last == null) {
                    this.first = p;
                    this.last = p;
                } else {
                    p.prev = this.last;
                    this.last.next = p;
                    this.last = p;
                }
                this.size += (long)pSize;
                ++this.pages;
            }
            object = this.BLOCK_LOCK;
            synchronized (object) {
                this.free += (long)pSize;
            }
            doneSize += (long)pSize;
            amount -= (long)pSize;
        }
        return doneSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frag allocate(Block blk, int len) throws IOException {
        if (len > this.pageSize) {
            throw new IOException("Invalid block size: " + len + " > " + this.pageSize);
        }
        AbstractBlock block = (AbstractBlock)blk;
        AbstractPage p = block.page;
        if (p != null && p.area == this) {
            int old = block.size;
            if (len == old) {
                return null;
            }
            if (len < old) {
                int n = old - len;
                Frag frag = p.free(block.ofs + len, n);
                block.size = len;
                Object object = this.BLOCK_LOCK;
                synchronized (object) {
                    this.free += (long)n;
                }
                return frag;
            }
        }
        int o = -1;
        Object n = this.PAGE_LOCK;
        synchronized (n) {
            p = this.last;
            while (p != null && (o = p.alloc(len)) < 0) {
                p = p.prev;
            }
        }
        if (o >= 0) {
            return this.alloc(block, p, o, len);
        }
        p = this.createPage(this.pageSize);
        if (p != null) {
            int pSize = p.size;
            Object frag = this.PAGE_LOCK;
            synchronized (frag) {
                if (this.last == null) {
                    this.first = p;
                    this.last = p;
                } else {
                    p.prev = this.last;
                    this.last.next = p;
                    this.last = p;
                }
                this.size += (long)pSize;
                ++this.pages;
                o = p.alloc(len);
            }
            frag = this.BLOCK_LOCK;
            synchronized (frag) {
                this.free += (long)pSize;
            }
            if (o >= 0) {
                return this.alloc(block, p, o, len);
            }
        }
        if (this.parent == null) {
            throw new IOException("No space available for block: len=" + len);
        }
        ReadWriteLock lock = null;
        while (true) {
            AbstractBlock old;
            Object object = this.BLOCK_LOCK;
            synchronized (object) {
                old = this.oldest;
                while (old != null && !(lock = old.getLock()).tryLockWrite()) {
                    old = old.next;
                }
            }
            if (old == null) {
                System.out.println("TODO wait for other swap operation...");
                throw new UnsupportedOperationException("TODO wait.. swap!");
            }
            try {
                p = old.page;
                Frag frag = this.parent.allocate(old, old.size);
                if (frag == null || frag.size() < len || (o = p.alloc(len)) < 0) continue;
                object = this.alloc(block, p, o, len);
                return object;
            }
            finally {
                lock.unlockWrite();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Frag alloc(AbstractBlock block, AbstractPage page, int off, int len) throws IOException {
        int num;
        Frag frag = null;
        AbstractPage p = block.page;
        if (p != null && (num = p.size) > 0) {
            page.put(off, p, block.ofs, Math.min(num, len));
            frag = p.area.release(block);
        }
        block.page = page;
        block.ofs = off;
        block.size = len;
        block.next = null;
        Object object = this.BLOCK_LOCK;
        synchronized (object) {
            if (this.newest == null) {
                block.prev = null;
                this.newest = block;
                this.oldest = block;
            } else {
                block.prev = this.newest;
                this.newest.next = block;
                this.newest = block;
            }
            this.free -= (long)len;
            ++this.blocks;
        }
        return frag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frag release(Block blk) {
        AbstractBlock block = (AbstractBlock)blk;
        AbstractPage page = block.page;
        if (page.area != this) {
            throw new IllegalArgumentException("Invalid block: " + block);
        }
        block.page = null;
        int off = block.ofs;
        int len = block.size;
        Frag frag = page.free(off, len);
        Object object = this.BLOCK_LOCK;
        synchronized (object) {
            if (block.prev == null) {
                this.oldest = block.next;
            } else {
                block.prev.next = block.next;
            }
            if (block.next == null) {
                this.newest = block.prev;
            } else {
                block.next.prev = block.prev;
            }
            this.free += (long)len;
            --this.blocks;
        }
        if (frag.size() >= this.pageSize) {
            this.manager.notifyEmptyPage(page);
        }
        return frag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() throws IOException {
        long areaSize = 0L;
        Object object = this.PAGE_LOCK;
        synchronized (object) {
            AbstractPage prev = null;
            AbstractPage page = this.first;
            while (page != null) {
                areaSize += (long)page.size();
                if (page.prev != prev) {
                    throw new IOException("Invalid prev page: page=" + page + ", prev=" + page.prev + " != " + prev);
                }
                page.check();
                prev = page;
                page = page.next;
            }
            if (this.last != prev) {
                throw new IOException("Invalid last page: " + this.last + " != " + prev);
            }
            if (this.size != areaSize) {
                throw new IOException("Invalid area size: " + this.size + " != " + areaSize);
            }
        }
        long blockSize = 0L;
        Object object2 = this.BLOCK_LOCK;
        synchronized (object2) {
            AbstractBlock prev = null;
            AbstractBlock block = this.oldest;
            while (block != null) {
                blockSize += (long)block.size();
                if (block.prev != prev) {
                    throw new IOException("Invalid prev block: block=" + block + ", prev=" + block.prev + " != " + prev);
                }
                prev = block;
                block = block.next;
            }
            if (this.newest != prev) {
                throw new IOException("Invalid newest block: " + this.newest + " != " + prev);
            }
            long expectedFree = areaSize - blockSize;
            if (this.free != expectedFree) {
                throw new IOException("Invalid free space: " + this.free + " != " + expectedFree);
            }
        }
        if (this.parent != null) {
            this.parent.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(StringBuffer sb, boolean dumpPages, boolean dumpBlocks) {
        Object object;
        sb.append("Area: " + this).append('\n');
        if (dumpPages) {
            object = this.PAGE_LOCK;
            synchronized (object) {
                AbstractPage page = this.first;
                while (page != null) {
                    sb.append(" - Page: " + page).append('\n');
                    page.dump(sb);
                    page = page.next;
                }
            }
        }
        if (dumpBlocks) {
            object = this.BLOCK_LOCK;
            synchronized (object) {
                AbstractBlock block = this.oldest;
                while (block != null) {
                    sb.append(" - Block: ofs=" + block.ofs + ", len=" + block.size + ", page=" + block.page + ", block=" + block).append('\n');
                    block = block.next;
                }
            }
        }
        if (this.parent != null) {
            this.parent.dump(sb, dumpPages, dumpBlocks);
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", free=" + this.free() + ", size=" + this.size() + ", limit=" + this.limit() + "]";
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    protected void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected long getPageCount() {
        return this.pages;
    }

    protected long getBlockCount() {
        return this.blocks;
    }

    protected final AbstractArea getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HeapSummary getHeapSummary(HeapSummary summary) {
        long limit;
        if (summary == null) {
            summary = new HeapSummary();
        }
        summary.limit = limit = this.limit();
        Object object = this.PAGE_LOCK;
        synchronized (object) {
            summary.size = this.size;
            summary.pages = this.pages;
        }
        object = this.BLOCK_LOCK;
        synchronized (object) {
            summary.free = this.free;
            summary.blocks = this.blocks;
        }
        return summary;
    }
}

