/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferPage
extends AbstractPage {
    protected final byte[] cb;
    protected final ByteBuffer b;

    public ByteBufferPage(Area area, ByteBuffer buffer, byte[] copyBuf) {
        super(area, buffer.limit());
        this.b = buffer;
        this.cb = copyBuf;
    }

    public final ByteBuffer getBuffer() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, byte[] arr, int ofs, int len) {
        ByteBuffer byteBuffer = this.b;
        synchronized (byteBuffer) {
            this.b.position(off);
            this.b.get(arr, ofs, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int off, byte[] arr, int ofs, int len) {
        ByteBuffer byteBuffer = this.b;
        synchronized (byteBuffer) {
            this.b.position(off);
            this.b.put(arr, ofs, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, ByteBuffer buf) {
        int len = buf.remaining();
        ByteBuffer byteBuffer = this.b;
        synchronized (byteBuffer) {
            try {
                this.b.position(off);
                this.b.limit(off + len);
                buf.put(this.b);
            }
            finally {
                this.b.limit(this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int off, ByteBuffer buf) {
        ByteBuffer byteBuffer = this.b;
        synchronized (byteBuffer) {
            this.b.position(off);
            this.b.put(buf);
        }
    }

    @Override
    public void read(int off, OutputStream dst, int len) throws IOException {
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            ByteBuffer byteBuffer = this.b;
            synchronized (byteBuffer) {
                this.b.position(off);
                while (true) {
                    int n = Math.min(len, this.cb.length);
                    this.b.get(this.cb, 0, n);
                    dst.write(this.cb, 0, n);
                    if (n >= len) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 6, 7] lbl15 : MonitorExitStatement: MONITOREXIT : var6_5
                        // ** MonitorExit[var5_4] (shouldn't be in output)
                        return;
                    }
                    len -= n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int off, InputStream src, int len) throws IOException {
        int n = Math.min(len, this.cb.length);
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            n = src.read(this.cb, 0, n);
            if (n < 1) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return n == 0 ? 0 : -1;
            }
            ByteBuffer byteBuffer = this.b;
            synchronized (byteBuffer) {
                this.b.position(off);
                this.b.put(this.cb, 0, n);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(int off, Page dst, int ofs, int len) throws IOException {
        if (dst == this) {
            this.move(off, ofs, len);
            return;
        }
        ByteBuffer byteBuffer = this.b;
        synchronized (byteBuffer) {
            try {
                this.b.position(off);
                this.b.limit(off + len);
                dst.write(ofs, this.b);
            }
            finally {
                this.b.limit(this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int off, Page src, int ofs, int len) throws IOException {
        if (src == this) {
            this.move(ofs, off, len);
            return;
        }
        ByteBuffer byteBuffer = this.b;
        synchronized (byteBuffer) {
            try {
                this.b.position(off);
                this.b.limit(off + len);
                src.read(ofs, this.b);
            }
            finally {
                this.b.limit(this.size);
            }
        }
    }

    protected void move(int src, int dst, int len) {
        ByteBuffer b = this.b;
        if (src > dst) {
            int z = src + len;
            while (src < z) {
                b.put(dst++, b.get(src++));
            }
        } else {
            int z = src;
            src += len;
            dst += len;
            while (src > z) {
                b.put(--dst, b.get(--src));
            }
        }
    }

    @Override
    protected void dispose() throws IOException {
    }
}

