/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AreaInfo;
import com.spacekiller.util.heap.HeapSummary;
import java.lang.ref.Reference;

public class DefaultAreaInfo
implements AreaInfo {
    private String name;
    private Reference areaRef;

    DefaultAreaInfo(String name, Reference areaRef) {
        this.name = name;
        this.areaRef = areaRef;
    }

    private AbstractArea getArea() {
        return (AbstractArea)this.areaRef.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long size() {
        AbstractArea area = this.getArea();
        if (area == null) {
            return -1L;
        }
        return area.size();
    }

    @Override
    public long limit() {
        AbstractArea area = this.getArea();
        if (area == null) {
            return -1L;
        }
        return area.limit();
    }

    @Override
    public long free() {
        AbstractArea area = this.getArea();
        if (area == null) {
            return -1L;
        }
        return area.free();
    }

    @Override
    public int getPageSize() {
        AbstractArea area = this.getArea();
        if (area == null) {
            return -1;
        }
        return area.getPageSize();
    }

    @Override
    public long getPageCount() {
        AbstractArea area = this.getArea();
        if (area == null) {
            return 0L;
        }
        return area.getPageCount();
    }

    @Override
    public long getBlockCount() {
        AbstractArea area = this.getArea();
        if (area == null) {
            return 0L;
        }
        return area.getBlockCount();
    }

    @Override
    public HeapSummary getHeapSummary(HeapSummary summary) {
        AbstractArea area = this.getArea();
        if (area == null) {
            return null;
        }
        return area.getHeapSummary(summary);
    }
}

