/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractBlock;
import com.spacekiller.util.lock.ReadWriteLock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class DefaultBlock
extends AbstractBlock {
    protected final ReadWriteLock lock;

    protected DefaultBlock(int size, ReadWriteLock lock) {
        super(size);
        this.lock = lock;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lockWrite();
        try {
            if (this.page != null) {
                this.page.area.release(this);
            }
        }
        finally {
            this.page = null;
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resize(int newSize) throws IOException {
        if (newSize < 1) {
            throw new IOException("Invalid block size: " + newSize);
        }
        this.lock.lockWrite();
        try {
            if (newSize == this.size) {
                return;
            }
            this.page.area.allocate(this, newSize);
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, byte[] dst, int ofs, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        this.lock.lockRead();
        try {
            if (off + len > this.size) {
                throw new ArrayIndexOutOfBoundsException(off + len);
            }
            this.page.read(this.ofs + off, dst, ofs, len);
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int off, byte[] src, int ofs, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        this.lock.lockRead();
        try {
            if (off + len > this.size) {
                throw new ArrayIndexOutOfBoundsException(off + len);
            }
            this.page.write(this.ofs + off, src, ofs, len);
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, ByteBuffer dst) throws IOException {
        int len = dst.remaining();
        if (len < 1) {
            return;
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        this.lock.lockRead();
        try {
            if (off + len > this.size) {
                throw new ArrayIndexOutOfBoundsException(off + len);
            }
            this.page.read(this.ofs + off, dst);
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int off, ByteBuffer src) throws IOException {
        int len = src.remaining();
        if (len < 1) {
            return;
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        this.lock.lockRead();
        try {
            if (off + len > this.size) {
                throw new ArrayIndexOutOfBoundsException(off + len);
            }
            this.page.write(this.ofs + off, src);
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int off, OutputStream dst, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        this.lock.lockRead();
        try {
            if (off + len > this.size) {
                throw new ArrayIndexOutOfBoundsException(off + len);
            }
            this.page.read(this.ofs + off, dst, len);
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int off, InputStream src, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        this.lock.lockRead();
        try {
            if (off + len > this.size) {
                throw new ArrayIndexOutOfBoundsException(off + len);
            }
            int n = this.page.write(this.ofs + off, src, len);
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }
}

