/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AbstractHeap;
import com.spacekiller.util.heap.AreaInfo;
import com.spacekiller.util.heap.HeapInfo;
import com.spacekiller.util.heap.HeapSummary;
import java.lang.ref.Reference;

public class DefaultHeapInfo
implements HeapInfo {
    private String name;
    private Reference heapRef;
    private AreaInfo[] areaInfos;

    DefaultHeapInfo(String name, Reference heapRef, AreaInfo[] areaInfos) {
        this.name = name;
        this.heapRef = heapRef;
        this.areaInfos = areaInfos;
    }

    final AbstractHeap getHeap() {
        return (AbstractHeap)this.heapRef.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AreaInfo[] getAreaInfo() {
        AreaInfo[] arr = this.areaInfos;
        if (arr == null) {
            return null;
        }
        int num = arr.length;
        AreaInfo[] copy = new AreaInfo[num];
        System.arraycopy(arr, 0, copy, 0, num);
        return copy;
    }

    @Override
    public long limit() {
        AbstractHeap heap = this.getHeap();
        if (heap == null) {
            return -1L;
        }
        long totalLimit = 0L;
        AbstractArea area = heap.area;
        while (area != null) {
            long limit = area.limit();
            if (limit < 0L) {
                totalLimit = -1L;
                break;
            }
            totalLimit += limit;
            area = area.parent;
        }
        return totalLimit;
    }

    @Override
    public long size() {
        AbstractHeap heap = this.getHeap();
        if (heap == null) {
            return -1L;
        }
        long totalSize = 0L;
        AbstractArea area = heap.area;
        while (area != null) {
            long size = area.size;
            if (size > 0L) {
                totalSize += size;
            }
            area = area.parent;
        }
        return totalSize;
    }

    @Override
    public long free() {
        AbstractHeap heap = this.getHeap();
        if (heap == null) {
            return -1L;
        }
        long totalFree = 0L;
        AbstractArea area = heap.area;
        while (area != null) {
            long free = area.free;
            if (free > 0L) {
                totalFree += free;
            }
            area = area.parent;
        }
        return totalFree;
    }

    @Override
    public HeapSummary getHeapSummary(HeapSummary summary) {
        AbstractHeap heap = this.getHeap();
        if (heap == null) {
            return null;
        }
        long totalLimit = 0L;
        long totalSize = 0L;
        long totalFree = 0L;
        AbstractArea area = heap.area;
        while (area != null) {
            long val = area.limit();
            if (val < 0L) {
                totalLimit = -1L;
            } else if (totalLimit >= 0L) {
                totalLimit += val;
            }
            val = area.size;
            if (val > 0L) {
                totalSize += val;
            }
            if ((val = area.free) > 0L) {
                totalFree += val;
            }
            area = area.parent;
        }
        summary.limit = totalLimit;
        summary.size = totalSize;
        summary.free = totalFree;
        return summary;
    }
}

