/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AbstractHeap;
import com.spacekiller.util.heap.AbstractHeapManager;
import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.AreaConfig;
import com.spacekiller.util.heap.AreaInfo;
import com.spacekiller.util.heap.AreaOptimizer;
import com.spacekiller.util.heap.DefaultAreaInfo;
import com.spacekiller.util.heap.DefaultAreaOptimizer;
import com.spacekiller.util.heap.DefaultHeap;
import com.spacekiller.util.heap.DefaultHeapInfo;
import com.spacekiller.util.heap.HeapConfig;
import com.spacekiller.util.heap.HeapInfo;
import com.spacekiller.util.heap.HeapOptimizer;
import com.spacekiller.util.heap.ManagedHeap;
import com.spacekiller.util.heap.MemoryArea;
import com.spacekiller.util.heap.SwapFileArea;
import com.spacekiller.util.lock.LockFactory;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultHeapManager
extends AbstractHeapManager {
    protected final HeapOptimizer heapOptimizer;
    protected final LockFactory lockFactory;
    protected final boolean useFairLockingSupport;
    protected final boolean useJnaMemory;
    protected final boolean useUnsafeDirectMemory;
    private final List heapInfoList;
    private final EventListenerList changeListeners;
    private final FireChangeEventLater fireChangeEventLater = new FireChangeEventLater();

    public DefaultHeapManager(HeapOptimizer heapOptimizer, LockFactory lockFactory, boolean useFairLockingSupport, boolean useJnaMemory, boolean useUnsafeDirectMemory) {
        this.heapOptimizer = heapOptimizer;
        this.lockFactory = lockFactory;
        this.useFairLockingSupport = useFairLockingSupport;
        this.useJnaMemory = useJnaMemory;
        this.useUnsafeDirectMemory = useUnsafeDirectMemory;
        this.heapInfoList = new ArrayList();
        this.changeListeners = new EventListenerList();
    }

    @Override
    public ManagedHeap createHeap(HeapConfig config) throws IOException {
        AreaOptimizer optimizer;
        String areaName;
        int defaultPageSize;
        if (config == null) {
            throw new IOException("Invalid heap config: " + config);
        }
        String heapName = config.getName();
        if (heapName != null) {
            heapName = heapName.trim();
        }
        if (heapName == null || heapName.length() < 1) {
            heapName = "Heap";
        }
        AreaConfig javaHeapAreaConfig = config.getJavaHeapAreaConfig();
        long maxJavaHeapSize = 0L;
        if (javaHeapAreaConfig != null && javaHeapAreaConfig.isAreaEnabled()) {
            maxJavaHeapSize = javaHeapAreaConfig.getMaxAreaSize();
        }
        AreaConfig directHeapAreaConfig = config.getDirectHeapAreaConfig();
        long maxDirectHeapSize = 0L;
        if (directHeapAreaConfig != null && directHeapAreaConfig.isAreaEnabled()) {
            maxDirectHeapSize = directHeapAreaConfig.getMaxAreaSize();
        }
        AreaConfig swapFileAreaConfig = config.getSwapFileAreaConfig();
        long maxSwapFileSize = 0L;
        if (swapFileAreaConfig != null && swapFileAreaConfig.isAreaEnabled() && (maxSwapFileSize = swapFileAreaConfig.getMaxAreaSize()) < 1L) {
            maxSwapFileSize = Long.MAX_VALUE;
        }
        if ((defaultPageSize = config.getDefaultPageSize()) < 1) {
            throw new IOException("Invalid default page size: " + defaultPageSize);
        }
        AbstractArea primaryArea = null;
        LinkedList<AreaOptimizer> areaOptimizerList = new LinkedList<AreaOptimizer>();
        byte[] copyBuf = null;
        if (maxSwapFileSize > 0L) {
            String areaName2 = swapFileAreaConfig.getName();
            if (areaName2 == null || areaName2.length() < 1) {
                areaName2 = "SwapFileArea";
            }
            String filePrefix = heapName + "-" + areaName2 + "-";
            String fileSuffix = ".tmp";
            int normalPageSize = swapFileAreaConfig.getNormalPageSize();
            if (normalPageSize < 1) {
                normalPageSize = defaultPageSize;
            }
            if (copyBuf == null || copyBuf.length < normalPageSize) {
                copyBuf = new byte[normalPageSize];
            }
            SwapFileArea swapFileArea = new SwapFileArea(areaName2, this, primaryArea, normalPageSize, maxSwapFileSize, filePrefix, fileSuffix, copyBuf);
            primaryArea = swapFileArea;
            AreaOptimizer optimizer2 = this.createAreaOptimizer(swapFileArea, swapFileAreaConfig);
            if (optimizer2 != null) {
                areaOptimizerList.add(0, optimizer2);
            }
        }
        boolean javaHeapPreferred = config.isJavaHeapPreferred();
        if (maxDirectHeapSize > 0L) {
            if (maxJavaHeapSize > 0L && !javaHeapPreferred) {
                MemoryArea mixedHeapArea;
                int normalPageSize;
                areaName = javaHeapAreaConfig.getName();
                if (areaName == null || areaName.length() < 1) {
                    areaName = "MixedHeapArea";
                }
                if ((normalPageSize = javaHeapAreaConfig.getNormalPageSize()) < 1 && (normalPageSize = directHeapAreaConfig.getNormalPageSize()) < 1) {
                    normalPageSize = defaultPageSize;
                }
                if (copyBuf == null || copyBuf.length < normalPageSize) {
                    copyBuf = new byte[normalPageSize];
                }
                primaryArea = mixedHeapArea = new MemoryArea(areaName, this, primaryArea, normalPageSize, maxJavaHeapSize, maxDirectHeapSize, copyBuf, this.useJnaMemory, this.useUnsafeDirectMemory);
                maxJavaHeapSize = 0L;
                optimizer = this.createAreaOptimizer(mixedHeapArea, javaHeapAreaConfig);
                if (optimizer != null) {
                    areaOptimizerList.add(0, optimizer);
                }
            } else {
                MemoryArea directHeapArea;
                int normalPageSize;
                areaName = directHeapAreaConfig.getName();
                if (areaName == null || areaName.length() < 1) {
                    areaName = "DirectHeapArea";
                }
                if ((normalPageSize = directHeapAreaConfig.getNormalPageSize()) < 1) {
                    normalPageSize = defaultPageSize;
                }
                if (copyBuf == null || copyBuf.length < normalPageSize) {
                    copyBuf = new byte[normalPageSize];
                }
                primaryArea = directHeapArea = new MemoryArea(areaName, this, primaryArea, normalPageSize, 0L, maxDirectHeapSize, copyBuf, this.useJnaMemory, this.useUnsafeDirectMemory);
                optimizer = this.createAreaOptimizer(directHeapArea, directHeapAreaConfig);
                if (optimizer != null) {
                    areaOptimizerList.add(0, optimizer);
                }
            }
        }
        if (maxJavaHeapSize > 0L) {
            MemoryArea javaHeapArea;
            int normalPageSize;
            areaName = javaHeapAreaConfig.getName();
            if (areaName == null || areaName.length() < 1) {
                areaName = "JavaHeapArea";
            }
            if ((normalPageSize = javaHeapAreaConfig.getNormalPageSize()) < 1) {
                normalPageSize = defaultPageSize;
            }
            if (copyBuf == null || copyBuf.length < normalPageSize) {
                copyBuf = new byte[normalPageSize];
            }
            primaryArea = javaHeapArea = new MemoryArea(areaName, this, primaryArea, normalPageSize, maxJavaHeapSize, 0L, copyBuf, this.useJnaMemory, this.useUnsafeDirectMemory);
            optimizer = this.createAreaOptimizer(javaHeapArea, javaHeapAreaConfig);
            if (optimizer != null) {
                areaOptimizerList.add(0, optimizer);
            }
        }
        if (primaryArea == null) {
            throw new IOException("Invalid heap config: No area available: maxJavaHeapSize=" + maxJavaHeapSize + ", maxDirectHeapSize=" + maxDirectHeapSize + ", maxSwapFileSize=" + maxSwapFileSize);
        }
        AreaOptimizer[] areaOptimizers = areaOptimizerList.toArray(new AreaOptimizer[areaOptimizerList.size()]);
        return this.createHeap(heapName, primaryArea, areaOptimizers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedHeap createHeap(String name, Area area, AreaOptimizer[] areaOptimizers) throws IOException {
        HeapOptimizer optimizer;
        AbstractArea theArea = null;
        if (area != null && area instanceof AbstractArea) {
            theArea = (AbstractArea)area;
        }
        if (theArea == null) {
            throw new IllegalArgumentException("Invalid or unsupported Area: " + area);
        }
        DefaultHeap theHeap = new DefaultHeap(name, theArea, this.lockFactory, this.useFairLockingSupport, this);
        HeapInfo heapInfo = this.createHeapInfo(name, theHeap);
        if (heapInfo != null) {
            List list = this.heapInfoList;
            synchronized (list) {
                this.heapInfoList.add(heapInfo);
            }
        }
        if ((optimizer = this.heapOptimizer) != null) {
            optimizer.heapCreated(theHeap, areaOptimizers);
        }
        this.fireChangeEventLater();
        return theHeap;
    }

    protected AreaOptimizer createAreaOptimizer(AbstractArea area, AreaConfig config) {
        long maxBytesPerCycle;
        double maxFreeFactor;
        double minFreeFactor = config.getMinFreeFactor();
        if (minFreeFactor < 0.0) {
            minFreeFactor = 0.0;
        }
        if ((maxFreeFactor = config.getMaxFreeFactor()) < 0.0) {
            maxFreeFactor = 1.0;
        }
        if (maxFreeFactor > 1.0) {
            maxFreeFactor = 1.0;
        }
        if ((maxBytesPerCycle = config.getMaxBytesPerCycle()) < 1L && (maxBytesPerCycle = (long)config.getNormalPageSize()) < 1L) {
            maxBytesPerCycle = Long.MAX_VALUE;
        }
        DefaultAreaOptimizer optimizer = new DefaultAreaOptimizer(area);
        optimizer.setMinFreeFactor(minFreeFactor);
        optimizer.setMaxFreeFactor(maxFreeFactor);
        optimizer.setMaxBytesPerCycle(maxBytesPerCycle);
        return optimizer;
    }

    @Override
    public void checkHeap(ManagedHeap heap) throws IOException {
        DefaultHeap def = (DefaultHeap)heap;
        AbstractArea area = def.area;
        if (area != null) {
            area.check();
        }
    }

    @Override
    public void dumpHeap(ManagedHeap heap, StringBuffer sb, boolean dumpPages, boolean dumpBlocks) {
        sb.append("Heap: " + heap).append('\n');
        DefaultHeap def = (DefaultHeap)heap;
        AbstractArea area = def.area;
        if (area != null) {
            area.dump(sb, dumpPages, dumpBlocks);
        }
    }

    @Override
    public HeapInfo getHeapInfo(ManagedHeap heap) {
        if (heap == null) {
            return null;
        }
        HeapInfo[] infos = this.getHeapInfo();
        if (infos == null) {
            return null;
        }
        for (HeapInfo info : infos) {
            DefaultHeapInfo defInfo;
            if (info == null || !(info instanceof DefaultHeapInfo) || heap != (defInfo = (DefaultHeapInfo)info).getHeap()) continue;
            return defInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HeapInfo[] getHeapInfo() {
        HeapInfo[] infos;
        List list = this.heapInfoList;
        synchronized (list) {
            infos = this.heapInfoList.toArray(new HeapInfo[this.heapInfoList.size()]);
        }
        return infos;
    }

    protected HeapInfo createHeapInfo(String name, AbstractHeap heap) {
        LinkedList<AreaInfo> areaInfoList = new LinkedList<AreaInfo>();
        AbstractArea area = heap.area;
        while (area != null) {
            String areaName = area.getName();
            AreaInfo areaInfo = this.createAreaInfo(areaName, area);
            if (areaInfo != null) {
                areaInfoList.add(areaInfo);
            }
            area = area.parent;
        }
        AreaInfo[] areaInfos = areaInfoList.toArray(new AreaInfo[areaInfoList.size()]);
        ReferenceQueue refQueue = null;
        WeakReference<AbstractHeap> weakHeapRef = new WeakReference<AbstractHeap>(heap, refQueue);
        DefaultHeapInfo heapInfo = new DefaultHeapInfo(name, weakHeapRef, areaInfos);
        return heapInfo;
    }

    protected AreaInfo createAreaInfo(String name, AbstractArea area) {
        ReferenceQueue refQueue = null;
        WeakReference<AbstractArea> weakAreaRef = new WeakReference<AbstractArea>(area, refQueue);
        DefaultAreaInfo areaInfo = new DefaultAreaInfo(name, weakAreaRef);
        return areaInfo;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(ChangeListener.class, listener);
    }

    protected void fireChangeEventLater() {
        Object[] list = this.changeListeners.getListenerList();
        if (list.length > 0) {
            SwingUtilities.invokeLater(this.fireChangeEventLater);
        }
    }

    protected void fireChangeEvent() {
        Object[] list = this.changeListeners.getListenerList();
        if (list.length > 0) {
            for (int i = 1; i < list.length; i += 2) {
                Object listener = list[i];
                if (listener == null || !(listener instanceof ChangeListener)) continue;
                ChangeListener changeListener = (ChangeListener)listener;
                changeListener.stateChanged(new ChangeEvent(changeListener));
            }
        }
    }

    @Override
    protected void notifyEmptyPage(AbstractPage page) {
        HeapOptimizer optimizer = this.heapOptimizer;
        if (optimizer != null) {
            optimizer.emptyPageDetected(page);
        }
    }

    protected class FireChangeEventLater
    implements Runnable {
        protected FireChangeEventLater() {
        }

        @Override
        public void run() {
            DefaultHeapManager.this.fireChangeEvent();
        }
    }
}

