/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AbstractHeapManager;
import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.ByteArrayPage;
import com.spacekiller.util.heap.ByteBufferPage;
import com.spacekiller.util.heap.SupportJnaMemory;
import com.spacekiller.util.heap.SupportUnsafePage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryArea
extends AbstractArea {
    private static final Logger logger = Logger.getLogger(MemoryArea.class.getName());
    protected final long maxJavaHeapSize;
    protected final long maxDirectHeapSize;
    protected final long maxHeapSize;
    private long javaHeapSize;
    private long directHeapSize;
    protected byte[] cb;
    private boolean useJnaMemory;
    private boolean useUnsafeDirectMemory;

    public MemoryArea(String name, AbstractHeapManager manager, AbstractArea parent, int pageSize, long maxJavaHeapSize, long maxDirectHeapSize, byte[] copyBuf, boolean useJnaMemory, boolean useUnsafeDirectMemory) {
        super(name, manager, parent, pageSize);
        if (maxJavaHeapSize < 0L) {
            maxJavaHeapSize = 0L;
        }
        if (maxDirectHeapSize < 0L) {
            maxDirectHeapSize = 0L;
        }
        this.maxJavaHeapSize = maxJavaHeapSize;
        this.maxDirectHeapSize = maxDirectHeapSize;
        this.maxHeapSize = maxJavaHeapSize + maxDirectHeapSize;
        this.cb = copyBuf;
        this.useJnaMemory = useJnaMemory;
        this.useUnsafeDirectMemory = useUnsafeDirectMemory;
    }

    @Override
    public long limit() {
        return this.maxHeapSize;
    }

    @Override
    protected synchronized void discardPage(AbstractPage page) throws IOException {
        if (page.area != this) {
            throw new IllegalArgumentException("Invalid page: " + page);
        }
        int pageSize = page.size;
        if (pageSize < 1) {
            return;
        }
        page.dispose();
        if (page instanceof ByteArrayPage) {
            byte[] arr;
            ByteArrayPage byteArrayPage = (ByteArrayPage)page;
            this.javaHeapSize -= (long)pageSize;
            if (this.javaHeapSize < 0L) {
                this.javaHeapSize = 0L;
            }
            if ((arr = byteArrayPage.b) != null) {
                // empty if block
            }
            return;
        }
        if (page instanceof ByteBufferPage) {
            this.directHeapSize -= (long)pageSize;
            if (this.directHeapSize < 0L) {
                this.directHeapSize = 0L;
            }
            return;
        }
        this.directHeapSize -= (long)pageSize;
        if (this.directHeapSize < 0L) {
            this.directHeapSize = 0L;
        }
    }

    @Override
    protected synchronized AbstractPage createPage(int size) throws IOException {
        AbstractPage page;
        if (size < 1) {
            throw new IOException("Invalid page size: " + size);
        }
        if (this.maxJavaHeapSize - this.javaHeapSize >= (long)size && (page = this.createByteArrayPage(size)) != null) {
            return page;
        }
        if (this.maxDirectHeapSize - this.directHeapSize >= (long)size) {
            if (this.useJnaMemory && (page = this.createJnaMemoryPage(size)) != null) {
                return page;
            }
            if (this.useUnsafeDirectMemory && (page = this.createUnsafePage(size)) != null) {
                return page;
            }
            page = this.createByteBufferPage(size);
            if (page != null) {
                return page;
            }
        }
        return null;
    }

    protected synchronized ByteArrayPage createByteArrayPage(int size) {
        try {
            byte[] array = new byte[size];
            this.javaHeapSize += (long)size;
            return new ByteArrayPage((Area)this, array);
        }
        catch (OutOfMemoryError e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected synchronized ByteBufferPage createByteBufferPage(int size) {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            this.directHeapSize += (long)size;
            return new ByteBufferPage(this, buffer, this.cb);
        }
        catch (OutOfMemoryError e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected synchronized AbstractPage createJnaMemoryPage(int size) {
        try {
            AbstractPage page = SupportJnaMemory.allocateJnaMemoryPage(this, size, this.cb);
            this.directHeapSize += (long)size;
            return page;
        }
        catch (OutOfMemoryError e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected synchronized AbstractPage createUnsafePage(int size) {
        try {
            AbstractPage page = SupportUnsafePage.allocateUnsafePage(this, size, this.cb);
            this.directHeapSize += (long)size;
            return page;
        }
        catch (OutOfMemoryError e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

