/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.Data;
import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SupportUnsafePage {
    private static final Logger logger = Logger.getLogger(SupportUnsafePage.class.getName());
    private static final String UNSAFE_PAGE_CLASS_NAME = "com.spacekiller.util.heap.j16.UnsafePage";
    private static final String CREATE_UNSAFE_PAGE_METHOD = "createUnsafePage";
    private static Method createUnsafePageMethod = SupportUnsafePage.initUnsafePageCreateMethod();

    private SupportUnsafePage() {
    }

    private static Method initUnsafePageCreateMethod() {
        try {
            Class<?> unsafePageClass = Class.forName(UNSAFE_PAGE_CLASS_NAME);
            Method createMethod = unsafePageClass.getMethod(CREATE_UNSAFE_PAGE_METHOD, Area.class, Integer.TYPE, byte[].class);
            return createMethod;
        }
        catch (ClassNotFoundException e) {
            logger.info("UnsafePage is not supported: class not found");
        }
        catch (NoSuchMethodException e) {
            logger.info("UnsafePage is not supported: constructor not found");
        }
        catch (Throwable e) {
            logger.info("UnsafePage is not supported: " + e);
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    static final AbstractPage allocateUnsafePage(Area area, int size, byte[] copyBuf) throws Exception {
        if (createUnsafePageMethod == null) {
            return null;
        }
        return (AbstractPage)createUnsafePageMethod.invoke(null, area, Data.toInteger((int)size), copyBuf);
    }
}

