/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap;

import com.spacekiller.util.Platform;
import com.spacekiller.util.heap.AbstractArea;
import com.spacekiller.util.heap.AbstractHeapManager;
import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.SwapFilePage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwapFileArea
extends AbstractArea {
    private static final Logger logger = Logger.getLogger(SwapFileArea.class.getName());
    protected static final int SWAP_FILE_MAGIC = -88016192;
    protected static final int SWAP_FILE_VERSION_0 = 0;
    protected static final int SWAP_FILE_VERSION = 0;
    protected static final int SWAP_FILE_HEADER_SIZE = 8;
    protected final long maxSwapSize;
    protected final String namePrefix;
    protected final String nameSuffix;
    private File swapFile;
    private RandomAccessFile raf;
    private FileChannel fc;
    private byte[] cb;
    private long fileSize;
    private long swapSize;
    private Hole firstHole;
    private Hole lastHole;

    public SwapFileArea(String name, AbstractHeapManager manager, AbstractArea parent, int pageSize, long maxSwapSize, String namePrefix, String nameSuffix, byte[] copyBuf) {
        super(name, manager, parent, pageSize);
        if (maxSwapSize < 0L) {
            maxSwapSize = 0L;
        }
        this.maxSwapSize = maxSwapSize;
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.cb = copyBuf;
    }

    @Override
    public long limit() {
        return this.maxSwapSize;
    }

    @Override
    protected synchronized void discardPage(AbstractPage page) throws IOException {
        if (page.area != this) {
            throw new IllegalArgumentException("Invalid page: " + page);
        }
        int pageSize = page.size;
        if (pageSize < 1) {
            return;
        }
        this.swapSize -= (long)pageSize;
        if (this.swapSize < 0L) {
            this.swapSize = 0L;
        }
        long pagePos = -1L;
        if (page instanceof SwapFilePage) {
            SwapFilePage swapFilePage = (SwapFilePage)page;
            pagePos = swapFilePage.pos;
        }
        page.dispose();
        if (pagePos < 0L || pageSize < 1) {
            return;
        }
        long pageEnd = pagePos + (long)pageSize;
        Hole prev = null;
        Hole hole = this.firstHole;
        while (hole != null && hole.pos <= pageEnd) {
            if (hole.pos == pageEnd) {
                hole.pos = pagePos;
                hole.len += (long)pageSize;
                return;
            }
            if (hole.pos + hole.len == pagePos) {
                hole.len += (long)pageSize;
                Hole next = hole.next;
                if (next == null) {
                    if (hole.pos + hole.len == this.fileSize) {
                        this.truncateSwapFile(hole.pos);
                    }
                } else if (next.pos == pageEnd) {
                    hole.len += next.len;
                    if (next.next == null) {
                        hole.next = null;
                        this.lastHole = hole;
                        if (hole.pos + hole.len == this.fileSize) {
                            this.truncateSwapFile(hole.pos);
                        }
                    } else {
                        hole.next = next.next;
                        next.next.prev = hole;
                    }
                }
                return;
            }
            prev = hole;
            hole = hole.next;
        }
        if (pagePos + (long)pageSize == this.fileSize) {
            this.truncateSwapFile(pagePos);
            return;
        }
        hole = new Hole();
        hole.pos = pagePos;
        hole.len = pageSize;
        Hole next = null;
        if (prev == null) {
            next = this.firstHole;
            this.firstHole = hole;
        } else {
            next = prev.next;
            hole.prev = prev;
            prev.next = hole;
        }
        if (next == null) {
            this.lastHole = hole;
        } else {
            hole.next = next;
            next.prev = hole;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateSwapFile(long newFileSize) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Truncating swap file: newFileSize=" + newFileSize);
        }
        Object object = this;
        synchronized (object) {
            if (newFileSize <= 8L && this.swapSize < 1L) {
                block18: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Deleting empty swap file: " + this.swapFile);
                    }
                    try {
                        if (this.raf == null) break block18;
                        RandomAccessFile randomAccessFile = this.raf;
                        synchronized (randomAccessFile) {
                            this.raf.setLength(8L);
                            this.raf.close();
                            if (this.fc != null) {
                                this.fc.close();
                            }
                        }
                        File file = this.swapFile;
                        if (file != null) {
                            this.swapFile = null;
                            if (!file.delete()) {
                                logger.warning("Unable to delete empty swap file: " + file);
                            }
                        }
                    }
                    finally {
                        this.fc = null;
                        this.raf = null;
                        this.fileSize = 0L;
                        this.swapSize = 0L;
                        this.firstHole = null;
                        this.lastHole = null;
                    }
                }
                return;
            }
            this.fileSize = newFileSize;
        }
        object = this.raf;
        synchronized (object) {
            this.raf.setLength(newFileSize);
        }
    }

    @Override
    protected synchronized AbstractPage createPage(int size) throws IOException {
        if (size < 1) {
            throw new IOException("Invalid page size: " + size);
        }
        if (this.maxSwapSize - this.swapSize < (long)size) {
            return null;
        }
        if (this.raf == null) {
            this.lazyInitSwapFile();
        }
        long pos = -1L;
        Hole hole = this.firstHole;
        while (hole != null) {
            if (hole.len >= (long)size) {
                pos = hole.pos;
                hole.pos += (long)size;
                hole.len -= (long)size;
                if (hole.len >= 1L) break;
                if (hole.prev == null) {
                    this.firstHole = hole.next;
                } else {
                    hole.prev.next = hole.next;
                }
                if (hole.next == null) {
                    this.lastHole = hole.prev;
                    break;
                }
                hole.next.prev = hole.prev;
                break;
            }
            hole = hole.next;
        }
        if (pos < 0L) {
            pos = this.fileSize;
            this.fileSize += (long)size;
        }
        SwapFilePage page = new SwapFilePage(this, size, pos, this.cb, this.raf, this.fc);
        this.swapSize += (long)size;
        return page;
    }

    protected synchronized void lazyInitSwapFile() throws IOException {
        this.swapFile = Platform.getInstance().createTempFile(this.namePrefix, this.nameSuffix);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating swap file: " + this.swapFile);
        }
        this.raf = new RandomAccessFile(this.swapFile, "rw");
        this.fileSize = 8L;
        this.raf.setLength(0L);
        this.fc = this.raf.getChannel();
        this.writeHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(0L);
            this.raf.writeInt(-88016192);
            this.raf.writeInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() throws IOException {
        super.check();
        SwapFileArea swapFileArea = this;
        synchronized (swapFileArea) {
            Hole prev = null;
            Hole hole = this.firstHole;
            while (hole != null) {
                if (hole.prev != prev) {
                    throw new IOException("Invalid prev hole: " + hole.prev + " != " + prev);
                }
                if (prev != null) {
                    if (hole.len < 1L) {
                        throw new IOException("Invalid hole length: " + hole.len + " < 1");
                    }
                    if (hole.pos < prev.pos + prev.len) {
                        throw new IOException("Invalid hole position: " + hole.pos + " < " + (prev.pos + prev.len));
                    }
                    if (hole.pos + hole.len > this.fileSize) {
                        throw new IOException("Invalid hole bounds: " + (hole.pos + hole.len) + " > " + this.fileSize);
                    }
                }
                prev = hole;
                hole = hole.next;
            }
            if (prev != this.lastHole) {
                throw new IOException("Invalid last hole: " + prev + " != " + this.lastHole);
            }
        }
    }

    protected class Hole {
        protected long pos;
        protected long len;
        protected Hole prev;
        protected Hole next;

        protected Hole() {
        }
    }
}

