/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi;

import javax.sound.midi.MidiMessage;

public interface MidiFilter {
    public static final AcceptAllFilter ACCEPT_ALL_FILTER = new AcceptAllFilter();
    public static final SpamFilter SPAM_FILTER = new SpamFilter();

    public boolean accept(int var1);

    public boolean accept(int var1, int var2);

    public boolean accept(int var1, int var2, int var3);

    public boolean accept(MidiMessage var1);

    public static class SpamFilter
    implements MidiFilter {
        @Override
        public boolean accept(int status) {
            switch (status) {
                case 248: 
                case 254: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean accept(int status, int data1) {
            return this.accept(status);
        }

        @Override
        public boolean accept(int status, int data1, int data2) {
            return this.accept(status);
        }

        @Override
        public boolean accept(MidiMessage msg) {
            return this.accept(msg.getStatus());
        }
    }

    public static class AcceptAllFilter
    implements MidiFilter {
        @Override
        public boolean accept(int status) {
            return true;
        }

        @Override
        public boolean accept(int status, int data1) {
            return true;
        }

        @Override
        public boolean accept(int status, int data1, int data2) {
            return true;
        }

        @Override
        public boolean accept(MidiMessage msg) {
            return true;
        }
    }
}

