/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi;

public interface MidiMeta {
    public static final int TYPE_SEQUENCE_NUMBER = 0;
    public static final int TYPE_TEXT_EVENT = 1;
    public static final int TYPE_COPYRIGHT_NOTICE = 2;
    public static final int TYPE_SEQUENCE_NAME = 3;
    public static final int TYPE_INSTRUMENT_NAME = 4;
    public static final int TYPE_LYRIC_TEXT = 5;
    public static final int TYPE_MARKER_TEXT = 6;
    public static final int TYPE_CUE_POINT = 7;
    public static final int TYPE_PROGRAM_NAME = 8;
    public static final int TYPE_DEVICE_NAME = 9;
    public static final int TYPE_MIDI_CHANNEL_PREFIX_ASSIGNMENT = 32;
    public static final int TYPE_MIDI_PORT = 33;
    public static final int TYPE_END_OF_TRACK = 47;
    public static final int TYPE_TEMPO_SETTING = 81;
    public static final int TYPE_SMPTE_OFFSET = 84;
    public static final int TYPE_TIME_SIGNATURE = 88;
    public static final int TYPE_KEY_SIGNATURE = 89;
    public static final int TYPE_SEQUENCER_SPECIFIC_EVENT = 127;

    public int getType();

    public int getSize();

    public void read(int var1, byte[] var2, int var3, int var4) throws ArrayIndexOutOfBoundsException;

    public static interface SequencerSpecificEvent
    extends MidiMeta {
    }

    public static interface KeySignature
    extends MidiMeta {
    }

    public static interface TimeSignature
    extends MidiMeta {
    }

    public static interface SmpteOffset
    extends MidiMeta {
    }

    public static interface TempoSetting
    extends MidiMeta {
        public int getMicrosecondsPerQuarterNote();

        public double getBeatsPerMinute();
    }

    public static interface EndOfTrack
    extends MidiMeta {
    }

    public static interface MidiPort
    extends MidiMeta {
        public int getMidiPort();
    }

    public static interface MidiChannelPrefixAssignment
    extends MidiMeta {
        public int getMidiChannel();
    }

    public static interface DeviceName
    extends Text {
    }

    public static interface ProgramName
    extends Text {
    }

    public static interface CuePoint
    extends Text {
    }

    public static interface MarkerText
    extends Text {
    }

    public static interface LyricText
    extends Text {
    }

    public static interface InstrumentName
    extends Text {
    }

    public static interface SequenceName
    extends Text {
    }

    public static interface CopyrightNotice
    extends Text {
    }

    public static interface TextEvent
    extends Text {
    }

    public static interface SequenceNumber
    extends MidiMeta {
        public int getSequenceNumber();
    }

    public static interface Text
    extends MidiMeta {
        public String getText();
    }
}

