/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.DefaultMidiManager;
import com.spacekiller.util.midi.impl.MidiDeviceHandler;
import com.spacekiller.util.midi.impl.MidiDeviceReceiver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class DefaultMidiFactory
implements MidiFactory {
    private static final Logger logger = Logger.getLogger(DefaultMidiFactory.class.getName());
    private static MidiFactory instance;
    private MidiDevice.Info[] midiDeviceInfo;
    private Map devInfoMap = new HashMap();
    private boolean shutdownHookInstalled;
    private Thread shutdownHook;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MidiFactory getInstance() {
        if (instance != null) return instance;
        Class<DefaultMidiFactory> clazz = DefaultMidiFactory.class;
        synchronized (DefaultMidiFactory.class) {
            if (instance != null) return instance;
            instance = new DefaultMidiFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public MidiDevice.Info[] getMidiDeviceInfo() {
        MidiDevice.Info[] array = this.midiDeviceInfo;
        if (array == null) {
            this.midiDeviceInfo = array = MidiSystem.getMidiDeviceInfo();
        }
        MidiDevice.Info[] copy = new MidiDevice.Info[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    @Override
    public void refreshMidiDeviceInfo() {
        this.midiDeviceInfo = null;
    }

    @Override
    public MidiManager createMidiManager() {
        return new DefaultMidiManager(this);
    }

    protected Receiver createReceiver(MidiDeviceHandler handler) {
        MidiDevice device = handler.getDevice();
        return new MidiDeviceReceiver(device, handler);
    }

    protected synchronized MidiDeviceHandler openMidiDevice(MidiDevice device, DefaultMidiManager manager) throws MidiUnavailableException {
        DevInfo info = (DevInfo)this.devInfoMap.get(device);
        if (info == null) {
            if (!this.shutdownHookInstalled) {
                if (this.shutdownHook == null) {
                    this.shutdownHook = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DefaultMidiFactory.this.closeAllMidiDevices();
                        }
                    });
                }
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                this.shutdownHookInstalled = true;
            }
            MidiDeviceHandler handler = new MidiDeviceHandler(device);
            Transmitter trans = null;
            if (device.getMaxTransmitters() != 0 && (trans = device.getTransmitter()) != null) {
                Receiver receiver = this.createReceiver(handler);
                trans.setReceiver(receiver);
            }
            device.open();
            info = new DevInfo(device, handler, trans);
            this.devInfoMap.put(device, info);
        }
        info.managers.add(manager);
        return info.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeMidiDevice(MidiDevice device, DefaultMidiManager manager) {
        DevInfo info = null;
        boolean closeDevice = false;
        DefaultMidiFactory defaultMidiFactory = this;
        synchronized (defaultMidiFactory) {
            info = (DevInfo)this.devInfoMap.get(device);
            if (info == null) {
                return;
            }
            if (!info.managers.remove(manager)) {
                return;
            }
            if (info.managers.isEmpty()) {
                closeDevice = true;
                this.devInfoMap.remove(device);
                if (this.devInfoMap.isEmpty() && this.shutdownHookInstalled) {
                    this.removeShutdownHook();
                }
            }
        }
        if (closeDevice && info != null) {
            this.closeMidiDevice(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllMidiDevices() {
        DevInfo[] devInfos = null;
        DefaultMidiFactory defaultMidiFactory = this;
        synchronized (defaultMidiFactory) {
            int devCount = this.devInfoMap.size();
            if (devCount > 0) {
                devInfos = this.devInfoMap.values().toArray(new DevInfo[devCount]);
            }
        }
        if (devInfos != null) {
            int devCount = devInfos.length;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Closing MidiDevice(s): " + devCount);
            }
            for (int i = 0; i < devCount; ++i) {
                DevInfo info = devInfos[i];
                if (info == null) continue;
                this.closeMidiDevice(info);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Closed MidiDevice(s).");
            }
        }
        DefaultMidiFactory defaultMidiFactory2 = this;
        synchronized (defaultMidiFactory2) {
            if (this.devInfoMap.isEmpty() && this.shutdownHookInstalled) {
                this.removeShutdownHook();
            }
        }
    }

    protected void closeMidiDevice(DevInfo info) {
        MidiDevice device;
        Transmitter trans = info.trans;
        if (trans != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Closing MidiTransmitter: " + trans);
            }
            trans.close();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("MidiTransmitter closed: " + trans);
            }
        }
        if ((device = info.device) != null) {
            MidiDevice.Info devInfo = device.getDeviceInfo();
            String devInfoString = String.valueOf(devInfo);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Closing MidiDevice: " + device + " -> " + devInfoString);
            }
            device.close();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("MidiDevice closed: " + device + " -> " + devInfoString);
            }
        }
    }

    private void removeShutdownHook() {
        if (!this.shutdownHookInstalled) {
            return;
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHookInstalled = false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected static class DevInfo {
        MidiDevice device;
        MidiDeviceHandler handler;
        Transmitter trans;
        Set managers;

        public DevInfo(MidiDevice device, MidiDeviceHandler handler, Transmitter trans) {
            this.device = device;
            this.handler = handler;
            this.trans = trans;
            this.managers = new HashSet();
        }
    }
}

