/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.midi.MidiFormatter;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;

public class DefaultMidiFormatter
implements MidiFormatter {
    private static DefaultMidiFormatter SHARED_INSTANCE;
    private static final String[] KEYS;
    private static final String[] DRUMKEYS;
    private static final String[] CONTROLLERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultMidiFormatter getSharedInstance() {
        if (SHARED_INSTANCE != null) return SHARED_INSTANCE;
        Class<DefaultMidiFormatter> clazz = DefaultMidiFormatter.class;
        synchronized (DefaultMidiFormatter.class) {
            if (SHARED_INSTANCE != null) return SHARED_INSTANCE;
            SHARED_INSTANCE = new DefaultMidiFormatter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SHARED_INSTANCE;
        }
    }

    @Override
    public String formatMidiMessage(MidiMessage message) {
        StringBuffer sb = new StringBuffer();
        this.formatMidiMessage(message, sb);
        return sb.toString();
    }

    @Override
    public String formatMidiEvent(MidiMessage message, long timeStamp) {
        StringBuffer sb = new StringBuffer();
        sb.append('[').append(timeStamp).append("] ");
        this.formatMidiMessage(message, sb);
        return sb.toString();
    }

    @Override
    public String formatMidiEvent(MidiEvent event) {
        return this.formatMidiEvent(event.getMessage(), event.getTick());
    }

    @Override
    public String getProgramName(int program) {
        return null;
    }

    @Override
    public String getNoteKeyName(int key) {
        if (key >= 0 && key < KEYS.length) {
            return KEYS[key];
        }
        return "?" + key;
    }

    @Override
    public String getDrumKeyName(int key) {
        if (key >= 0 && key < DRUMKEYS.length) {
            return DRUMKEYS[key];
        }
        return "?" + key;
    }

    @Override
    public String getControllerName(int controller) {
        if (controller >= 0 && controller < CONTROLLERS.length) {
            return CONTROLLERS[controller];
        }
        return String.valueOf(controller);
    }

    protected void formatMidiMessage(MidiMessage message, StringBuffer sb) {
        byte[] data = message.getMessage();
        int status = data[0] & 0xFF;
        if (status >= 240) {
            switch (status) {
                case 241: {
                    sb.append("MIDI_TIME_CODE");
                    return;
                }
                case 242: {
                    int lsb = data[1] & 0xFF;
                    int msb = data[2] & 0xFF;
                    int pos = msb << 7 | lsb;
                    sb.append("SONG_POSITION_POINTER[pos=" + pos + "]");
                    return;
                }
                case 243: {
                    sb.append("SONG_SELECT[song=" + data[1] + "]");
                    return;
                }
                case 246: {
                    sb.append("TUNE_REQUEST");
                    return;
                }
                case 248: {
                    sb.append("TIMING_CLOCK");
                    return;
                }
                case 250: {
                    sb.append("START");
                    return;
                }
                case 251: {
                    sb.append("CONTINUE");
                    return;
                }
                case 252: {
                    sb.append("STOP");
                    return;
                }
                case 254: {
                    sb.append("ACTIVE_SENSING");
                    return;
                }
                case 255: {
                    sb.append("SYSTEM_RESET");
                    return;
                }
                case 240: {
                    sb.append("SYSTEM_EXCLUSIVE[size=" + (message.getLength() - 1) + "]");
                    return;
                }
                case 247: {
                    sb.append("END_SYSTEM_EXCLUSIVE");
                    return;
                }
            }
            sb.append("UNDEFINED (Reserved): " + status);
            return;
        }
        if (status < 128) {
            sb.append("UNKNOWN[" + status + "]");
        }
        int channel = status & 0xF;
        sb.append("Channel[" + channel + "]: ");
        switch (status & 0xF0) {
            case 176: {
                byte controller = data[1];
                byte value = data[2];
                sb.append("CONTROL_CHANGE[controller=" + controller + ", value=" + value + "]");
                switch (controller) {
                    case 120: {
                        sb.append(" (All Sound Off)");
                        return;
                    }
                    case 121: {
                        sb.append(" (Reset All Controllers)");
                        return;
                    }
                    case 122: {
                        sb.append(" (Local Control=" + (value != 0) + ")");
                        return;
                    }
                    case 123: {
                        sb.append(" (All Notes Off)");
                        return;
                    }
                    case 124: {
                        sb.append(" (Omni Mode Off)");
                        return;
                    }
                    case 125: {
                        sb.append(" (Omni Mode On)");
                        return;
                    }
                    case 126: {
                        sb.append(" (Mono Mode)");
                        return;
                    }
                    case 127: {
                        sb.append(" (Poly Mode)");
                        return;
                    }
                }
                return;
            }
            case 128: {
                sb.append("NOTE_OFF[note=" + data[1] + ", velocity=" + data[2] + "]");
                return;
            }
            case 144: {
                sb.append("NOTE_ON[note=" + data[1] + ", velocity=" + data[2] + "]");
                return;
            }
            case 160: {
                sb.append("POLY_PRESSURE[note=" + data[1] + ", velocity=" + data[2] + "]");
                return;
            }
            case 192: {
                sb.append("PROGRAM_CHANGE[program=" + data[1] + "]");
                return;
            }
            case 208: {
                sb.append("CHANNEL_PRESSURE[velocity=" + data[1] + "]");
                return;
            }
            case 224: {
                int lsb = data[1] & 0x7F;
                int msb = data[2] & 0x7F;
                int bend = msb << 7 | lsb;
                sb.append("PITCH_BEND[bend=" + bend + "]");
                return;
            }
        }
        sb.append("UNKNOWN[" + status + "]");
    }

    static {
        KEYS = new String[]{"C-2", "C#-2", "D-2", "D#-2", "E-2", "F-2", "F#-2", "G-2", "G#-2", "A-2", "A#-2", "B-2", "C-1", "C#-1", "D-1", "D#-1", "E-1", "F-1", "F#-1", "G-1", "G#-1", "A-1", "A#-1", "B-1", "C0", "C#0", "D0", "D#0", "E0", "F0", "F#0", "G0", "G#0", "A0", "A#0", "B0", "C1", "C#1", "D1", "D#1", "E1", "F1", "F#1", "G1", "G#1", "A1", "A#1", "B1", "C2", "C#2", "D2", "D#2", "E2", "F2", "F#2", "G2", "G#2", "A2", "A#2", "B2", "C3", "C#3", "D3", "D#3", "E3", "F3", "F#3", "G3", "G#3", "A3", "A#3", "B3", "C4", "C#4", "D4", "D#4", "E4", "F4", "F#4", "G4", "G#4", "A4", "A#4", "B4", "C5", "C#5", "D5", "D#5", "E5", "F5", "F#5", "G5", "G#5", "A5", "A#5", "B5", "C6", "C#6", "D6", "D#6", "E6", "F6", "F#6", "G6", "G#6", "A6", "A#6", "B6", "C7", "C#7", "D7", "D#7", "E7", "F7", "F#7", "G7", "G#7", "A7", "A#7", "B7", "C8"};
        DRUMKEYS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "High Q", "Slap", "Scratch 1", "Scratch 2", "Sticks", "Square Click", "Metronome Click", "Metronome Bell", "Kick Drum 2", "Kick Drum1", "Side Stick", "Snare Drum 1", "Hand Clap", "Snare Drum 2", "Low Tom 2", "Closed High-Hat", "Low tom 1", "Pedal High-Hat", "Mid Tom 2", "Open High-Hat", "Mid Tom 1", "High Tom 2", "Crash Cymbal 1", "High Tom 1", "Ride Cymbal 1", "Chenese Cymbal", "Ride Bell", "Tambourine", "Splash Cymbal", "Cowbell", "Crash Cymbal 2", "Vibra Slap", "Ride Cymbal 2", "High Bongo", "Low Bongo", "Mute High Conga", "Open High Conga", "Low Conga", "High Timbal", "Low Timbal", "High Agogo", "Low Agogo", "Cabasa", "Maracas", "Short High Whistle", "Long Low Whistle", "Short Guiro", "Long Guiro", "Claves", "High Wood Block", "Low Wood Block", "Mute Cuica", "Open Cuica", "Mute Triangle", "Open Triangle", "Shaker", "Jingle Bell", "Bell Tree", "Castanets", "Mute Surdo", "Open Surdo", "Slap High Conga", "Small Gong", "Big Gong", "Mute Pandiero", "Open Pandiero", "Tambourine", "Tree Chime", "Caxixi"};
        CONTROLLERS = new String[]{"Bank Select MSB", "Modulation", "Breath Controller", "3", "Foot Pedal", "Portamento Time", "DataEntry MSB", "Volume", "Balance", "9", "Panpot", "Expression", "12", "13", "14", "15", "General Purpose 1", "General Purpose 2", "General Purpose 3", "General Purpose 4", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "Bank Select LSB", "Modulation LSB", "Breath Controller LSB", "LSB", "Foot Pedal LSB", "Portamento Time LSB", "DataEntry LSB", "Volume LSB", "Balance LSB", "LSB", "Panpot LSB", "Expression LSB", "44", "45", "46", "47", "General Purpose 1 LSB", "General Purpose 2 LSB", "General Purpose 3 LSB", "General Purpose 4 LSB", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "Sustain Pedal", "Portamento", "Sustenuto", "Soft Pedal", "68", "Hold 2", "70", "Harmonic Content (XG)", "Release Time (XG)", "Attack Time (XG)", "Brightness (XG)", "75", "76", "77", "78", "79", "General Purpose 5", "General Purpose 6", "General Purpose 7", "General Purpose 8", "84", "85", "86", "87", "88", "89", "90", "External Effects Depth", "Tremolo Depth", "Chorus Depth", "Celeste Depth", "Phaser Depth", "Data Increment", "Data Decrement", "Non Registered Parameter LSB", "Non Registered Parameter MSB", "Registered Parameter LSB", "Registered Parameter MSB"};
    }
}

