/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.impl;

import com.spacekiller.util.Data;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.MidiDeviceHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;

public class DefaultMidiManager
implements MidiManager {
    private DefaultMidiFactory midiFactory;
    private Map deviceHandlerMap;
    private Map deviceListeners;
    private Set globalListeners;

    public DefaultMidiManager(DefaultMidiFactory midiFactory) {
        this.midiFactory = midiFactory;
        this.deviceHandlerMap = new HashMap();
        this.deviceListeners = new HashMap();
        this.globalListeners = new HashSet();
    }

    @Override
    public MidiDevice.Info[] getMidiDeviceInfo() {
        return this.midiFactory.getMidiDeviceInfo();
    }

    @Override
    public MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        return MidiSystem.getMidiDevice(info);
    }

    @Override
    public void refreshMidiDeviceInfo() {
        this.midiFactory.refreshMidiDeviceInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openMidiDevice(MidiDevice midiDevice) throws MidiUnavailableException {
        boolean success;
        if (midiDevice == null) {
            return;
        }
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            if (this.deviceHandlerMap.containsKey(midiDevice)) {
                return;
            }
        }
        MidiDeviceHandler handler = this.midiFactory.openMidiDevice(midiDevice, this);
        DefaultMidiManager defaultMidiManager2 = this;
        synchronized (defaultMidiManager2) {
            if (this.deviceHandlerMap.containsKey(midiDevice)) {
                success = true;
            } else {
                this.deviceHandlerMap.put(midiDevice, handler);
                for (MidiListener listener : this.globalListeners) {
                    handler.addMidiListener(listener);
                }
                Map m = (Map)this.deviceListeners.get(midiDevice);
                if (m != null) {
                    Iterator i = m.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry me = i.next();
                        int channel = (Integer)me.getKey();
                        Set s = (Set)me.getValue();
                        Iterator k = s.iterator();
                        while (i.hasNext()) {
                            MidiListener listener = (MidiListener)k.next();
                            if (channel < 0) {
                                handler.addMidiListener(listener);
                                continue;
                            }
                            handler.addMidiListener(listener, channel);
                        }
                    }
                }
                success = true;
            }
        }
        if (!success) {
            this.midiFactory.closeMidiDevice(midiDevice, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeMidiDevice(MidiDevice midiDevice) {
        if (midiDevice == null) {
            return;
        }
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            MidiDeviceHandler handler = (MidiDeviceHandler)this.deviceHandlerMap.remove(midiDevice);
            if (handler == null) {
                return;
            }
            for (MidiListener listener : this.globalListeners) {
                handler.removeMidiListener(listener);
            }
            Map m = (Map)this.deviceListeners.get(midiDevice);
            if (m != null) {
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry me = i.next();
                    int channel = (Integer)me.getKey();
                    Set s = (Set)me.getValue();
                    Iterator k = s.iterator();
                    while (i.hasNext()) {
                        MidiListener listener = (MidiListener)k.next();
                        if (channel < 0) {
                            handler.removeMidiListener(listener);
                            continue;
                        }
                        handler.removeMidiListener(listener, channel);
                    }
                }
            }
        }
        this.midiFactory.closeMidiDevice(midiDevice, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllMidiDevices() {
        LinkedList midiDeviceList = null;
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            if (!this.deviceHandlerMap.isEmpty()) {
                midiDeviceList = new LinkedList();
                midiDeviceList.addAll(this.deviceHandlerMap.keySet());
                this.deviceHandlerMap.clear();
            }
        }
        if (midiDeviceList != null) {
            for (MidiDevice midiDevice : midiDeviceList) {
                this.midiFactory.closeMidiDevice(midiDevice, this);
            }
        }
    }

    @Override
    public void close() {
        this.closeAllMidiDevices();
        this.midiFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMidiListener(MidiListener listener, MidiDevice device, int channel) {
        if (listener == null) {
            return;
        }
        if (channel < -1 || channel > 15) {
            throw new IllegalArgumentException("Invalid midi channel: " + channel);
        }
        Integer ch = Data.toInteger((int)channel);
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            MidiDeviceHandler handler;
            HashSet<MidiListener> s;
            HashMap<Integer, HashSet<MidiListener>> m = (HashMap<Integer, HashSet<MidiListener>>)this.deviceListeners.get(device);
            if (m == null) {
                m = new HashMap<Integer, HashSet<MidiListener>>();
                this.deviceListeners.put(device, m);
            }
            if ((s = (HashSet<MidiListener>)m.get(ch)) == null) {
                s = new HashSet<MidiListener>();
                m.put(ch, s);
            }
            if (s.add(listener) && (handler = (MidiDeviceHandler)this.deviceHandlerMap.get(device)) != null) {
                if (channel < 0) {
                    handler.addMidiListener(listener);
                } else {
                    handler.addMidiListener(listener, channel);
                }
            }
        }
    }

    @Override
    public void addMidiListener(MidiListener listener, MidiDevice device) {
        this.addMidiListener(listener, device, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMidiListener(MidiListener listener) {
        if (listener == null) {
            return;
        }
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            if (this.globalListeners.add(listener)) {
                for (MidiDeviceHandler handler : this.deviceHandlerMap.values()) {
                    handler.addMidiListener(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMidiListener(MidiListener listener, MidiDevice device, int channel) {
        if (listener == null) {
            return;
        }
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            MidiDeviceHandler handler;
            Set s;
            Map m = (Map)this.deviceListeners.get(device);
            if (m != null && (s = (Set)m.get(Data.toInteger((int)channel))) != null && s.remove(listener) && (handler = (MidiDeviceHandler)this.deviceHandlerMap.get(device)) != null) {
                if (channel < 0) {
                    handler.removeMidiListener(listener);
                } else {
                    handler.removeMidiListener(listener, channel);
                }
            }
        }
    }

    @Override
    public void removeMidiListener(MidiListener listener, MidiDevice device) {
        this.removeMidiListener(listener, device, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMidiListener(MidiListener listener) {
        if (listener == null) {
            return;
        }
        DefaultMidiManager defaultMidiManager = this;
        synchronized (defaultMidiManager) {
            if (this.globalListeners.remove(listener)) {
                for (MidiDeviceHandler handler : this.deviceHandlerMap.values()) {
                    handler.removeMidiListener(listener);
                }
            }
        }
    }
}

